/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;

public class FileByteStore
implements ByteStore {
    private final File file_;
    private final OutputStream out_;
    private static final int BUFSIZ = 65536;
    private final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    public FileByteStore() throws IOException {
        this.file_ = File.createTempFile("FileByteStore", ".tmp");
        this.logger_.info("Creating new temporary file: " + this.file_);
        this.file_.deleteOnExit();
        this.out_ = new FileOutputStream(this.file_);
    }

    public OutputStream getOutputStream() {
        return this.out_;
    }

    public void copy(OutputStream out) throws IOException {
        int n;
        this.out_.flush();
        FileInputStream in = new FileInputStream(this.file_);
        byte[] buf = new byte[65536];
        while ((n = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, n);
        }
    }

    public void close() {
        if (this.file_.delete()) {
            this.logger_.info("Deleting temporary file: " + this.file_);
        }
    }
}

