/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.utilities.TextUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SimpleMeasurement
implements Measurement {
    private Double flux;
    private Double frequency;
    private List<String> names = new ArrayList<String>();
    private Double ra;
    private Double dec;
    private Date date;
    private Integer sourceId;
    private Integer catalogId;
    private Double uvMin;
    private Double uvMax;

    public SimpleMeasurement date(Date date) {
        this.date = date;
        return this;
    }

    public SimpleMeasurement names(List<String> names) {
        this.names.clear();
        this.names.addAll(names);
        return this;
    }

    public SimpleMeasurement name(String name) {
        this.names.clear();
        this.names.add(name);
        return this;
    }

    public SimpleMeasurement sourceId(Integer id) {
        this.sourceId = id;
        return this;
    }

    public SimpleMeasurement catalogId(Integer id) {
        this.catalogId = id;
        return this;
    }

    public SimpleMeasurement flux(Double flux) {
        this.flux = flux;
        return this;
    }

    public SimpleMeasurement ra(Double ra) {
        this.ra = ra;
        return this;
    }

    public SimpleMeasurement dec(Double dec) {
        this.dec = dec;
        return this;
    }

    public SimpleMeasurement frequency(Double frequency) {
        this.frequency = frequency;
        return this;
    }

    public SimpleMeasurement uvMin(Double uvMin) {
        this.uvMin = uvMin;
        return this;
    }

    public SimpleMeasurement uvMax(Double uvMax) {
        this.uvMin = uvMax;
        return this;
    }

    @Override
    public Integer getId() {
        return null;
    }

    @Override
    public Integer getCatalogueId() {
        return this.catalogId;
    }

    @Override
    public Integer getSourceId() {
        return this.sourceId;
    }

    @Override
    public Double getRa() {
        return this.ra;
    }

    @Override
    public Double getRaUncertainty() {
        return null;
    }

    @Override
    public Double getDec() {
        return this.dec;
    }

    @Override
    public Double getDecUncertainty() {
        return null;
    }

    @Override
    public Double getFrequency() {
        return this.frequency;
    }

    @Override
    public Double getFlux() {
        return this.flux;
    }

    @Override
    public Double getFluxUncertainty() {
        return null;
    }

    @Override
    public Double getPolarizationDegree() {
        return null;
    }

    @Override
    public Double getPolarizationDegreeUncertainty() {
        return null;
    }

    @Override
    public Double getPolarizationAngle() {
        return null;
    }

    @Override
    public Double getPolarizationAngleUncertainty() {
        return null;
    }

    @Override
    public Date getDateObserved() {
        return this.date;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getFormattedName() {
        return TextUtils.join(this.getNames(), "; ");
    }

    @Override
    public Double getUvMin() {
        return this.uvMin;
    }

    @Override
    public Double getUvMax() {
        return this.uvMax;
    }
}

