/*
 * Decompiled with CFR 0.152.
 */
package alma.acacorrelator.ACACorrConfigValidator;

import alma.ACS.stringSeqHolder;
import alma.AccumModeMod.AccumMode;
import alma.AtmPhaseCorrectionMod.AtmPhaseCorrection;
import alma.BasebandNameMod.BasebandName;
import alma.CorrelationModeMod.CorrelationMode;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.BinSwitching_t;
import alma.Correlator.CorrelatorConfiguration;
import alma.Correlator.SpectralWindow;
import alma.NetSidebandMod.NetSideband;
import alma.SidebandProcessingModeMod.SidebandProcessingMode;
import alma.StokesParameterMod.StokesParameter;
import alma.SwitchingModeMod.SwitchingMode;
import alma.SynthProfMod.SynthProf;
import alma.acacorrelator.ACACorrConfigValidator.ACA_XMLUnmarshaller;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidatorBase;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ACA_CorrConfigValidator {
    static final boolean ThisSurroundsDisabledCode = false;
    static final Logger logger = Logger.getLogger(ACA_CorrConfigValidator.class.getName());
    static final AtmPhaseCorrection[][] APCS = new AtmPhaseCorrection[][]{{AtmPhaseCorrection.AP_UNCORRECTED}, {AtmPhaseCorrection.AP_CORRECTED, AtmPhaseCorrection.AP_UNCORRECTED}, {AtmPhaseCorrection.AP_UNCORRECTED, AtmPhaseCorrection.AP_CORRECTED}};
    static final long MAX_COMPRESSION_FACTOR = 1024L;
    static final long Ki = 1024L;
    static final long Mi = 0x100000L;

    ACA_CorrConfigValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e1) {
                logger.log(Level.WARNING, "error", e1);
            }
        }
        String stackTrace = sw.toString();
        return stackTrace;
    }

    static boolean check(List<String> errors, boolean lastCond, boolean newCond, String format, Object ... args) {
        if (!newCond && format != null) {
            errors.add(MessageFormat.format(format, args));
        }
        return lastCond && newCond;
    }

    static boolean inInclusiveRangeLong(long value, long low, long high) {
        assert (low <= high);
        return low <= value && value <= high;
    }

    static boolean inInclusiveRangeDouble(double value, double low, double high) {
        assert (low <= high);
        return low <= value && value <= high;
    }

    static boolean inInclusiveRangeInMsTimeInterval(long timeIntervalIn100ns, long lowMs, long highMs) {
        assert (lowMs <= highMs);
        return ACA_CorrConfigValidator.msToTimeInterval(lowMs) <= timeIntervalIn100ns && timeIntervalIn100ns <= ACA_CorrConfigValidator.msToTimeInterval(highMs);
    }

    static boolean multipleOfLong(long value, long divisor) {
        assert (divisor != 0L);
        return value % divisor == 0L;
    }

    static boolean powerOfLong(long value, long base) {
        assert (base > 1L);
        if (base <= 1L) {
            throw new IllegalArgumentException("base should be > 1");
        }
        if (value < 1L) {
            return false;
        }
        while (value > 1L) {
            if (value % base != 0L) {
                return false;
            }
            value /= base;
        }
        return value == 1L;
    }

    static int closestExponentOf(double value, long base) {
        assert (base > 1L);
        assert (value >= 0.0);
        if (base <= 1L || !(value >= 0.0)) {
            throw new IllegalArgumentException("base > 1 && value >=0");
        }
        long limit = Long.MAX_VALUE / base;
        long v = 1L;
        double diff = value - (double)v;
        int exponent = 0;
        while (true) {
            if (v > limit) {
                throw new ArithmeticException("Overflow!");
            }
            long nextV = v * base;
            double nextDiff = value - (double)nextV;
            if (Math.abs(diff) <= Math.abs(nextDiff) && (diff <= 0.0 || nextDiff <= 0.0)) {
                return exponent;
            }
            v = nextV;
            diff = nextDiff;
            ++exponent;
        }
    }

    static boolean oneOfLong(long value, Long ... longs) {
        Long[] longArray = longs;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long candidate = longArray[i];
            if (value != candidate) continue;
            return true;
        }
        return false;
    }

    static Long[] mssToTimeIntervals(Long ... msecs) {
        Long[] result = new Long[msecs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ACA_CorrConfigValidator.msToTimeInterval(msecs[i]);
        }
        return result;
    }

    static long msToTimeInterval(long msec) {
        return msec * 1000L * 10L;
    }

    static boolean isValid(CorrelatorConfiguration conf, int numOfAntennas, stringSeqHolder errorList) {
        return ACA_CorrConfigValidator.isValid(conf, numOfAntennas, errorList, "ACACORRELATOR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isValid(CorrelatorConfiguration conf, int numOfAntennas, stringSeqHolder errorList, String type) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            boolean antennaResult = ACA_CorrConfigValidator.isValidAntenna(numOfAntennas, errors);
            boolean bl = ACA_CorrConfigValidator.isValidRoot(conf, numOfAntennas, errors, true, type) && antennaResult;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error while ACACORR validation.", e);
            String stackTrace = "There was an error while ACACORR configuration validation.\n" + ACA_CorrConfigValidator.getStackTrace(e);
            errors.add(stackTrace);
            boolean bl = false;
            return bl;
        }
        finally {
            String[] strs = new String[errors.size()];
            errorList.value = errors.toArray(strs);
        }
    }

    static boolean isValidAntenna(int numOfAntennas, List<String> errors) {
        boolean result = true;
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.oneOfLong(numOfAntennas, 4L, 12L, 16L), "Number of antennas should be one of 4, 12 or 16 but {0}.", numOfAntennas);
        return result;
    }

    static boolean isValidRoot(CorrelatorConfiguration conf, int numOfAntennas, List<String> errors, boolean checkDataRate) {
        return ACA_CorrConfigValidator.isValidRoot(conf, numOfAntennas, errors, checkDataRate, "ACACORRELATOR");
    }

    static boolean isValidRoot(CorrelatorConfiguration conf, int numOfAntennas, List<String> errors, boolean checkDataRate, String type) {
        boolean isOK;
        int i;
        boolean result = true;
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeLong(numOfAntennas, 1L, 16L), null, "Number of antennas should be in [1, 16] but {0}.", numOfAntennas);
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeInMsTimeInterval(conf.integrationDuration, 1L, 65000L), "Integration duration should be in [1, 65000]ms but {0}ns.", conf.integrationDuration * 100L);
        assert (conf.baseBands != null);
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeLong(conf.baseBands.length, 1L, 4L), "Number of base bands should be in [1, 4] but {0}.", conf.baseBands.length);
        for (i = 1; i < conf.baseBands.length; ++i) {
            isOK = conf.baseBands[0].CAM.value() == conf.baseBands[i].CAM.value();
            result = ACA_CorrConfigValidator.check(errors, result, isOK, "CAM should be consistent between base bands.", new Object[0]);
            if (!isOK) break;
        }
        for (i = 1; i < conf.baseBands.length; ++i) {
            isOK = conf.baseBands[0].sideBandSeparationMode.value() == conf.baseBands[i].sideBandSeparationMode.value();
            result = ACA_CorrConfigValidator.check(errors, result, isOK, "sideBandSeparationMode should be consistent between base bands.", new Object[0]);
            if (!isOK) break;
        }
        for (i = 1; i < conf.baseBands.length; ++i) {
            int j;
            boolean bl = isOK = conf.baseBands[0].binSwitchingMode.SwitchingType.value() == conf.baseBands[i].binSwitchingMode.SwitchingType.value() && conf.baseBands[0].binSwitchingMode.numberOfPositions == conf.baseBands[i].binSwitchingMode.numberOfPositions && conf.baseBands[0].binSwitchingMode.dwellTime.length == conf.baseBands[i].binSwitchingMode.dwellTime.length && conf.baseBands[0].binSwitchingMode.deadTime.length == conf.baseBands[i].binSwitchingMode.deadTime.length;
            if (isOK) {
                for (j = 0; j < conf.baseBands[0].binSwitchingMode.dwellTime.length; ++j) {
                    if (conf.baseBands[0].binSwitchingMode.dwellTime[j] == conf.baseBands[i].binSwitchingMode.dwellTime[j]) continue;
                    isOK = false;
                    break;
                }
            }
            if (isOK) {
                for (j = 0; j < conf.baseBands[0].binSwitchingMode.deadTime.length; ++j) {
                    if (conf.baseBands[0].binSwitchingMode.deadTime[j] == conf.baseBands[i].binSwitchingMode.deadTime[j]) continue;
                    isOK = false;
                    break;
                }
            }
            result = ACA_CorrConfigValidator.check(errors, result, isOK, "binSwitchingMode should be consistent between base bands.", new Object[0]);
            if (!isOK) break;
        }
        for (i = 1; i < conf.baseBands.length; ++i) {
            isOK = conf.baseBands[0].dataProducts.value() == conf.baseBands[i].dataProducts.value();
            result = ACA_CorrConfigValidator.check(errors, result, isOK, "Data products should be consistent between base bands.", new Object[0]);
            if (!isOK) break;
        }
        if (conf.baseBands[0].CAM.value() == AccumMode.FAST.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.oneOfLong(conf.integrationDuration, ACA_CorrConfigValidator.mssToTimeIntervals(1L, 2L, 4L, 8L)) || ACA_CorrConfigValidator.multipleOfLong(conf.integrationDuration, ACA_CorrConfigValidator.msToTimeInterval(16L)), "Integration duration should be one of 1ms, 2ms, 4ms, 8ms or multiple of 16ms but {0}ns.", conf.integrationDuration * 100L);
        }
        result = conf.channelAverageDuration <= 0L ? ACA_CorrConfigValidator.check(errors, result, false, "Channel average duration should not be 0ms but {0}ns.", conf.channelAverageDuration * 100L) : ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(conf.integrationDuration, conf.channelAverageDuration), "Integration duration should be multiple of channel average duration({0}ns).", conf.channelAverageDuration * 100L);
        if (conf.baseBands[0].CAM.value() == AccumMode.FAST.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(conf.channelAverageDuration, ACA_CorrConfigValidator.msToTimeInterval(1L)), "Channel average duration should be multiple of 1ms but {0}ns.", conf.channelAverageDuration * 100L);
        }
        if (conf.baseBands[0].CAM.value() == AccumMode.NORMAL.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(conf.channelAverageDuration, ACA_CorrConfigValidator.msToTimeInterval(16L)), "Channel average duration should be multiple of 16ms but {0}ns.", conf.channelAverageDuration * 100L);
        }
        BaseBandConfig bb = conf.baseBands[0];
        if (bb.sideBandSeparationMode.value() == SidebandProcessingMode.PHASE_SWITCH_SEPARATION.value() && (bb.dataProducts.value() == CorrelationMode.CROSS_AND_AUTO.value() || bb.dataProducts.value() == CorrelationMode.CROSS_ONLY.value())) {
            long walshSeqDuration = 2048L;
            result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(conf.channelAverageDuration, ACA_CorrConfigValidator.msToTimeInterval(2048L)), "Channel average duration should be multiple of walsh sequence duration {0}ms but {1}ns.", 2048L, conf.channelAverageDuration * 100L);
        }
        assert (conf.APCDataSets != null);
        boolean isOK2 = false;
        for (int i2 = 0; i2 < APCS.length; ++i2) {
            if (!ACA_CorrConfigValidator.isEqualAPC(APCS[i2], conf.APCDataSets)) continue;
            isOK2 = true;
            break;
        }
        result = ACA_CorrConfigValidator.check(errors, result, isOK2, "APCDataSets should be one of (AP_UNCORRECTED) or (AP_UNCORRECTED, AP_CORRECTED) or (AP_CORRECTED, AP_UNCORRECTED).", new Object[0]);
        if (conf.ACAPhaseSwConfig.doD180modulation) {
            result = ACA_CorrConfigValidator.check(errors, result, conf.ACAPhaseSwConfig.doD180demodulation, "doD180demodulation should be true when doD180modulation is true.", new Object[0]);
        }
        boolean isRootValid = result;
        for (BaseBandConfig bb2 : conf.baseBands) {
            result = ACA_CorrConfigValidator.isValidBaseBand(errors, conf, bb2, numOfAntennas, isRootValid, checkDataRate, type) && result;
        }
        return result;
    }

    static boolean isValidBaseBand(List<String> errors, CorrelatorConfiguration conf, BaseBandConfig bb, int numOfAntennas, boolean isRootValid, boolean checkDataRate) {
        return ACA_CorrConfigValidator.isValidBaseBand(errors, conf, bb, numOfAntennas, isRootValid, checkDataRate, "ACACORRELATOR");
    }

    static boolean isValidBaseBand(List<String> errors, CorrelatorConfiguration conf, BaseBandConfig bb, int numOfAntennas, boolean isRootValid, boolean checkDataRate, String type) {
        boolean result = true;
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.oneOfLong(bb.basebandName.value(), new Long[]{BasebandName.BB_1.value(), BasebandName.BB_2.value(), BasebandName.BB_3.value(), BasebandName.BB_4.value()}), "Base band name should be one of BB_[1-4] but {0}.", bb.basebandName.toString());
        String bbName = bb.basebandName.toString();
        result = ACA_CorrConfigValidator.check(errors, result, bb.dataProducts.value() != CorrelationMode.CROSS_ONLY.value(), "Data products for {0} should not be CROSS_ONLY.", bbName);
        boolean doAPC = false;
        for (AtmPhaseCorrection apc : conf.APCDataSets) {
            if (apc.value() != AtmPhaseCorrection.AP_CORRECTED.value()) continue;
            doAPC = true;
        }
        if (doAPC) {
            result = ACA_CorrConfigValidator.check(errors, result, bb.dataProducts.value() == CorrelationMode.CROSS_AND_AUTO.value(), "Data products for {0} should be CROSS_AND_AUTO when correcting AP.", bbName);
        }
        if (bb.dataProducts.value() == CorrelationMode.CROSS_AND_AUTO.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, bb.CAM.value() == AccumMode.NORMAL.value(), "CAM should be NORMAL but {0} when data products is CROSS_AND_AUTO.", bb.CAM.toString());
        }
        result = ACA_CorrConfigValidator.check(errors, result, bb.sideBandSeparationMode.value() != SidebandProcessingMode.FREQUENCY_OFFSET_SEPARATION.value(), "Sideband processing mode should not be FREQUENCY_OFFSET_SEPARATION.", new Object[0]);
        result = ACA_CorrConfigValidator.check(errors, result, bb.sideBandSeparationMode.value() != SidebandProcessingMode.PHASE_SWITCH_REJECTION.value(), "Sideband processing mode should not be PHASE_SWITCH_REJECTION.", new Object[0]);
        if (bb.sideBandSeparationMode.value() == SidebandProcessingMode.PHASE_SWITCH_SEPARATION.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, bb.CAM.value() == AccumMode.NORMAL.value(), "CAM of {0} should be NORMAL but {1} when PHASE_SWITCH_SEPARATION.", bbName, bb.CAM.toString());
        }
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeDouble(bb.centerFreqOfResidualDelayMHz, -7000.0, 9000.0), "CenterFreqOfResidualDelayMHz for {0} should be in [-7000, 9000]MHz but {1}MHz.", bbName, bb.centerFreqOfResidualDelayMHz);
        assert (bb.binSwitchingMode != null);
        boolean bl = result = ACA_CorrConfigValidator.isValidBinSW(errors, conf, bb, bb.binSwitchingMode) && result;
        assert (bb.spectralWindows != null);
        result = ACA_CorrConfigValidator.isValidInterSpectralWindow(errors, conf, bb, bb.spectralWindows) && result;
        for (int i = 0; i < bb.spectralWindows.length; ++i) {
            result = ACA_CorrConfigValidator.isValidSpectralWindow(errors, conf, bb, i, bb.spectralWindows[i]) && result;
        }
        if (isRootValid && checkDataRate && result) {
            Pair<Double, Double> dataRates = ACA_CorrConfigValidator.calcBaseBandDataRate(conf, bb, numOfAntennas);
            double dataRateMiBps = (Double)dataRates.left;
            logger.info(MessageFormat.format("Data rate for {0} of ACACORR is {1}MiB/s.", bbName, dataRateMiBps));
            double DATA_RATE_LIMIT = 0.9;
            if (type.equals("ACACORRELATOR")) {
                DATA_RATE_LIMIT = 0.9;
            } else if (type.equals("ACASPECTROMETER")) {
                DATA_RATE_LIMIT = 4.25;
            }
            result = ACA_CorrConfigValidator.check(errors, result, dataRateMiBps <= DATA_RATE_LIMIT, "Data rate for {0} should be less than or equal to {1}MiB/s but {2}MiB/s.", bbName, DATA_RATE_LIMIT, dataRateMiBps);
            double channelAverageSize = (Double)dataRates.right;
            logger.info(MessageFormat.format("Channel average size for {0} of ACACORR is {1}MiB.", bbName, channelAverageSize));
            double CHANNEL_AVERAGE_LIMIT = 0.1220703125;
            result = ACA_CorrConfigValidator.check(errors, result, channelAverageSize <= 0.1220703125, "Channel average size for {0} should be less than or equal to {1}MiB but {2}MiB.", bbName, 0.1220703125, channelAverageSize);
        }
        return result;
    }

    static boolean isValidBinSW(List<String> errors, CorrelatorConfiguration conf, BaseBandConfig bb, BinSwitching_t binSW) {
        boolean result = true;
        if (bb.CAM.value() != AccumMode.FAST.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, binSW.SwitchingType.value() == SwitchingMode.NO_SWITCHING.value(), "Switching type should be NO_SWITCHING but {0}.", binSW.SwitchingType.toString());
        }
        result = binSW.SwitchingType.value() == SwitchingMode.NO_SWITCHING.value() ? ACA_CorrConfigValidator.check(errors, result, binSW.numberOfPositions == 0, "Number of positions should be 0 when NO_SWITCHING.", new Object[0]) : ACA_CorrConfigValidator.check(errors, result, binSW.numberOfPositions == 2, "Number of positions should be 2 when not NO_SWITCHING.", new Object[0]);
        result = ACA_CorrConfigValidator.check(errors, result, binSW.numberOfPositions == binSW.dwellTime.length, "Number of dwell times should be equal to number of positions but {0}.", binSW.dwellTime.length);
        result = ACA_CorrConfigValidator.check(errors, result, binSW.numberOfPositions == binSW.deadTime.length, "Number of transition times should be equal to number of positions but {0}.", binSW.deadTime.length);
        if (binSW.numberOfPositions == binSW.dwellTime.length && binSW.numberOfPositions == binSW.deadTime.length) {
            if (binSW.numberOfPositions == 2) {
                result = ACA_CorrConfigValidator.check(errors, result, binSW.dwellTime[0] == binSW.dwellTime[1], "Dwell times should be equal to each other but {0} != {1}.", binSW.dwellTime[0], binSW.dwellTime[1]);
                result = ACA_CorrConfigValidator.check(errors, result, binSW.deadTime[0] == binSW.deadTime[1], "Transition times should be equal to each other but {0} != {1}.", binSW.deadTime[0], binSW.deadTime[1]);
            }
            if (binSW.numberOfPositions > 0) {
                long totalTime = (long)binSW.numberOfPositions * (binSW.dwellTime[0] + binSW.deadTime[0]);
                result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(conf.integrationDuration, totalTime), "Integration duration should be multiple of total({0}ns) of dwell times and transition times but {1}ns.", totalTime * 100L, conf.integrationDuration * 100L);
                result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(conf.channelAverageDuration, totalTime), "Channel Average duration should be multiple of total({0}ns) of dwell times and transition times but {1}ns.", totalTime * 100L, conf.channelAverageDuration * 100L);
                result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(binSW.dwellTime[0], ACA_CorrConfigValidator.msToTimeInterval(1L)), "Each dwell time should be multiple of 1ms but {0}ns.", binSW.dwellTime[0] * 100L);
                result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(binSW.deadTime[0], ACA_CorrConfigValidator.msToTimeInterval(1L)), "Each transition time should be multiple of 1ms but {0}ns.", binSW.deadTime[0] * 100L);
            }
        }
        return result;
    }

    static boolean isEqualPoln(StokesParameter[] a, StokesParameter[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].value() == b[i].value()) continue;
            return false;
        }
        return true;
    }

    static boolean isEqualAPC(AtmPhaseCorrection[] a, AtmPhaseCorrection[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].value() == b[i].value()) continue;
            return false;
        }
        return true;
    }

    static boolean isValidInterSpectralWindow(List<String> errors, CorrelatorConfiguration conf, BaseBandConfig bb, SpectralWindow[] specWins) {
        String bbName = bb.basebandName.toString();
        boolean result = true;
        int numOfEffectiveSW = 0;
        for (SpectralWindow sw : specWins) {
            if (!sw.useThisSpectralWindow) continue;
            ++numOfEffectiveSW;
        }
        if (!ACA_CorrConfigValidator.inInclusiveRangeLong(numOfEffectiveSW, 1L, 32L)) {
            result = ACA_CorrConfigValidator.check(errors, result, false, "Number of spectral windows to be used for {0} should be in [1, 32] but {1}.", bbName, numOfEffectiveSW);
            return result;
        }
        assert (specWins.length > 0);
        for (int i = 1; i < specWins.length; ++i) {
            result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.isEqualPoln(specWins[0].polnProductsSeq, specWins[i].polnProductsSeq), "All polnProductsSeq elements for {0} should have a same value.", bbName);
        }
        boolean isOK = false;
        for (int i = 0; i < ACA_XMLUnmarshaller.STOKES.length; ++i) {
            if (!ACA_CorrConfigValidator.isEqualPoln(ACA_XMLUnmarshaller.STOKES[i], specWins[0].polnProductsSeq)) continue;
            isOK = true;
            break;
        }
        result = ACA_CorrConfigValidator.check(errors, result, isOK, "''polnProductsSeq'' for {0} has a wrong polarization sequence.", bbName);
        long totalSwCh = 0L;
        for (SpectralWindow sw : specWins) {
            long hwSWch = Math.round(sw.effectiveBandwidthMHz * 512.0 * 1024.0 / 2048000.0);
            long swCh = bb.sideBandSeparationMode.value() == SidebandProcessingMode.PHASE_SWITCH_SEPARATION.value() && sw.sideBand.value() == NetSideband.USB.value() ? 0L : Math.max(hwSWch, (long)sw.effectiveNumberOfChannels);
            totalSwCh += swCh;
        }
        assert (specWins[0].polnProductsSeq.length > 0);
        long chLimit = 8192 / specWins[0].polnProductsSeq.length;
        result = ACA_CorrConfigValidator.check(errors, result, totalSwCh <= chLimit, "Total effective number of channels for {0} should be less than or equal to {1} but {2}.", bbName, chLimit, totalSwCh);
        double totalEBW = 0.0;
        for (SpectralWindow sw : specWins) {
            double ebw = bb.sideBandSeparationMode.value() == SidebandProcessingMode.PHASE_SWITCH_SEPARATION.value() && sw.sideBand.value() == NetSideband.USB.value() ? 0.0 : sw.effectiveBandwidthMHz;
            totalEBW += ebw;
        }
        result = ACA_CorrConfigValidator.check(errors, result, totalEBW <= 2250.0, "Total effective bandwidth for {0} should be less than or equal to 2250MHz but {1}MHz.", bbName, totalEBW);
        if (bb.sideBandSeparationMode.value() == SidebandProcessingMode.PHASE_SWITCH_SEPARATION.value()) {
            if (specWins.length % 2 == 0) {
                for (int i = 0; i < specWins.length; i += 2) {
                    int j = i + 1;
                    int lsb_index = i + 1;
                    int usb_index = j + 1;
                    if (specWins[i].associatedSpectralWindowNumberInPair == usb_index && specWins[j].associatedSpectralWindowNumberInPair == lsb_index) {
                        result = ACA_CorrConfigValidator.check(errors, result, specWins[i].sideBand.value() == NetSideband.LSB.value() && specWins[j].sideBand.value() == NetSideband.USB.value(), "Each member of associated spectral window couple([{0}], [{1}]) for {2} should be ordered as LSB to USB.", ACA_CorrConfigValidator.toOTSWOrigin(i), ACA_CorrConfigValidator.toOTSWOrigin(j), bbName);
                        result = ACA_CorrConfigValidator.check(errors, result, specWins[i].centerFrequencyMHz == specWins[j].centerFrequencyMHz && specWins[i].effectiveBandwidthMHz == specWins[j].effectiveBandwidthMHz && specWins[i].effectiveNumberOfChannels == specWins[j].effectiveNumberOfChannels && specWins[i].windowFunction.value() == specWins[j].windowFunction.value(), "Each member of associated spectral window couple([{0}], [{1}]) for {2} should have same value of center frequency, effective bandwidth, effective number of channels and window function each other.", ACA_CorrConfigValidator.toOTSWOrigin(i), ACA_CorrConfigValidator.toOTSWOrigin(j), bbName);
                        result = ACA_CorrConfigValidator.check(errors, result, specWins[i].useThisSpectralWindow || specWins[j].useThisSpectralWindow, "At least one member of spectral window couple([{0}], [{1}]) for {2} should have ''useThisSpectralWindow'' with true value.", ACA_CorrConfigValidator.toOTSWOrigin(i), ACA_CorrConfigValidator.toOTSWOrigin(j), bbName);
                        continue;
                    }
                    result = ACA_CorrConfigValidator.check(errors, result, false, "Every contiguous 2 spectral windows([{0}], [{1}]) for {2} should be associated with each other.", ACA_CorrConfigValidator.toOTSWOrigin(i), ACA_CorrConfigValidator.toOTSWOrigin(j), bbName);
                }
            } else {
                result = ACA_CorrConfigValidator.check(errors, result, false, "Number of spectral windows for {0} should be even.", bbName);
            }
        } else {
            for (int i = 0; i < specWins.length; ++i) {
                result = ACA_CorrConfigValidator.check(errors, result, specWins[i].associatedSpectralWindowNumberInPair == 0, "In spectral window[{0}] of {1}, associatedSpectralWindowNumberInPair should be 0.", ACA_CorrConfigValidator.toOTSWOrigin(i), bbName);
                result = ACA_CorrConfigValidator.check(errors, result, specWins[i].useThisSpectralWindow, "In spectral window[{0}] of {1}, use this spectral window should be true.", ACA_CorrConfigValidator.toOTSWOrigin(i), bbName);
            }
        }
        return result;
    }

    static boolean isValidSpectralWindow(List<String> errors, CorrelatorConfiguration conf, BaseBandConfig bb, int swIdx, SpectralWindow sw) {
        String bbName = bb.basebandName.toString();
        boolean result = true;
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeLong(sw.channelAverageRegions.length, 1L, 10L), "In spectral window[{0}] of {1}, number of channel average regions should be in [1, 10] but {2}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, sw.channelAverageRegions.length);
        if (ACA_CorrConfigValidator.inInclusiveRangeLong(sw.effectiveNumberOfChannels, 16L, 8192L)) {
            int uLimit = sw.effectiveNumberOfChannels - 1;
            for (int i = 0; i < sw.channelAverageRegions.length; ++i) {
                result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeLong(sw.channelAverageRegions[i].startChannel, 0L, uLimit), "In spectral window[{0}] of {1}, start channel of channel average region[{2}] should be in [0, {3}] but {4}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, i, uLimit, sw.channelAverageRegions[i].startChannel);
                result = ACA_CorrConfigValidator.check(errors, result, sw.channelAverageRegions[i].numberChannels > 0, "In spectral window[{0}] of {1}, number of channels of channel average region[{2}] should be greater than 0 but {3}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, i, sw.channelAverageRegions[i].numberChannels);
                int stopChannel = sw.channelAverageRegions[i].startChannel + sw.channelAverageRegions[i].numberChannels;
                result = ACA_CorrConfigValidator.check(errors, result, stopChannel <= sw.effectiveNumberOfChannels, "In spectral window[{0}] of {1}, end channel of channel average region[{2}] should be less than or equal to {3} but {4}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, i, sw.effectiveNumberOfChannels, stopChannel);
            }
            result = ACA_CorrConfigValidator.inInclusiveRangeLong(sw.spectralAveragingFactor, 1L, sw.effectiveNumberOfChannels) ? ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.multipleOfLong(sw.effectiveNumberOfChannels, sw.spectralAveragingFactor), "In spectral window[{0}] of {1}, effective number of channels should be multiple of spectral averaging factor({2}) but {3}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, sw.spectralAveragingFactor, sw.effectiveNumberOfChannels) : ACA_CorrConfigValidator.check(errors, result, false, "In spectral window[{0}] of {1}, spectral averaging factor should be in [1, {2}] but {3}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, sw.effectiveNumberOfChannels, sw.spectralAveragingFactor);
            if (sw.synthProf.value() == SynthProf.ACACORR.value()) {
                double channelWidth = sw.effectiveBandwidthMHz / (double)sw.effectiveNumberOfChannels;
                double minimumChannelWidth = 0.00762939453125;
                result = ACA_CorrConfigValidator.check(errors, result, channelWidth >= 0.00762939453125, "In spectral window[{0}] of {1}, effective bandwidth per channel should be greater than or equal to {2}MHz but {3}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, 0.00762939453125, channelWidth);
            }
        } else {
            result = ACA_CorrConfigValidator.check(errors, result, false, "In spectral window[{0}] of {1}, effective number of channels should be in [16, 8192] but {2}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, sw.effectiveNumberOfChannels);
        }
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.powerOfLong(sw.spectralAveragingFactor, 2L), "In spectral window[{0}] of {1}, spectral averaging factor should be power of 2 but {2}.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, sw.spectralAveragingFactor);
        double lLimit = 0.06103515625;
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeDouble(sw.effectiveBandwidthMHz, 0.06103515625, 2000.0), "In spectral window[{0}] of {1}, effective bandwidth should be in [{2}, 2000]MHz but {3}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, 0.06103515625, sw.effectiveBandwidthMHz);
        double divisor = 2000.0 * (double)sw.effectiveNumberOfChannels / 524288.0;
        assert (divisor != 0.0);
        long exp = ACA_CorrConfigValidator.closestExponentOf(sw.effectiveBandwidthMHz / divisor, 2L);
        double refValue = (double)(1L << (int)exp) * divisor;
        double diff = Math.abs(sw.effectiveBandwidthMHz - refValue);
        result = ACA_CorrConfigValidator.check(errors, result, diff == 0.0, "In spectral window[{0}] of {1}, the closest valid effective bandwidth is {2,number,###,##0.################}MHz but {3,number,###,##0.################}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, refValue, sw.effectiveBandwidthMHz);
        double idlCenterFreq = sw.centerFrequencyMHz - 2000.0;
        double lower = idlCenterFreq - sw.effectiveBandwidthMHz / 2.0;
        double upper = idlCenterFreq + sw.effectiveBandwidthMHz / 2.0;
        result = ACA_CorrConfigValidator.check(errors, result, ACA_CorrConfigValidator.inInclusiveRangeDouble(idlCenterFreq, 0.0, 2000.0), "In spectral window[{0}] of {1}, center frequency should be in [2000, 4000]MHz but {2}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, sw.centerFrequencyMHz);
        result = ACA_CorrConfigValidator.check(errors, result, lower >= 0.0, "In spectral window[{0}] of {1}, effective bandwidth shoud be less than or equal to {2}MHz but {3}MHz when center frequency is right.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, idlCenterFreq * 2.0, sw.effectiveBandwidthMHz);
        result = ACA_CorrConfigValidator.check(errors, result, upper <= 2000.0, "In spectral window[{0}] of {1}, effective bandwidth shoud be less than or equal to {2}MHz but {3}MHz when center frequency is right.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, (2000.0 - idlCenterFreq) * 2.0, sw.effectiveBandwidthMHz);
        long hwSWch = Math.round(sw.effectiveBandwidthMHz * 512.0 * 1024.0 / 1024.0 / 2000.0);
        long swCh = Math.max(hwSWch, (long)sw.effectiveNumberOfChannels);
        assert (swCh > 0L);
        double chWidth = sw.effectiveBandwidthMHz / (double)swCh;
        double step = chWidth * 8.0;
        assert (step > 0.0);
        double refValue2 = (double)Math.round(lower / step) * step;
        result = ACA_CorrConfigValidator.check(errors, result, lower == refValue2, "In spectral window[{0}] of {1}, the closest valid lower bound of this spectral window is {2,number,###,##0.################}MHz but {3,number,###,##0.################}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, refValue2, lower);
        logger.finer(MessageFormat.format("Actual lower {0}, reference {1}", lower, refValue2));
        if (sw.synthProf.value() == SynthProf.ACACORR.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, lower >= step, "In spectral window[{0}] of {1}, lower bound of this spectral window should be greater than or equal to {2,number,###,##0.################}MHz but {3,number,###,##0.################}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, step, lower);
        }
        result = ACA_CorrConfigValidator.check(errors, result, upper == (refValue2 = (double)Math.round(upper / step) * step), "In spectral window[{0}] of {1}, the closest valid upper bound of this spectral window is {2,number,###,##0.################}MHz but {3,number,###,##0.################}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, refValue2, upper);
        logger.finer(MessageFormat.format("Actual upper {0}, reference {1}", upper, refValue2));
        if (sw.synthProf.value() == SynthProf.ACACORR.value()) {
            result = ACA_CorrConfigValidator.check(errors, result, upper <= 2000.0 - step, "In spectral window[{0}] of {1}, upper bound of this spectral window should be less than or equal to {2,number,###,##0.################}MHz but {3,number,###,##0.################}MHz.", ACA_CorrConfigValidator.toOTSWOrigin(swIdx), bbName, 2000.0 - step, upper);
        }
        return result;
    }

    static Pair<Double, Double> calcBaseBandDataRate(CorrelatorConfiguration conf, BaseBandConfig bb, int numberOfAntennas) {
        Pair<CorrConfigValidatorBase.BaseBandDataRate, Double> result = ACA_CorrConfigValidator.calcDataRateForBaseBand(conf, bb, numberOfAntennas);
        double totalDataRate = ((CorrConfigValidatorBase.BaseBandDataRate)result.left).ancillary;
        for (double swDataRate : ((CorrConfigValidatorBase.BaseBandDataRate)result.left).spectralWindow) {
            totalDataRate += swDataRate;
        }
        return new Pair<Double, Double>(totalDataRate, (Double)result.right);
    }

    static Pair<CorrConfigValidatorBase.BaseBandDataRate, Double> calcDataRateForBaseBand(CorrelatorConfiguration conf, BaseBandConfig bb, int numberOfAntennas) {
        long UnitSizeFull = 4L;
        long UnitSizeChannel = 4L;
        long UnitSizeTime = 8L;
        long UnitSizeDuration = 8L;
        long UnitSizeFlag = 4L;
        long HeaderSize = 1300 / conf.baseBands.length;
        long Nantenna = numberOfAntennas;
        long Napc = 2L;
        if (conf.APCDataSets.length == 1 && conf.APCDataSets[0].value() == AtmPhaseCorrection.AP_UNCORRECTED.value()) {
            Napc = 1L;
        }
        long cross = bb.dataProducts.value() == CorrelationMode.CROSS_AND_AUTO.value() ? 1L : 0L;
        long Nbin = bb.dataProducts.value() == CorrelationMode.AUTO_ONLY.value() && bb.binSwitchingMode.SwitchingType.value() != SwitchingMode.NO_SWITCHING.value() ? 2L : 1L;
        long NpolBBMax = 0L;
        for (SpectralWindow sw : bb.spectralWindows) {
            if (!sw.useThisSpectralWindow) continue;
            NpolBBMax = Math.max(NpolBBMax, (long)sw.polnProductsSeq.length);
        }
        double SizeTime = (double)(8L * Nantenna) * ((double)(Nbin * Math.min(NpolBBMax, 3L)) + (double)(cross * NpolBBMax * (Nantenna - 1L)) / 2.0);
        double SizeDuration = (double)(8L * Nantenna) * ((double)(Nbin * Math.min(NpolBBMax, 3L)) + (double)(cross * NpolBBMax * (Nantenna - 1L)) / 2.0);
        double SizeFlag = (double)(4L * Nantenna) * ((double)(Nbin * Math.min(NpolBBMax, 3L)) + (double)(cross * NpolBBMax * (Nantenna - 1L)) / 2.0);
        CorrConfigValidatorBase.BaseBandDataRate result = new CorrConfigValidatorBase.BaseBandDataRate();
        result.spectralWindow = new double[bb.spectralWindows.length];
        double timeInterval2sec = 1.0E-7;
        double integrationDuration = (double)conf.integrationDuration * 1.0E-7;
        double channelAverageDuration = (double)conf.channelAverageDuration * 1.0E-7;
        double bbSizeFull = (double)HeaderSize + SizeTime + SizeDuration + SizeFlag;
        double bbSizeChannel = (double)HeaderSize + SizeTime + SizeDuration + SizeFlag;
        long Mi = 0x100000L;
        result.ancillary = (bbSizeFull / integrationDuration + bbSizeChannel / channelAverageDuration) / 1048576.0;
        double channelAverageSize = bbSizeChannel;
        for (int i = 0; i < result.spectralWindow.length; ++i) {
            SpectralWindow sw = bb.spectralWindows[i];
            long useThisSpectralWindow = sw.useThisSpectralWindow ? 1L : 0L;
            long NchannelAverageRegions = sw.channelAverageRegions.length;
            long Npol = sw.polnProductsSeq.length;
            assert (sw.spectralAveragingFactor != 0);
            long Nch = sw.effectiveNumberOfChannels / sw.spectralAveragingFactor;
            double SizeFull = (double)(useThisSpectralWindow * 4L * Nch * Nantenna) * ((double)Nbin + (double)(cross * 2L * Napc * (Nantenna - 1L)) / 2.0) * (double)Npol;
            double SizeChannel = (double)(useThisSpectralWindow * 4L * NchannelAverageRegions * Nantenna) * ((double)Nbin + (double)(cross * 2L * (Nantenna - 1L)) / 2.0) * (double)Npol;
            result.spectralWindow[i] = (SizeFull / integrationDuration + SizeChannel / channelAverageDuration) / 1048576.0;
            channelAverageSize += SizeChannel;
        }
        return new Pair<CorrConfigValidatorBase.BaseBandDataRate, Double>(result, channelAverageSize / 1048576.0);
    }

    static int toOTSWOrigin(int idx) {
        return idx + 1;
    }

    static class Pair<A, B> {
        public A left;
        public B right;

        public Pair(A left, B right) {
            this.left = left;
            this.right = right;
        }
    }
}

