/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.ConfigModeDecoder;

public enum CorrFraction {
    FULL("1(Full)", ConfigModeDecoder.eFraction.FRACTION_FULL, ScienceSpectralWindow.GROUPRESOURCEUSE_FULL, 32, 1.0),
    HALF("1/2", ConfigModeDecoder.eFraction.FRACTION_ONE_HALF, ScienceSpectralWindow.GROUPRESOURCEUSE_HALF, 16, 0.5),
    QUARTER("1/4", ConfigModeDecoder.eFraction.FRACTION_ONE_FOURTH, ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER, 8, 0.25),
    EIGHTH("1/8", ConfigModeDecoder.eFraction.FRACTION_ONE_EIGHTH, ScienceSpectralWindow.GROUPRESOURCEUSE_EIGHTH, 4, 0.125),
    SIXTEENTH("1/16", ConfigModeDecoder.eFraction.FRACTION_ONE_SIXTEENTH, ScienceSpectralWindow.GROUPRESOURCEUSE_SIXTEENTH, 2, 0.0625),
    THIRTYSECOND("1/32", ConfigModeDecoder.eFraction.FRACTION_ONE_THIRTYSECOND, ScienceSpectralWindow.GROUPRESOURCEUSE_THIRTYSECOND, 1, 0.03125);

    private String label;
    private ConfigModeDecoder.eFraction efraction;
    private String resourceUse;
    private int units;
    private double multiplier;

    public static CorrFraction getCorrFraction(String string) {
        for (CorrFraction corrFraction : CorrFraction.values()) {
            if (!corrFraction.label.equals(string) && !corrFraction.efraction.name().endsWith(string) && !corrFraction.resourceUse.equals(string)) continue;
            return corrFraction;
        }
        return null;
    }

    public static CorrFraction getCorrFraction(ConfigModeDecoder.eFraction eFraction2) {
        for (CorrFraction corrFraction : CorrFraction.values()) {
            if (corrFraction.efraction != eFraction2) continue;
            return corrFraction;
        }
        return null;
    }

    private CorrFraction(String string2, ConfigModeDecoder.eFraction eFraction2, String string3, int n2, double d) {
        this.label = string2;
        this.efraction = eFraction2;
        this.resourceUse = string3;
        this.units = n2;
        this.multiplier = d;
    }

    public String toString() {
        return "CorrFraction." + this.name() + "(label=" + this.getLabel() + ", efraction=" + String.valueOf((Object)this.getEfraction()) + ", resourceUse=" + this.getResourceUse() + ", units=" + this.getUnits() + ", multiplier=" + this.getMultiplier() + ")";
    }

    public String getLabel() {
        return this.label;
    }

    public ConfigModeDecoder.eFraction getEfraction() {
        return this.efraction;
    }

    public String getResourceUse() {
        return this.resourceUse;
    }

    public int getUnits() {
        return this.units;
    }

    public double getMultiplier() {
        return this.multiplier;
    }
}

