/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.enumerations;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.valuetypes.Frequency;
import java.util.HashMap;
import java.util.Map;

public enum NetSideBand {
    LSB(AbstractSpectralWindow.SIDEBAND_LSB),
    USB(AbstractSpectralWindow.SIDEBAND_USB),
    DSB(AbstractSpectralWindow.SIDEBAND_DSB);

    String label;
    static Map<String, NetSideBand> map;
    private static final Frequency F_AD;

    public String toString() {
        return this.label;
    }

    public static NetSideBand getNetSideBand(String string) {
        return map.get(string);
    }

    public int getSkyFrequencyCount() {
        switch (this) {
            case LSB: {
                return 1;
            }
            case USB: {
                return 1;
            }
            case DSB: {
                return 2;
            }
        }
        throw new RuntimeException("Unexpected NetSideBandBehaviour value : " + String.valueOf((Object)this));
    }

    public Frequency getSkyFrequency(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        switch (this) {
            case LSB: {
                return this.skyFrequencyLSB(frequency, frequency2, frequency3);
            }
            case USB: {
                return this.skyFrequencyUSB(frequency, frequency2, frequency3);
            }
            case DSB: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected NetSideBandBehaviour value : " + String.valueOf((Object)this));
    }

    public Frequency[] getSkyFrequencies(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        switch (this) {
            case LSB: {
                return new Frequency[]{this.skyFrequencyLSB(frequency, frequency2, frequency3)};
            }
            case USB: {
                return new Frequency[]{this.skyFrequencyUSB(frequency, frequency2, frequency3)};
            }
            case DSB: {
                return new Frequency[]{this.skyFrequencyLSB(frequency, frequency2, frequency3), this.skyFrequencyUSB(frequency, frequency2, frequency3)};
            }
        }
        throw new RuntimeException("Unexpected NetSideBandBehaviour value : " + String.valueOf((Object)this));
    }

    public Frequency getBaseBandFrequency(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        return this.baseBandFrequency(frequency, frequency2, frequency3);
    }

    public double getBaseBandFrequencyInMHz(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        return this.getBaseBandFrequency(frequency, frequency2, frequency3).getContentInMHz();
    }

    private Frequency intermediateFrequencyFromBaseBandFrequency(Frequency frequency, Frequency frequency2) {
        return (Frequency)frequency2.minus((AbstractDoubleWithUnit)((Frequency)F_AD.minus((AbstractDoubleWithUnit)((Frequency)frequency.minus((AbstractDoubleWithUnit)AbstractSpectralWindow.centerFrequencyOffset)))));
    }

    private Frequency skyFrequencyLSB(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        return (Frequency)frequency2.minus((AbstractDoubleWithUnit)this.intermediateFrequencyFromBaseBandFrequency(frequency, frequency3));
    }

    private Frequency skyFrequencyUSB(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        return (Frequency)frequency2.plus((AbstractDoubleWithUnit)this.intermediateFrequencyFromBaseBandFrequency(frequency, frequency3));
    }

    private Frequency intermediateFrequencyFromSkyFrequency(Frequency frequency, Frequency frequency2) {
        return frequency.compareTo((AbstractDoubleWithUnit)frequency2) > 0 ? (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2) : (Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency);
    }

    private Frequency baseBandFrequency(Frequency frequency, Frequency frequency2, Frequency frequency3) {
        return (Frequency)((Frequency)F_AD.minus((AbstractDoubleWithUnit)((Frequency)frequency3.minus((AbstractDoubleWithUnit)this.intermediateFrequencyFromSkyFrequency(frequency, frequency2))))).plus((AbstractDoubleWithUnit)AbstractSpectralWindow.centerFrequencyOffset);
    }

    private NetSideBand(String string2) {
        this.label = string2;
    }

    static {
        map = new HashMap<String, NetSideBand>();
        map.put(AbstractSpectralWindow.SIDEBAND_LSB, LSB);
        map.put(AbstractSpectralWindow.SIDEBAND_USB, USB);
        map.put(AbstractSpectralWindow.SIDEBAND_DSB, DSB);
        F_AD = Frequency.createFrequencyGHZ(4.0);
    }
}

