/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.AbstractSpectralWindowT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.ACASpectralWindow;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.DataRateChangeEvent;
import alma.obsprep.bo.schedblock.DataRateNode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.bo.schedblock.data.AbstractSpectralWindowData;
import alma.obsprep.ot.valdef.corrconfig.CorrelatorConfigDataRate;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSpectralWindow
extends AbstractSpectralWindowData
implements SpectralWindowI,
DataRateNode {
    public static final String SYNTH_PROF_UNDEFINED = "UNDEFINED";
    public static final String defaultPolnProducts = POLNPRODUCTS_XX_YY;
    public static final int defaultCorrConfigMode = 142;
    public static final String defaultWindowFunction = WINDOWFUNCTION_HANNING;
    protected CorrConfigMode corrConfigMode = CorrConfigMode.INVALID_CORRCONFIGMODE;
    protected SpectralWindowBand swb = null;
    protected Set<CorrConfigMode> applicableModeSet = null;
    private ScienceSpectralWindow scienceSpectralWindow;

    protected AbstractSpectralWindow(AbstractSpectralWindowT abstractSpectralWindowT) {
        super(abstractSpectralWindowT);
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String string = propertyChangeEvent.getPropertyName();
            if (string.endsWith("polnProducts") || string.endsWith("effectiveNumberOfChannels") || string.endsWith("useThisSpectralWindow") || string.endsWith("spectralAveragingFactor") || string.endsWith("windowFunction")) {
                this.dataRateChanged();
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getCenterFrequency().setUnit(Frequency.UNIT_MHZ);
        this.setWindowFunction(defaultWindowFunction);
        this.setSideBand(SIDEBAND_LSB);
        this.setCorrConfigMode(142);
        this.setPolnProducts(this.getCorrConfigMode().getPolarization().polnProducts);
        Frequency frequency = this.getCorrConfigMode().getNominalBandwidth();
        int n = this.getCorrConfigMode().getNominalChannels();
        this.getSwb().setParameters(frequency, n, SpectralWindowBand.ChannelType.NOMINAL);
        Frequency frequency2 = (Frequency)((Frequency)this.getNominalBandwidth().divide(2.0)).plus((AbstractDoubleWithUnit)centerFrequencyOffset);
        frequency2.convertToMHz();
        this.setCenterFrequency(frequency2);
        this.setAssociatedSpectralWindowNumberInPair(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "@" + this.hashCode());
        stringBuilder.append(",name=" + this.getName());
        stringBuilder.append(",use=" + String.valueOf((Object)this.getSideBandUse()));
        stringBuilder.append("[");
        stringBuilder.append("offset=" + String.valueOf((Object)this.getCenterFrequency()) + ",");
        stringBuilder.append("FLSB=" + String.valueOf((Object)this.getSkyFrequencyLSB()) + "(" + this.getSideBandUse().usesLSB() + "),");
        stringBuilder.append("FUSB=" + String.valueOf((Object)this.getSkyFrequencyLSB()) + "(" + this.getSideBandUse().usesUSB() + "),");
        stringBuilder.append(" " + this.getChannelAverageRegionCount() + "chavgregs {");
        for (ChannelAverageRegion channelAverageRegion : this.getChannelAverageRegion()) {
            stringBuilder.append(channelAverageRegion);
        }
        stringBuilder.append("}");
        stringBuilder.append("]");
        BusinessObject businessObject = this.getParent();
        try {
            stringBuilder.append(String.format(" parent is %s @ %h", businessObject.getClass().getSimpleName(), businessObject.hashCode()));
        }
        catch (NullPointerException nullPointerException) {
            stringBuilder.append(" parent is null");
        }
        return stringBuilder.toString();
    }

    public String detailString() {
        return this.toString();
    }

    public AbstractBaseBandConfig getBaseBandConfig() {
        try {
            return (AbstractBaseBandConfig)this.getParent();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public AbstractCorrelatorConfiguration getCorrelatorConfiguration() {
        try {
            return (AbstractCorrelatorConfiguration)this.getBaseBandConfig().getParent();
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    public SpectralSpec getSpectralSpec() {
        try {
            return (SpectralSpec)this.getCorrelatorConfiguration().getParent();
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    public abstract CorrelatorType getCorrelatorType();

    public abstract void addChannelAverageRegion(ChannelAverageRegion var1);

    public abstract void clearChannelAverageRegion();

    public abstract ChannelAverageRegion[] getChannelAverageRegion();

    @Override
    public void adjustCenterFrequency() {
    }

    public Frequency getBandwidth() {
        return this.getNominalBandwidth();
    }

    public Frequency getHalfBandwidth() {
        return (Frequency)this.getBandwidth().divide(2.0);
    }

    public int getNumSpectralChannelsPerPP() {
        int n = CorrPolarization.getCorrPolarization(this.getPolnProducts()).getProductsCount();
        return this.getNominalNumberOfChannels() / n;
    }

    @Override
    public int getSpectralWindowIndex() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (abstractBaseBandConfig != null) {
            return abstractBaseBandConfig.findSingleSpectralWindow(this);
        }
        return -1;
    }

    @Override
    public AbstractSpectralWindow getSingleSpectralWindow() {
        return this;
    }

    public Frequency getSkyFrequency() {
        if (this.getBaseBandConfig() == null) {
            return null;
        }
        return this.getBaseBandConfig().getSkyFrequency(this.getCenterFrequency(), this.getNetSideBand());
    }

    @Override
    public Frequency getSkyFrequencyLSB() {
        if (this.getBaseBandConfig() == null) {
            return null;
        }
        Frequency frequency = this.getCenterFrequency();
        switch (this.getNetSideBand()) {
            case LSB: {
                return this.getBaseBandConfig().getSkyFrequencyLSB(frequency);
            }
            case USB: {
                if (this.isPartOfPair()) {
                    return this.getBaseBandConfig().getSkyFrequencyUSB(frequency);
                }
                return null;
            }
            case DSB: {
                return this.getBaseBandConfig().getSkyFrequencyLSB(frequency);
            }
        }
        throw new RuntimeException("Unexpected netSideBand : " + String.valueOf((Object)this.getNetSideBand()));
    }

    @Override
    public Frequency getSkyFrequencyUSB() {
        if (this.getBaseBandConfig() == null) {
            return null;
        }
        Frequency frequency = this.getCenterFrequency();
        switch (this.getNetSideBand()) {
            case LSB: {
                if (this.isPartOfPair()) {
                    return this.getBaseBandConfig().getSkyFrequencyUSB(frequency);
                }
                return null;
            }
            case USB: {
                return this.getBaseBandConfig().getSkyFrequencyUSB(frequency);
            }
            case DSB: {
                return this.getBaseBandConfig().getSkyFrequencyUSB(frequency);
            }
        }
        throw new RuntimeException("Unexpected netSideBand : " + String.valueOf((Object)this.getNetSideBand()));
    }

    @Override
    public Frequency getRestFrequencyLSB() {
        Frequency frequency = this.getSkyFrequencyLSB();
        if (frequency == null) {
            return null;
        }
        if (FrequencySetup.DOPPLERREFERENCE_TOPO == this.getSpectralSpec().getFrequencySetup().getDopplerReference()) {
            return frequency;
        }
        return this.getSourceVelocity().reverseShift(frequency);
    }

    @Override
    public Frequency getRestFrequencyUSB() {
        Frequency frequency = this.getSkyFrequencyUSB();
        if (frequency == null) {
            return null;
        }
        if (FrequencySetup.DOPPLERREFERENCE_TOPO == this.getSpectralSpec().getFrequencySetup().getDopplerReference()) {
            return frequency;
        }
        return this.getSourceVelocity().reverseShift(frequency);
    }

    public Velocity getSourceVelocity() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        return spectralSpec == null ? Velocity.createVelocity() : spectralSpec.getSourceVelocity();
    }

    public NetSideBand getNetSideBand() {
        return NetSideBand.getNetSideBand(this.getSideBand());
    }

    @Override
    public SideBandUse getSideBandUse() {
        NetSideBand netSideBand = this.getNetSideBand();
        if (netSideBand == null) {
            return SideBandUse.SIDEBANDUSE_NONE;
        }
        return switch (netSideBand) {
            case NetSideBand.DSB -> SideBandUse.SIDEBANDUSE_BOTH;
            case NetSideBand.LSB -> SideBandUse.SIDEBANDUSE_LSB;
            case NetSideBand.USB -> SideBandUse.SIDEBANDUSE_USB;
            default -> throw new RuntimeException("Unexpected NetSideBand : " + String.valueOf((Object)netSideBand));
        };
    }

    public void setDefaultSideBand() {
        String string = SIDEBAND_LSB;
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            this.setSideBand(string);
            return;
        }
        SideBandUse sideBandUse = abstractBaseBandConfig.getSideBandUse();
        switch (sideBandUse) {
            case SIDEBANDUSE_BOTH: {
                string = SIDEBAND_DSB;
                break;
            }
            case SIDEBANDUSE_LSB: {
                string = SIDEBAND_LSB;
                break;
            }
            case SIDEBANDUSE_USB: {
                string = SIDEBAND_USB;
            }
        }
        this.setSideBand(string);
    }

    @Override
    public void updateSideband() {
        if (!this.isValidSideBandUseChoice(this.getSideBandUse())) {
            this.setDefaultSideBand();
        }
    }

    @Override
    public void updateSideband(@NonNull Velocity velocity) {
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (!this.isValidSideBandUseChoice(this.getSideBandUse(), velocity)) {
            this.setDefaultSideBand();
        }
    }

    @Override
    public boolean isValidSideBandUseChoice(SideBandUse sideBandUse) {
        return this.isValidSideBandUseChoice(sideBandUse, this.getSourceVelocity());
    }

    @Override
    public boolean isValidSideBandUseChoice(SideBandUse sideBandUse, Velocity velocity) {
        SpectralSpec spectralSpec;
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration;
        AbstractBaseBandConfig abstractBaseBandConfig;
        try {
            abstractBaseBandConfig = this.getBaseBandConfig();
            abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        }
        catch (NullPointerException nullPointerException) {
            return switch (sideBandUse) {
                case SideBandUse.SIDEBANDUSE_LSB -> true;
                case SideBandUse.SIDEBANDUSE_USB -> true;
                default -> false;
            };
        }
        if (!abstractCorrelatorConfiguration.isValidTypeCombination()) {
            return false;
        }
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        String string = receiverBand.getName();
        String string2 = receiverBand.getType();
        Frequency frequency = spectralSpec.getFrequencySetup().getLO1Frequency();
        Velocity velocity2 = FrequencySetup.DOPPLERREFERENCE_TOPO == this.getSpectralSpec().getFrequencySetup().getDopplerReference() || FrequencySetup.DOPPLERREFERENCE_LSRK == this.getSpectralSpec().getFrequencySetup().getDopplerReference() ? Velocity.createVelocity() : velocity;
        Frequency frequency2 = abstractBaseBandConfig.getCenterFrequency().dopplerShifted(velocity2);
        if (FrequencySetup.RECEIVERBAND_ALMA_RB_01.equals(string)) {
            return switch (sideBandUse) {
                case SideBandUse.SIDEBANDUSE_USB -> true;
                default -> false;
            };
        }
        if (FrequencySetup.RECEIVERBAND_ALMA_RB_02.equals(string)) {
            return switch (sideBandUse) {
                case SideBandUse.SIDEBANDUSE_LSB -> true;
                default -> false;
            };
        }
        if (SpectralSpec.RECEIVERTYPE_TSB.equals(string2)) {
            return switch (sideBandUse) {
                case SideBandUse.SIDEBANDUSE_LSB -> frequency2.isLessThan((AbstractDoubleWithUnit)frequency);
                case SideBandUse.SIDEBANDUSE_USB -> frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency);
                default -> false;
            };
        }
        if (SpectralSpec.RECEIVERTYPE_DSB.equals(string2)) {
            if (abstractBaseBandConfig.isPairMode()) {
                int n = this.getSpectralWindowIndex();
                return switch (sideBandUse) {
                    case SideBandUse.SIDEBANDUSE_LSB -> {
                        if (n >= 0 && n % 2 == 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case SideBandUse.SIDEBANDUSE_USB -> {
                        if (n >= 0 && n % 2 == 1) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
            if (AbstractBaseBandConfig.DATAPRODUCTS_AUTO_ONLY.equals(abstractBaseBandConfig.getDataProducts())) {
                return switch (sideBandUse) {
                    case SideBandUse.SIDEBANDUSE_BOTH -> true;
                    default -> false;
                };
            }
            return switch (sideBandUse) {
                case SideBandUse.SIDEBANDUSE_LSB -> frequency2.isLessThan((AbstractDoubleWithUnit)frequency);
                case SideBandUse.SIDEBANDUSE_USB -> frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency);
                default -> false;
            };
        }
        Log.logger((Object)this).warning("Unknown Receiver Type : " + string2);
        return false;
    }

    @Override
    public boolean changeSideBandUse(SideBandUse sideBandUse) {
        if (this.isPartOfPair()) {
            throw new RuntimeException("This should not be called directly for a part of pair SpectralWindows.");
        }
        SideBandUse sideBandUse2 = this.getSideBandUse();
        if (sideBandUse == sideBandUse2) {
            return false;
        }
        SideBandUse sideBandUse3 = sideBandUse;
        if (!this.isValidSideBandUseChoice(sideBandUse)) {
            SideBandUse sideBandUse4 = sideBandUse2.switchSideBand();
            if (sideBandUse4 == sideBandUse2 || !this.isValidSideBandUseChoice(sideBandUse4)) {
                return false;
            }
            sideBandUse3 = sideBandUse4;
        }
        return switch (sideBandUse3) {
            case SideBandUse.SIDEBANDUSE_LSB, SideBandUse.SIDEBANDUSE_USB -> {
                this.setSideBand(sideBandUse3.toString());
                yield true;
            }
            case SideBandUse.SIDEBANDUSE_BOTH -> {
                this.setUseThisSpectralWindow(true);
                this.setSideBand(SIDEBAND_DSB);
                yield true;
            }
            case SideBandUse.SIDEBANDUSE_NONE -> false;
            default -> false;
        };
    }

    @Override
    public final boolean isPair() {
        return false;
    }

    @Override
    public AbstractSpectralWindow getLSB() {
        return this;
    }

    @Override
    public AbstractSpectralWindow getUSB() {
        return this;
    }

    public boolean isPartOfPair() {
        return this.getAssociatedSpectralWindowNumberInPair() > 0;
    }

    @Override
    public String getSpectralWindowName() {
        return this.getName();
    }

    protected SpectralWindowBand getSwb() {
        if (this.swb == null) {
            this.swb = new SpectralWindowBand(this);
            this.updateSpectralWindowBand();
        }
        return this.swb;
    }

    @Override
    public Frequency getOmegaIF2() {
        Frequency frequency = this.getCenterFrequency();
        Frequency frequency2 = (Frequency)frequency.minus((AbstractDoubleWithUnit)centerFrequencyOffset);
        return (Frequency)omega_s.minus((AbstractDoubleWithUnit)frequency2);
    }

    public void setCorrConfigMode(int n) {
        this.corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
    }

    @Override
    public void setCorrConfigMode(CorrConfigMode corrConfigMode) {
        this.corrConfigMode = corrConfigMode;
    }

    @Override
    public CorrConfigMode getCorrConfigMode() {
        if (this.corrConfigMode == CorrConfigMode.INVALID_CORRCONFIGMODE) {
            this.updateCorrConfigMode();
        }
        return this.corrConfigMode;
    }

    @Override
    public void publishCorrConfigMode() {
        if (!this.corrConfigMode.isValid()) {
            return;
        }
        Frequency frequency = this.corrConfigMode.getNominalBandwidth();
        int n = this.corrConfigMode.getNominalChannels();
        this.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.NOMINAL);
    }

    @Override
    public void updateCorrConfigMode() {
        throw new RuntimeException("This method must be overriden.");
    }

    @Override
    public Frequency getNominalBandwidth() {
        return this.getSwb().getNominalBandwidth();
    }

    @Override
    public int getNominalNumberOfChannels() {
        return this.getSwb().getNominalChannels();
    }

    @Override
    public Frequency getResolution() {
        return this.getSwb().getResolution();
    }

    public void resetSpectralAverageRegions() {
        this.resetSpectralAverageRegions(0, true);
    }

    public void resetSpectralAverageRegions(int n, boolean bl) {
        int n2;
        int n3;
        if (!bl && n < 0) {
            throw new IllegalArgumentException("Illegal argument: index (" + n + ") did not pass the test: index < 0");
        }
        ChannelAverageRegion[] channelAverageRegionArray = this.getChannelAverageRegion();
        if (bl) {
            n3 = 0;
            n2 = channelAverageRegionArray.length;
        } else {
            n3 = n;
            n2 = n + 1;
        }
        if (n3 > 0 && n2 > 0 && (n3 > channelAverageRegionArray.length - 1 || n2 > channelAverageRegionArray.length)) {
            throw new IllegalArgumentException(String.format("Unable to find channel average regions with index range %d:%d", n3, n2));
        }
        assert (n3 >= 0 && n2 >= 0);
        for (int i = n3; i < n2; ++i) {
            int n4 = 0;
            int n5 = this.getEffectiveNumberOfChannels();
            if (this.corrConfigMode.getFilter() == CorrFilter.TDM) {
                n4 = (int)(0.05 * (double)this.getEffectiveNumberOfChannels());
                n5 = (int)(0.9 * (double)this.getEffectiveNumberOfChannels());
            }
            channelAverageRegionArray[i].setStartChannel(n4);
            channelAverageRegionArray[i].setNumberChannels(n5);
        }
    }

    @Override
    public void setBandParameters(Frequency frequency, int n, SpectralWindowBand.ChannelType channelType) {
        this.getSwb().setParameters(frequency, n, channelType);
        this.updateCorrConfigMode();
        this.resetSpectralAverageRegions();
    }

    @Override
    public void setBandParameters(Frequency frequency, Frequency frequency2, SpectralWindowBand.ChannelType channelType) {
        this.getSwb().setParameters(frequency, frequency2, channelType);
        this.updateCorrConfigMode();
    }

    @Override
    public void updateSpectralWindowBand() {
        if (this.gettrueEffectiveBandwidth() != null && this.getEffectiveNumberOfChannels() > 0) {
            this.getSwb().setParameters(this.getEffectiveBandwidth(), this.getEffectiveNumberOfChannels(), SpectralWindowBand.ChannelType.EFFECTIVE);
            this.updateCorrConfigMode();
        }
    }

    public void setEffectiveBandwidth(Frequency frequency) {
        super.setEffectiveBandwidth(frequency);
        if (frequency.getContent() > 0.0) {
            this.updateSpectralWindowBand();
        }
    }

    public void setEffectiveNumberOfChannels(int n) {
        super.setEffectiveNumberOfChannels(n);
        this.updateSpectralWindowBand();
    }

    protected void settrueEffectiveNumberOfChannels(int n) {
        super.setEffectiveNumberOfChannels(n);
    }

    public synchronized AbstractSpectralWindow deepCopy() throws CopyException {
        AbstractSpectralWindow abstractSpectralWindow = super.deepCopy();
        abstractSpectralWindow.setCorrConfigMode(this.corrConfigMode);
        return abstractSpectralWindow;
    }

    @Override
    public String getFilterMode() {
        return this.corrConfigMode.isValid() ? this.corrConfigMode.getFilter().getLabel() : null;
    }

    public boolean isACA() {
        return this instanceof ACASpectralWindow;
    }

    public String getACASynthProf() {
        if (!this.isACA()) {
            return SYNTH_PROF_UNDEFINED;
        }
        ACASpectralWindow aCASpectralWindow = (ACASpectralWindow)((Object)this);
        return aCASpectralWindow.getSynthProf();
    }

    public boolean isFrqChProfile() {
        return this.isACA() ? ((ACASpectralWindow)((Object)this)).getFrqChProfReproduction() : false;
    }

    @Override
    public Set<CorrConfigMode> getApplicableModeSet() {
        if (this.applicableModeSet == null) {
            this.updateApplicableModeSet();
        }
        return this.applicableModeSet;
    }

    public void updateApplicableModeSet() {
        throw new RuntimeException("This method must be overridden.");
    }

    @Override
    public boolean isRepresentativeWindow() {
        return this.getRepresentativeWindow();
    }

    @Override
    public DataRate getInstantaneousDataRate() {
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        int n = this.getSpectralWindowIndex();
        if (n == -1) {
            Log.logger((Object)this).warning("Can not calculate the data rate of this window");
            return DataRate.createDataRate();
        }
        CorrelatorConfigDataRate correlatorConfigDataRate = this.getCorrelatorConfiguration().getDataRateCalculator();
        DataRate[] dataRateArray = correlatorConfigDataRate.getSpectralWindowDataRates(abstractBaseBandConfig);
        if (dataRateArray.length == 0) {
            return DataRate.createDataRate();
        }
        return dataRateArray[n];
    }

    @Override
    public DataRateNode getParentDataRateNode() {
        return (DataRateNode)this.getParent();
    }

    protected void dataRateChanged() {
        this.dataRateChanged(new DataRateChangeEvent(this));
    }

    @Override
    public void dataRateChanged(DataRateChangeEvent dataRateChangeEvent) {
        DataRateNode dataRateNode = this.getParentDataRateNode();
        if (dataRateNode != null) {
            dataRateNode.dataRateChanged(dataRateChangeEvent);
        }
    }

    @Override
    public void addExpectedRestFrequencySpectralLine(@NonNull ExpectedSpectralLine expectedSpectralLine, SpectralSpec.SideBand sideBand) {
        if (expectedSpectralLine == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (StringUtils.isEmpty((CharSequence)expectedSpectralLine.getSpatalogId())) {
            throw new IllegalArgumentException("Parameter line does not have a SID");
        }
        Optional<SpectralLine> optional = Arrays.stream(this.getSpectralLine()).filter(spectralLine -> spectralLine.getSpatalogId().equals(expectedSpectralLine.getSpatalogId())).findFirst();
        if (!optional.isPresent()) {
            SpectralLine spectralLine2 = SpectralLine.createSpectralLine();
            spectralLine2.setSpatalogId(expectedSpectralLine.getSpatalogId());
            spectralLine2.setRestFrequency(expectedSpectralLine.getRestFrequency().deepCopy());
            spectralLine2.setTransition(expectedSpectralLine.getTransition());
            this.addSpectralLine(spectralLine2);
        }
    }

    @Override
    public ScienceSpectralWindow getScienceSpectralWindow() {
        return this.scienceSpectralWindow;
    }

    public void setScienceSpectralWindow(ScienceSpectralWindow scienceSpectralWindow) {
        this.scienceSpectralWindow = scienceSpectralWindow;
    }
}

