/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.AdvancedWindowSetup;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ConfigModeDecoder;
import alma.obsprep.bo.schedblock.ConfigModeDecoderImpl;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.etc.ETCTimeCalculator;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.NonNull;

public class CorrConfigMode
implements Comparable<CorrConfigMode> {
    private static final double THREE_BIT_DIGITIZER_LOSS = 0.96;
    static SortedSet<CorrConfigMode> allModes;
    static TreeMap<Integer, CorrConfigMode> modeMap;
    static ConfigModeDecoder decoder;
    public static final int INVALID_CORRCONFIGMODE_NUMBER = -1;
    public static final CorrConfigMode INVALID_CORRCONFIGMODE;
    public static final double HANNING_SMOOTHING_FACTOR = 2.0;
    private final int mode;
    private final Frequency nominalBandwidth;
    private final Frequency acaChProfBandwidth;
    private final int nominalChannels;
    private final int acaChProfChannels;
    private final CorrBits bits;
    private final boolean isOverSampled;
    private final CorrPolarization polarization;
    private final CorrFilter filter;
    private final double blEfficiency;
    private final double acaEfficiency;
    public static final int VLBI_MODE = 52;
    private static final Frequency BW31MHZ;

    private CorrConfigMode(int n, double d, int n2, double d2, int n3, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d3, double d4) {
        this.mode = n;
        this.nominalBandwidth = Frequency.createFrequencyGHZ(d);
        this.acaChProfBandwidth = Frequency.createFrequencyGHZ(d2);
        this.nominalChannels = n2;
        this.acaChProfChannels = n3;
        this.bits = CorrBits.getCorrBits(eBits2);
        this.isOverSampled = bl;
        this.polarization = CorrPolarization.getCorrPolarization(ePolarization2);
        this.filter = CorrFilter.getCorrFilter(eFilterMode2);
        this.blEfficiency = d3;
        this.acaEfficiency = d4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[" + this.mode + "] ").append("BW=" + String.valueOf((Object)this.nominalBandwidth) + "MHz,").append("CH=" + this.nominalChannels + ",").append("bits=" + String.valueOf((Object)this.bits) + ",").append("OS=" + this.isOverSampled + ",").append("PP=" + String.valueOf((Object)this.polarization) + ",").append("filter=" + String.valueOf((Object)this.filter));
        return stringBuilder.toString();
    }

    public static CorrConfigMode fromString(String string) {
        Integer n;
        CorrConfigMode corrConfigMode = null;
        if (string == null) {
            return null;
        }
        try {
            n = Integer.parseInt(string.substring(1, string.indexOf("]")));
        }
        catch (NumberFormatException numberFormatException) {
            return corrConfigMode;
        }
        corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
        if (corrConfigMode == INVALID_CORRCONFIGMODE) {
            return null;
        }
        return corrConfigMode;
    }

    @Override
    public int compareTo(CorrConfigMode corrConfigMode) {
        return Integer.compare(this.mode, corrConfigMode.getMode());
    }

    public static CorrConfigMode getCorrConfigMode(int n) {
        if (modeMap.keySet().contains(n)) {
            return modeMap.get(n);
        }
        return INVALID_CORRCONFIGMODE;
    }

    public boolean isValid() {
        return this != INVALID_CORRCONFIGMODE;
    }

    public Frequency getEffectiveBandwidth() {
        return this.getEffectiveBandwidth(false);
    }

    public Frequency getEffectiveBandwidth(boolean bl) {
        if (bl) {
            return this.acaChProfBandwidth;
        }
        double d = this.nominalBandwidth.getContentInUnits(this.nominalBandwidth.getUnit()) * 0.9375;
        return Frequency.createFrequency((double)d, (String)this.nominalBandwidth.getUnit());
    }

    public int getEffectiveChannels() {
        return this.getEffectiveChannels(false);
    }

    public int getEffectiveChannels(boolean bl) {
        if (bl) {
            return this.acaChProfChannels;
        }
        double d = 1.0;
        if (this.filter == CorrFilter.TFB) {
            d = 0.9375;
        }
        return (int)Math.round((double)this.nominalChannels * d);
    }

    public Frequency getResolution() {
        return Frequency.createFrequencyGHZ(this.nominalBandwidth.getContentInGHz() / (double)this.nominalChannels);
    }

    @Deprecated
    public Frequency getResolutionSmoothed() {
        return (Frequency)this.getResolution().multiply(2.0);
    }

    public Frequency getEffectiveResolution(AdvancedWindowSetup advancedWindowSetup) {
        Frequency frequency = this.getResolution();
        SpectralAverage spectralAverage = SpectralAverage.getValue(advancedWindowSetup.getSmoothingFactor());
        try {
            frequency = (Frequency)frequency.multiply(spectralAverage.getResolutionScalingFactor(advancedWindowSetup.getSmoothingFunction()));
        }
        catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
            return frequency;
        }
        return frequency;
    }

    public boolean isOversampling() {
        return this.isOverSampled;
    }

    public double getBLEfficiency() {
        return this.blEfficiency * 0.96;
    }

    public double getACAEfficiency() {
        return this.acaEfficiency * 0.96;
    }

    public CorrFraction getFraction() {
        if (this.filter == CorrFilter.TDM) {
            return CorrFraction.FULL;
        }
        if (this.isSensitivityImproveMode()) {
            return CorrFraction.FULL;
        }
        try {
            int n = (int)decoder.getChannels(this.mode);
            int n2 = this.polarization.getProductsCount();
            int n3 = 8192 / (n * n2);
            switch (n3) {
                case 1: {
                    return CorrFraction.FULL;
                }
                case 2: {
                    return CorrFraction.HALF;
                }
                case 4: {
                    return CorrFraction.QUARTER;
                }
                case 8: {
                    return CorrFraction.EIGHTH;
                }
                case 16: {
                    return CorrFraction.SIXTEENTH;
                }
                case 32: {
                    return CorrFraction.THIRTYSECOND;
                }
            }
            return null;
        }
        catch (ConfigModeDecoder.ConfigModeException configModeException) {
            return null;
        }
    }

    public boolean isSensitivityImproveMode() {
        switch (this.filter) {
            case TDM: {
                return !this.bits.equals((Object)CorrBits.B2x2);
            }
            case TFB: {
                if (this.bits != CorrBits.B2x2) {
                    return true;
                }
                if (this.nominalBandwidth.isEqual((AbstractDoubleWithUnit)BW31MHZ)) {
                    return false;
                }
                return this.isOverSampled;
            }
        }
        return false;
    }

    public boolean isExtraBits() {
        return !this.bits.equals((Object)CorrBits.B2x2);
    }

    public String formatWindowDescription(Frequency frequency, AdvancedWindowSetup advancedWindowSetup) {
        Object object;
        if (advancedWindowSetup == null) {
            return "";
        }
        String string = String.format("%12s", this.formatBandwidth());
        String string2 = String.format("%8s", this.formatEffectiveResolution(advancedWindowSetup));
        String string3 = "";
        String string4 = "";
        try {
            object = (SpectralSetupParameters)advancedWindowSetup.getParent().getParent();
            ReceiverBand receiverBand = null;
            if (object != null) {
                receiverBand = ((SpectralSetupParameters)((Object)object)).getReceiverBand();
            }
            if (receiverBand != null) {
                Speed speed = Speed.getSpeedResolution(this.getEffectiveBandwidth(), frequency);
                string3 = String.format("%s", this.formatSpeed(speed, 4, 0));
                string4 = String.format("%s", this.formatEffectiveVelocity(frequency, advancedWindowSetup));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        object = new StringBuilder(string);
        if (string3.length() > 0) {
            ((StringBuilder)object).append("(").append(string3).append(")");
        }
        ((StringBuilder)object).append(", " + string2);
        if (string4.length() > 0) {
            ((StringBuilder)object).append("(").append(string4).append(")");
        }
        ((StringBuilder)object).append(" (" + this.bits.getLabel() + ")");
        try {
            if (ObsProposal.isVLBIRelated() && this.getMode() == 52) {
                ((StringBuilder)object).append("+VLBI");
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        return ((StringBuilder)object).toString();
    }

    public static String formatChannel(int n) {
        return String.format("%d", n);
    }

    public String formatBandwidth() {
        return CorrConfigMode.formatBandwidth(this.getEffectiveBandwidth().getContentInMHz());
    }

    public static String formatBandwidth(Frequency frequency) {
        return CorrConfigMode.formatBandwidth(frequency.getContentInMHz());
    }

    public static String formatBandwidth(double d) {
        return TextUtils.format(Frequency.createFrequencyMHZ(d), 3, 3);
    }

    public static String formatResolution(Frequency frequency) {
        return CorrConfigMode.formatResolution(frequency.getContentInMHz());
    }

    public static String formatResolution(double d) {
        return TextUtils.format(Frequency.createFrequencyMHZ(d).convertToFriendlyUnit(), 3, 3);
    }

    public String formatEffectiveResolution(AdvancedWindowSetup advancedWindowSetup) {
        return CorrConfigMode.formatResolution(this.getEffectiveResolution(advancedWindowSetup).getContentInMHz());
    }

    public String formatEffectiveVelocity(Frequency frequency, AdvancedWindowSetup advancedWindowSetup) {
        Speed speed = Speed.getSpeedResolution(this.getEffectiveResolution(advancedWindowSetup), frequency);
        return this.formatSpeed(speed, 2, 3);
    }

    public Speed getEffectiveVelocity(Frequency frequency, AdvancedWindowSetup advancedWindowSetup) {
        return Speed.getSpeedResolution(this.getEffectiveResolution(advancedWindowSetup), frequency);
    }

    public String formatSpeed(Speed speed, int n, int n2) {
        return TextUtils.format(speed, n, n2);
    }

    public static CorrConfigMode get2bitEquivalentCorrelatorMode(@NonNull CorrConfigMode corrConfigMode) {
        if (corrConfigMode == null) {
            throw new NullPointerException("corrConfigMode is marked non-null but is null");
        }
        Map<Integer, Integer> map = Map.of(114, 38, 115, 39, 116, 41, 117, 44, 118, 48);
        if (!map.containsKey(corrConfigMode.getMode())) {
            return corrConfigMode;
        }
        return CorrConfigMode.getCorrConfigMode(map.get(corrConfigMode.getMode()));
    }

    public static ETCTimeCalculator.CorrelatorModeConversionEnum getCorrelatorConversionMode(@NonNull Array array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return Array.isTP(array) ? ETCTimeCalculator.CorrelatorModeConversionEnum.Convert4BitModeTo2Bit : ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion;
    }

    public static SortedSet<CorrConfigMode> getAllModes() {
        return allModes;
    }

    public int getMode() {
        return this.mode;
    }

    public Frequency getNominalBandwidth() {
        return this.nominalBandwidth;
    }

    public int getNominalChannels() {
        return this.nominalChannels;
    }

    public CorrBits getBits() {
        return this.bits;
    }

    public CorrPolarization getPolarization() {
        return this.polarization;
    }

    public CorrFilter getFilter() {
        return this.filter;
    }

    static {
        InitServices.initModelSupportClasses();
        allModes = new TreeSet<CorrConfigMode>();
        modeMap = new TreeMap();
        decoder = new ConfigModeDecoderImpl();
        for (int n : decoder.getKnownModes()) {
            try {
                double d = decoder.getNominalBandwidthGHz(n);
                double d2 = decoder.getNominalBandwidthGHz(n, true);
                int n2 = (int)decoder.getChannels(n);
                int n3 = (int)decoder.getChannels(n, true);
                ConfigModeDecoder.eBits eBits2 = decoder.getBits(n);
                boolean bl = decoder.isOversampled(n);
                ConfigModeDecoder.ePolarization ePolarization2 = decoder.getPolarizationProducts(n);
                ConfigModeDecoder.eFilterMode eFilterMode2 = decoder.getFilterMode(n);
                double d3 = decoder.getBLEfficiency(n);
                double d4 = decoder.getACAEfficiency(n);
                CorrConfigMode corrConfigMode = new CorrConfigMode(n, d, n2, d2, n3, eBits2, bl, ePolarization2, eFilterMode2, d3, d4);
                allModes.add(corrConfigMode);
                modeMap.put(n, corrConfigMode);
            }
            catch (ConfigModeDecoder.ConfigModeException configModeException) {
                Log.Logger logger = Log.logger(CorrConfigMode.class);
                logger.severe(configModeException.getMessage());
            }
        }
        INVALID_CORRCONFIGMODE = new CorrConfigMode(-1, 0.0, 0, 0.0, 0, null, false, null, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.0, 0.0);
        BW31MHZ = Frequency.createFrequencyMHZ(31.25);
    }
}

