/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BOWithSpecificName;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.SpatialPartOfSpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ACABaseBandConfig;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.DataRateChangeEvent;
import alma.obsprep.bo.schedblock.DataRateChangeListener;
import alma.obsprep.bo.schedblock.DataRateNode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.LOsolutionsAdaptor;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.ACACorrelatorConfigurationData;
import alma.obsprep.bo.schedblock.data.BaseBandSpecificationData;
import alma.obsprep.bo.schedblock.data.SpectralSpecData;
import alma.obsprep.ot.editors.misc.SpectralSpecSummaryTableColumns;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public class SpectralSpec
extends SpectralSpecData
implements SpectralSpecDocument,
BOWithSpecificName,
DataRateNode {
    private SBGenerationContext sbGenerationContext;
    public static final int MAX_BASE_BAND = 4;
    private static final Frequency TWO_GHZ = Frequency.createFrequencyGHZ(2.0);
    private final LOsolutionsAdaptor loSolutionsAdapter = new LOsolutionsAdaptor(this);
    private Velocity sourceVelocity;
    private boolean suspendDataChangeNotifier = false;
    private final ArrayList<DataRateChangeListener> dataRateChangeListeners = new ArrayList();
    private final List<SpectralLine> overlayLines = new ArrayList<SpectralLine>();

    public SpectralSpec(SpectralSpecT spectralSpecT) {
        super(spectralSpecT);
        this.summaryTableColumns = new SpectralSpecSummaryTableColumns(this);
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return this;
    }

    public void initAsNew() {
        super.initAsNew();
        this.setReceiverType(RECEIVERTYPE_TSB);
        this.setSwitchingType(SWITCHINGTYPE_NO_SWITCHING);
    }

    protected void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
        SpectralSpec spectralSpec = (SpectralSpec)iBusinessObject;
        if (spectralSpec.getSbGenerationContext() != null) {
            this.sbGenerationContext = spectralSpec.getSbGenerationContext().deepCopy();
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.gettrueAbstractCorrelatorConfiguration();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration2 = this.gettrueAbstractCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration != null) {
            FrequencySetup frequencySetup = spectralSpec.gettrueFrequencySetup();
            FrequencySetup frequencySetup2 = this.gettrueFrequencySetup();
            if (frequencySetup != null) {
                BaseBandSpecification[] baseBandSpecificationArray = frequencySetup.getBaseBandSpecification();
                BaseBandSpecification[] baseBandSpecificationArray2 = frequencySetup2.getBaseBandSpecification();
                block0: for (int i = 0; i < abstractCorrelatorConfiguration.getBaseBandConfigCount(); ++i) {
                    AbstractBaseBandConfig abstractBaseBandConfig = abstractCorrelatorConfiguration.getBaseBandConfig(i);
                    abstractCorrelatorConfiguration2.getBaseBandConfig(i);
                    BaseBandSpecification baseBandSpecification = abstractBaseBandConfig.getBaseBandSpecification();
                    for (int j = 0; j < baseBandSpecificationArray2.length; ++j) {
                        if (baseBandSpecification != baseBandSpecificationArray[j]) continue;
                        BaseBandSpecification baseBandSpecification2 = baseBandSpecificationArray2[j];
                        abstractCorrelatorConfiguration2.getBaseBandConfig(i).setBaseBandSpecification(baseBandSpecification2);
                        continue block0;
                    }
                }
            }
        }
    }

    public Velocity getSourceVelocity() {
        if (this.sourceVelocity == null) {
            this.sourceVelocity = Velocity.createVelocity();
        }
        return this.sourceVelocity;
    }

    public SchedBlock getSchedBlock() {
        SchedBlock schedBlock = (SchedBlock)this.getParent();
        return schedBlock == null ? null : schedBlock;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNameOrDefault());
        if (this.isACASpectralSpec()) {
            stringBuilder.append("[ACA SB]");
        } else if (this.isBLSpectralSpec()) {
            stringBuilder.append("[12m Array SB]");
        }
        stringBuilder.append(" (");
        int n2 = this.getBaseBandCount();
        if (n2 == 1) {
            stringBuilder.append("1 BBC");
        } else {
            stringBuilder.append(n2);
            stringBuilder.append(" BBCs");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean isACASpectralSpec() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getAbstractCorrelatorConfiguration();
        return abstractCorrelatorConfiguration != null && abstractCorrelatorConfiguration.getCorrelatorType() == CorrelatorType.ACA;
    }

    public boolean isBLSpectralSpec() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getAbstractCorrelatorConfiguration();
        return abstractCorrelatorConfiguration != null && abstractCorrelatorConfiguration.getCorrelatorType() == CorrelatorType.BL;
    }

    public boolean isPureTDM() {
        for (AbstractBaseBandConfig abstractBaseBandConfig : this.getBaseBandConfig()) {
            if (1 != abstractBaseBandConfig.getSpectralWindowCount()) {
                return false;
            }
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                CorrConfigMode corrConfigMode = spectralWindowI.getCorrConfigMode();
                boolean bl = corrConfigMode.getFilter().equals((Object)CorrFilter.TDM);
                if (bl && TWO_GHZ.isEqual((AbstractDoubleWithUnit)spectralWindowI.getEffectiveBandwidth())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSpatial() {
        return false;
    }

    public ReceiverBand getReceiverBand() {
        return ReceiverBand.getReceiverBand(this.getFrequencySetup().getReceiverBand());
    }

    public Frequency getLO1Frequency() {
        return this.getFrequencySetup().getLO1Frequency();
    }

    public void setLO1Frequency(Frequency frequency) {
        this.getFrequencySetup().setLO1Frequency(frequency);
    }

    public int getBaseBandConfigCount() {
        return this.getBaseBandCount();
    }

    public boolean setLOInSpectralSpec(Velocity velocity) {
        return this.setLOInSpectralSpec(velocity, false);
    }

    public boolean setLOInSpectralSpec(Velocity velocity, boolean bl) {
        return this.setLOInSpectralSpec(velocity, bl, 0, false);
    }

    public ObservingToolGui.FeedbackInfo getFeedbackInfo() {
        return this.loSolutionsAdapter.getFeedbackInfo();
    }

    public boolean isLSB() {
        Range range;
        FrequencySetup frequencySetup = this.getFrequencySetup();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(frequencySetup.getReceiverBand());
        double d = frequencySetup.getRestFrequency().getContentInGHz();
        return d < (range = new Range(receiverBand.getRFMin(), receiverBand.getRFMax())).mid();
    }

    public static SpectralSpec createSpectralSpecWithBLCorrelatorConfiguration(@NonNull Optional<SBGenerationContext> optional) {
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)((Object)BLCorrelatorConfiguration.createBLCorrelatorConfiguration()));
        return spectralSpec;
    }

    public static SpectralSpec createSpectralSpecWithACACorrelatorConfiguration(@NonNull Optional<SBGenerationContext> optional) {
        ACACorrelatorConfiguration aCACorrelatorConfiguration;
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        if (optional.isEmpty()) {
            aCACorrelatorConfiguration = ACACorrelatorConfiguration.createACACorrelatorConfiguration();
        } else {
            SBGenerationContext sBGenerationContext = optional.get();
            boolean bl = sBGenerationContext.isTPAmpCalSB() || sBGenerationContext.isTPScienceSB() ? sBGenerationContext.isACACorrelatorConfigurationRequired() : true;
            aCACorrelatorConfiguration = bl ? ACACorrelatorConfiguration.createACACorrelatorConfiguration() : ACASpectrometerCorrelatorConfiguration.createACASpectrometerCorrelatorConfiguration();
        }
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)((Object)aCACorrelatorConfiguration));
        return spectralSpec;
    }

    public static SpectralSpec createSpectralSpecWithSquareLawSetup() {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        spectralSpec.setSquareLawSetup(SquareLawSetup.createSquareLawSetup());
        return spectralSpec;
    }

    public AbstractCorrelatorConfiguration getCorrelatorConfiguration() {
        return this.getAbstractCorrelatorConfiguration();
    }

    public CorrelatorExpert getCorrelatorExpert() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfigurationData || abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            return CorrelatorExpert.getInstance(CorrelatorType.ACA);
        }
        return CorrelatorExpert.getInstance(CorrelatorType.BL);
    }

    public void setCorrelatorConfiguration(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        this.setAbstractCorrelatorConfiguration(abstractCorrelatorConfiguration);
        this.dataRateChanged();
    }

    public ObsUnitSet getContainingObsUnitSet() {
        ObsUnitSetComponent obsUnitSetComponent = (ObsUnitSetComponent)this.getParent();
        return obsUnitSetComponent.getContainingObsUnitSet();
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            super.setName("");
        } else {
            String string2 = string.replaceAll("[^\\x00-\\x7f]", "_");
            super.setName(string2);
        }
    }

    public void setReceiverBandName(String string) {
        this.getFrequencySetup().setReceiverBand(string);
    }

    public void setTransitionName(String string) {
        this.getFrequencySetup().setTransitionName(string);
    }

    public void setRestFrequency(Frequency frequency) {
        this.getFrequencySetup().setRestFrequency(frequency);
    }

    @Override
    public SpatialPartOfSpectralSpecDocument getSpatialPartOfSpectralSpecDocument() {
        return null;
    }

    public String getReceiverBandName() {
        return this.getFrequencySetup().getReceiverBand();
    }

    public String getTransitionName() {
        return this.getFrequencySetup().getTransitionName();
    }

    public Frequency getRestFrequency() {
        return this.getFrequencySetup().getRestFrequency();
    }

    public void addDataRateChangeListener(DataRateChangeListener dataRateChangeListener) {
        if (!this.dataRateChangeListeners.contains(dataRateChangeListener)) {
            this.dataRateChangeListeners.add(dataRateChangeListener);
        }
    }

    @Override
    public DataRate getInstantaneousDataRate() {
        if (this.hasCorrelatorConfiguration()) {
            return this.getCorrelatorConfiguration().getInstantaneousDataRate();
        }
        return DataRate.createDataRate();
    }

    @Override
    public void dataRateChanged(DataRateChangeEvent dataRateChangeEvent) {
        this.dataRateChanged();
    }

    public void suspendDataRateChangeNotifier() {
        this.suspendDataChangeNotifier = true;
    }

    public void activateDataRateChangeNotifier() {
        this.suspendDataChangeNotifier = false;
    }

    private void dataRateChanged() {
        if (this.suspendDataChangeNotifier) {
            return;
        }
        for (DataRateChangeListener dataRateChangeListener : this.dataRateChangeListeners) {
            dataRateChangeListener.dataRateChanged(new DataRateChangeEvent(this));
        }
    }

    @Override
    public DataRateNode getParentDataRateNode() {
        return this;
    }

    public static int maxBaseBandCount() {
        return 4;
    }

    public AbstractBaseBandConfig addNewBaseBandConfig() {
        if (this.hasCorrelatorConfiguration()) {
            return (AbstractBaseBandConfig)this.addNewBaseBand();
        }
        Log.logger((Object)this).warning("Can not add a BaseBandConfig to a SpectralSpec without CorrelatorConfiguration.");
        return null;
    }

    public BaseBand addNewBaseBand() {
        return this.addNewBaseBand(this.getBaseBandCount(), false);
    }

    public BaseBand addNewBaseBand(int n, boolean bl) {
        if (n >= SpectralSpec.maxBaseBandCount()) {
            throw new IllegalArgumentException("index must be less than " + SpectralSpec.maxBaseBandCount());
        }
        FrequencySetup frequencySetup = this.getFrequencySetup();
        BaseBandSpecification baseBandSpecification = frequencySetup.addNewBaseBandSpecification(n);
        if (baseBandSpecification == null) {
            GUIUtilities.error(null, "Could not add BaseBandSpecification to this FrequencySetup");
        }
        if (this.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            AbstractBaseBandConfig abstractBaseBandConfig = abstractCorrelatorConfiguration.addNewBaseBandConfig(n);
            abstractBaseBandConfig.setBaseBandSpecification(baseBandSpecification);
            if (bl) {
                CorrelatorType correlatorType = CorrelatorType.BL;
                if (abstractBaseBandConfig.isACA()) {
                    correlatorType = CorrelatorType.ACA;
                    ((ACABaseBandConfig)((Object)abstractBaseBandConfig)).setPolnProducts(CorrPolarization.DOUBLE.polnProducts);
                }
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(correlatorType);
                CorrPolarization corrPolarization = CorrPolarization.DOUBLE;
                SpectralWindowI spectralWindowI = abstractBaseBandConfig.addNewSpectralWindow();
                spectralWindowI.setCorrConfigMode(correlatorExpert.getContinuumMode(corrPolarization));
                spectralWindowI.adjustCenterFrequency();
                spectralWindowI.publishCorrConfigMode();
            }
            return abstractBaseBandConfig;
        }
        return baseBandSpecification;
    }

    public void removeBaseBand(BaseBand baseBand) {
        BaseBandSpecification baseBandSpecification = baseBand.getBaseBandSpecification();
        AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
        if (abstractBaseBandConfig != null) {
            abstractBaseBandConfig.setBaseBandSpecification(null);
        }
        this.getFrequencySetup().removeBaseBandSpecification(baseBandSpecification);
        if (this.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration.primitiveRemoveBaseBandConfig(abstractBaseBandConfig);
        }
    }

    public void clearBaseBand() {
        if (this.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration.clearBaseBandConfig();
        }
        this.getFrequencySetup().clearBaseBandSpecification();
    }

    public boolean hasSquareLawSetup() {
        return this.gettrueSquareLawSetup() != null;
    }

    public boolean hasCorrelatorConfiguration() {
        return this.gettrueAbstractCorrelatorConfiguration() != null;
    }

    public BaseBandSpecification[] getBaseBandSpecification() {
        return this.getFrequencySetup().getBaseBandSpecification();
    }

    public BaseBandSpecification getBaseBandSpecification(int n) {
        return this.getFrequencySetup().getBaseBandSpecification(n);
    }

    public int getBaseBandCount() {
        return this.getFrequencySetup().getBaseBandSpecificationCount();
    }

    public BaseBandHolder getBaseBandHolder() {
        if (this.hasCorrelatorConfiguration()) {
            return this.getCorrelatorConfiguration();
        }
        return this.getFrequencySetup();
    }

    public BaseBand[] getBaseBand() {
        return this.getBaseBandHolder().getBaseBand();
    }

    public BaseBand getBaseBand(int n) {
        return this.getBaseBandHolder().getBaseBand(n);
    }

    public AbstractBaseBandConfig getBaseBandConfig(int n) {
        if (this.hasCorrelatorConfiguration()) {
            return (AbstractBaseBandConfig)this.getBaseBand(n);
        }
        return null;
    }

    public List<AbstractBaseBandConfig> getBaseBandConfig() {
        ArrayList<AbstractBaseBandConfig> arrayList = new ArrayList<AbstractBaseBandConfig>();
        for (int i = 0; i < this.getBaseBandConfigCount(); ++i) {
            arrayList.add(this.getBaseBandConfig(i));
        }
        return arrayList;
    }

    public void setOverlayLines(List<SpectralLine> list) {
        this.overlayLines.clear();
        if (list != null) {
            this.overlayLines.addAll(list);
        }
    }

    public List<SpectralLine> getOverlayLines() {
        return Collections.unmodifiableList(this.overlayLines);
    }

    public Frequency getFilteredSpectralWindow(FilteringCriteria filteringCriteria) throws IncompleteCorrelatorSetupFoundException {
        Frequency object = null;
        if (!this.hasCorrelatorConfiguration()) {
            throw new IncompleteCorrelatorSetupFoundException("No correlator configuration attached to spectral spec.");
        }
        ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getAbstractCorrelatorConfiguration();
        Frequency frequency = Frequency.createFrequencyGHZ(1.0);
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            for (BLBaseBandConfig bLBaseBandConfig : bLCorrelatorConfiguration.getBLBaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : bLBaseBandConfig.getBLSpectralWindow()) {
                    arrayList.add((Frequency)((Frequency)bLBaseBandConfig.getCenterFrequencySky().minus((AbstractDoubleWithUnit)frequency)).plus((AbstractDoubleWithUnit)((Frequency)spectralWindowI.getCenterFrequency().minus((AbstractDoubleWithUnit)TWO_GHZ))));
                }
            }
        } else if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            ACACorrelatorConfiguration aCACorrelatorConfiguration = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            for (ACABaseBandConfig aCABaseBandConfig : aCACorrelatorConfiguration.getACABaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : aCABaseBandConfig.getACASpectralWindow()) {
                    arrayList.add((Frequency)((Frequency)aCABaseBandConfig.getCenterFrequencySky().minus((AbstractDoubleWithUnit)frequency)).plus((AbstractDoubleWithUnit)((Frequency)spectralWindowI.getCenterFrequency().minus((AbstractDoubleWithUnit)TWO_GHZ))));
                }
            }
        } else if (abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            ACASpectrometerCorrelatorConfiguration aCASpectrometerCorrelatorConfiguration = (ACASpectrometerCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            for (ACABaseBandConfig aCABaseBandConfig : aCASpectrometerCorrelatorConfiguration.getACABaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : aCABaseBandConfig.getACASpectralWindow()) {
                    arrayList.add((Frequency)((Frequency)aCABaseBandConfig.getCenterFrequencySky().minus((AbstractDoubleWithUnit)frequency)).plus((AbstractDoubleWithUnit)((Frequency)spectralWindowI.getCenterFrequency().minus((AbstractDoubleWithUnit)TWO_GHZ))));
                }
            }
        } else {
            throw new WizardSBGenerationException("Unknown correlator type " + String.valueOf(abstractCorrelatorConfiguration.getClass()));
        }
        block10: for (Frequency frequency2 : arrayList) {
            if (object == null) {
                object = frequency2;
                continue;
            }
            Frequency frequency3 = frequency2;
            switch (filteringCriteria) {
                case HIGHESTFREQUENCY: {
                    if (!frequency3.isGreaterThan((AbstractDoubleWithUnit)object)) continue block10;
                    object = frequency3.deepCopy();
                    continue block10;
                }
                case LOWESTFREQUENCY: {
                    if (!frequency3.isLessThan((AbstractDoubleWithUnit)object)) continue block10;
                    object = frequency3.deepCopy();
                    continue block10;
                }
            }
            throw new RuntimeException("Unknown filter type " + String.valueOf((Object)filteringCriteria));
        }
        if (object == null) {
            throw new IncompleteCorrelatorSetupFoundException("No spectral windows were found in the correlator setup");
        }
        return object;
    }

    public Optional<List<Target>> locateAllDopplerTargetInSB() throws SpectralSpecAncestorIsAnObservatoryGoalException, NoAbstractScienceGoalFoundAsParentException {
        if (this.getGeneratingScienceGoal() instanceof ObservatoryGoal) {
            throw new SpectralSpecAncestorIsAnObservatoryGoalException();
        }
        List<Target> list = Stream.of(this.getSchedBlock().getObservingGroup()).map(observingGroup -> observingGroup.getMainTarget()).filter(target -> target != null).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list);
    }

    public List<Target> getObservingGroupDopplerTargetsForSpectralSpec() throws NoAbstractScienceGoalFoundAsParentException, SpectralSpecAncestorIsAnObservatoryGoalException {
        AbstractScienceGoal abstractScienceGoal = this.getGeneratingScienceGoal();
        if (abstractScienceGoal instanceof ObservatoryGoal) {
            throw new SpectralSpecAncestorIsAnObservatoryGoalException();
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : this.getTargetList()) {
            if (!target.hasScienceParameters()) continue;
            for (ObservingGroup observingGroup : target.getObservingGroupList()) {
                if (observingGroup.getMainTarget() == null || arrayList.contains(observingGroup.getMainTarget())) continue;
                arrayList.add(observingGroup.getMainTarget());
            }
        }
        return arrayList;
    }

    public AbstractScienceGoal getGeneratingScienceGoal() throws NoAbstractScienceGoalFoundAsParentException {
        ObsUnitSet obsUnitSet;
        SpectralSpec spectralSpec = this;
        AbstractScienceGoal abstractScienceGoal = null;
        while (!((spectralSpec = spectralSpec.getParent()) instanceof ObsUnitSet && (abstractScienceGoal = (obsUnitSet = (ObsUnitSet)((Object)spectralSpec)).getGeneratingScienceGoal()) != null || spectralSpec == null)) {
        }
        if (spectralSpec == null || abstractScienceGoal == null) {
            throw new NoAbstractScienceGoalFoundAsParentException("Unable to determine parent abstract science goal for spectral spec " + this.getName());
        }
        return abstractScienceGoal;
    }

    public boolean setLOInSpectralSpec(Velocity velocity, boolean bl, int n, boolean bl2) {
        FrequencySetup frequencySetup = this.getFrequencySetup();
        if (frequencySetup.getHasHardwareSetup() && !bl2) {
            return true;
        }
        if (this.sbGenerationContext != null) {
            ScienceGoal scienceGoal = this.sbGenerationContext.getGoal();
            ReceiverBand receiverBand = this.sbGenerationContext.getReceiverBand();
            if (scienceGoal.isSpectralScan() && ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10)) {
                frequencySetup.setSideBandPreferences(new String[]{BaseBandSpecificationData.SIDEBANDPREFERENCE_LSB, BaseBandSpecificationData.SIDEBANDPREFERENCE_LSB, BaseBandSpecificationData.SIDEBANDPREFERENCE_LSB, BaseBandSpecificationData.SIDEBANDPREFERENCE_LSB});
            }
        }
        return this.loSolutionsAdapter.calculate(velocity, frequencySetup.getSideBandPreferences(), bl, n);
    }

    public SBGenerationContext getSbGenerationContext() {
        return this.sbGenerationContext;
    }

    public void setSbGenerationContext(SBGenerationContext sBGenerationContext) {
        this.sbGenerationContext = sBGenerationContext;
    }

    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    public static class IncompleteCorrelatorSetupFoundException
    extends Exception {
        public IncompleteCorrelatorSetupFoundException(String string) {
            super(string);
        }
    }

    public static enum FilteringCriteria {
        LOWESTFREQUENCY,
        HIGHESTFREQUENCY;

    }

    public static class SpectralSpecAncestorIsAnObservatoryGoalException
    extends Exception {
    }

    public static class NoAbstractScienceGoalFoundAsParentException
    extends Exception {
        public NoAbstractScienceGoalFoundAsParentException(String string) {
            super(string);
        }
    }

    public static enum SideBand {
        USB,
        LSB;


        public boolean isUpper() {
            return this == USB;
        }

        public boolean isLower() {
            return this == LSB;
        }
    }
}

