/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.defaulters;

import alma.obsprep.defaulters.Range;

public class NumericRange
implements Range {
    private final double lower;
    private final boolean lowerIn;
    private final double upper;
    private final boolean upperIn;

    public NumericRange(double d, double d2, boolean bl, boolean bl2) {
        this.lower = d;
        this.upper = d2;
        this.lowerIn = bl;
        this.upperIn = bl2;
    }

    private boolean isValid(Double d) {
        double d2 = d;
        if (this.lower < d2 && d2 < this.upper || this.lowerIn && d2 == this.lower) {
            return true;
        }
        return this.upperIn && d2 == this.upper;
    }

    private boolean isValid(Float f) {
        Double d = f.doubleValue();
        return this.isValid(d);
    }

    private boolean isValid(Integer n) {
        Double d = n.doubleValue();
        return this.isValid(d);
    }

    @Override
    public boolean isValid(Object object) {
        if (object instanceof Double) {
            Double d = (Double)object;
            return this.isValid(d);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return this.isValid(f);
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return this.isValid(n);
        }
        throw new IllegalArgumentException("Unknown type: " + object.getClass().getName());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lowerIn ? "[" : "(").append(this.lower).append(",").append(this.upper).append(this.upperIn ? "]" : ")");
        return stringBuilder.toString();
    }
}

