/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.navigator;

import alma.obsprep.guiutil.jsky.catalog.astrocat.AlmaAstroCatConfig;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaDivaImageGraphics;
import alma.obsprep.guiutil.jsky.image.graphics.gui.AlmaCanvasDraw;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigator;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplay;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayControl;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperManager;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.media.jai.PlanarImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.skycat.SkycatCatalog;
import jsky.coords.WorldCoords;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.MainImageDisplay;

public class AlmaNavigatorImageDisplayPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 77899984794260908L;
    private final double INVALID_COORDINATE = 999.0;
    protected CatalogQueryTool catalogueQueryTool;
    protected AlmaNavigatorImageDisplay imageDisplay = null;
    protected AlmaCanvasDraw almaCanvasDraw;
    private boolean figureSelectionEventEnabled = true;
    protected AlmaNavigatorImageDisplayControl imageDisplayControl;
    private final BaseSpatialVisualModel model;
    private final MapperManager mapperManager;
    private static final int IMAGE_DISPLAY_DEFAULT_SIZE = 512;
    private static final int IMAGE_PANNER_DEFAULT_SIZE = 152;
    private static final int IMAGE_DISPLAY_COMPACT_SIZE = 384;
    private static final int IMAGE_PANNER_COMPACT_SIZE = 102;
    private int imageDisplaySize;

    public AlmaNavigatorImageDisplayPanel(BaseSpatialVisualModel baseSpatialVisualModel, boolean bl) {
        this.setName("SpatialVisualEditor.ImageDisplayPanel");
        this.model = baseSpatialVisualModel;
        this.imageDisplaySize = 512;
        int n = 152;
        if (bl) {
            this.imageDisplaySize = 384;
            n = 102;
        }
        this.imageDisplayControl = this.makeImageDisplayControl(n, bl);
        this.add((Component)((Object)this.imageDisplayControl), "Center");
        this.imageDisplayControl.setPreferredSize(new Dimension(this.imageDisplaySize, this.imageDisplaySize + 50));
        this.imageDisplay = this.imageDisplayControl.getImageDisplay();
        this.imageDisplay.makeNavigatorFrame();
        this.imageDisplay.blankImage(0.0, 0.0);
        this.imageDisplay.removeMouseListener((MouseListener)this.imageDisplay.getCanvasDraw());
        this.imageDisplay.removeMouseMotionListener((MouseMotionListener)this.imageDisplay.getCanvasDraw());
        this.almaCanvasDraw = new AlmaCanvasDraw((DivaMainImageDisplay)this.imageDisplay);
        this.mapperManager = new MapperManager(this);
    }

    protected AlmaNavigatorImageDisplayControl makeImageDisplayControl(int n, boolean bl) {
        return new AlmaNavigatorImageDisplayControl(n, bl);
    }

    public void query(String string, String string2, String string3, double d, double d2) {
        this.query(string, string2, string3, 999.0, 999.0, d, d2);
    }

    public void query(String string, double d, double d2, double d3, double d4) {
        this.query(string, null, null, d, d2, d3, d4);
    }

    public void query(String string, String string2, String string3, double d, double d2, double d3, double d4) {
        WorldCoords worldCoords;
        Catalog catalog = AlmaAstroCatConfig.getConfigFile().getCatalog(string);
        if (catalog == null) {
            GUIUtilities.warning(null, "SpatialVisualEditor error: Could not configure the query to this image server");
            return;
        }
        BasicQueryArgs basicQueryArgs = new BasicQueryArgs(catalog);
        if (d != 999.0 && d2 != 999.0) {
            worldCoords = new WorldCoords(d, d2, 2000.0);
            basicQueryArgs.setParamValue("ra", (Object)worldCoords.getRA().toString());
            basicQueryArgs.setParamValue("dec", (Object)worldCoords.getDec().toString());
        }
        if (string3 != null) {
            basicQueryArgs.setParamValue("name server", (Object)string2);
            basicQueryArgs.setParamValue("object", (Object)string3);
        }
        basicQueryArgs.setParamValue("image server", (Object)string);
        if (catalog instanceof SkycatCatalog) {
            basicQueryArgs.setParamValue("width", d3);
            basicQueryArgs.setParamValue("height", d4);
        } else {
            double d5 = Math.max(Double.valueOf(d3) / (double)this.imageDisplaySize, Double.valueOf(d4) / (double)this.imageDisplaySize);
            basicQueryArgs.setParamValue("size", d3);
            basicQueryArgs.setParamValue("width", d3 / d5);
            basicQueryArgs.setParamValue("height", d4 / d5);
            basicQueryArgs.setParamValue("ScalingFactor", Math.max(d3, d4) / 60.0);
        }
        worldCoords = this.imageDisplay.getNavigator();
        ((AlmaNavigator)worldCoords).setImageDisplay(this.imageDisplay);
        this.catalogueQueryTool = new CatalogQueryTool(catalog, (QueryResultDisplay)worldCoords);
        this.catalogueQueryTool.getCatalogQueryPanel().setQueryArgs((QueryArgs)basicQueryArgs);
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.catalogueQueryTool.search();
    }

    public void imageQuery(SpatialVisualParameters spatialVisualParameters) {
        double d = spatialVisualParameters.getSize();
        String string = spatialVisualParameters.getImageServer();
        String string2 = spatialVisualParameters.getSourceName();
        if (string2 == null || string2.equals("")) {
            string2 = null;
        }
        SkyCoordinates skyCoordinates = spatialVisualParameters.getSourceCoordinates().getICRSSkyCoordinates();
        double d2 = skyCoordinates.getLatitude().getDegs();
        double d3 = skyCoordinates.getLongitude().getDegs();
        this.getImageDisplay().getCanvasDraw().clear();
        if (d2 == 0.0 && d3 == 0.0 && string2 != null) {
            this.query(string, "SIMBAD Names via ESO", string2, d, d);
        } else {
            this.query(string, d3, d2, d, d);
        }
    }

    public boolean isWcsSet(boolean bl) {
        boolean bl2 = this.getImageDisplay().isWcsSet();
        if (!bl2 && bl) {
            GUIUtilities.info(null, "No WCS defined in this image.");
        }
        return bl2;
    }

    public AlmaDivaImageGraphics getImageGraphics() {
        return (AlmaDivaImageGraphics)this.imageDisplay.getCanvasGraphics();
    }

    public boolean isSourceCoordinatesSet() {
        SkyCoordinates skyCoordinates = this.getModel().getVisualModelHelper().getCenterMapperModel().getTargetCenter();
        if (skyCoordinates == null) {
            return false;
        }
        return skyCoordinates.getLatitude().getContent() != 0.0 || skyCoordinates.getLongitude().getContent() != 0.0;
    }

    public boolean imageContains() {
        SkyCoordinates skyCoordinates = this.getModel().getVisualModelHelper().getCenterMapperModel().getTargetCenter();
        Point2D.Double double_ = new Point2D.Double();
        double_.setLocation(skyCoordinates.getAbsoluteSkyPointInJ2000Deg());
        try {
            this.imageDisplay.getCoordinateConverter().worldToImageCoords(double_, false);
        }
        catch (Exception exception) {
            return false;
        }
        PlanarImage planarImage = this.imageDisplay.getDisplayImage();
        float f = this.imageDisplay.getScale();
        return (double)((float)planarImage.getWidth() / f) >= double_.getX() && (double)((float)planarImage.getHeight() / f) >= double_.getY();
    }

    public void setImageCenterToSourceCoordinates() {
        double d = (double)this.getImageDisplay().getImageWidth() / 2.0;
        double d2 = (double)this.getImageDisplay().getImageHeight() / 2.0;
        Point2D.Double double_ = new Point2D.Double(d, d2);
        SkyCoordinates skyCoordinates = this.getModel().getVisualModelHelper().getCenterMapperModel().setSourceCoordinates(double_, 3);
        this.getModel().getVisualModelHelper().getCenterMapperModel().createTargetCenter(skyCoordinates);
        this.getModel().getVisualModelHelper().getCenterMapperModel().publish();
    }

    public void removeAllGraphics() {
        this.almaCanvasDraw.clear();
    }

    public AlmaNavigatorImageDisplayControl getImageDisplayControl() {
        return this.imageDisplayControl;
    }

    public void clearGraphics() {
        this.removeAllGraphics();
        this.mapperManager.getCenterMapper().initialize();
        this.mapperManager.getPointingMapper().initialize();
        this.mapperManager.getRoiMapper().initialize();
        this.mapperManager.getSDRoiMapper().initialize();
    }

    public void reloadPatterns() {
        VisualModelHelper visualModelHelper = this.getModel().getVisualModelHelper();
        if (this.imageDisplay.isWcsSet()) {
            MainImageDisplay.CoordSystemType coordSystemType = this.imageDisplay.getCoordSystem();
            visualModelHelper.getCenterMapperModel().setImageCoordinateSystem(coordSystemType);
            visualModelHelper.getPointingMapperModel().setImageCoordinateSystem(coordSystemType);
            visualModelHelper.getSDRoiMapperModel().setImageCoordinateSystem(coordSystemType);
            visualModelHelper.getRoiMapperModel().setImageCoordinateSystem(coordSystemType);
            Angle angle = Angle.createAngle((double)this.imageDisplay.getImageRotation(), (String)Angle.UNIT_DEG);
            visualModelHelper.getCenterMapperModel().setImageRotation(angle);
            visualModelHelper.getPointingMapperModel().setImageRotation(angle);
            visualModelHelper.getSDRoiMapperModel().setImageRotation(angle);
            visualModelHelper.getRoiMapperModel().setImageRotation(angle);
            boolean bl = this.imageDisplay.getImageFlipped();
            visualModelHelper.getCenterMapperModel().setImageFlipped(bl);
            visualModelHelper.getPointingMapperModel().setImageFlipped(bl);
            visualModelHelper.getSDRoiMapperModel().setImageFlipped(bl);
            visualModelHelper.getRoiMapperModel().setImageFlipped(bl);
        }
        visualModelHelper.getCenterMapperModel().publish();
        visualModelHelper.getPointingMapperModel().importPattern();
        visualModelHelper.getPointingMapperModel().publish();
        visualModelHelper.getSDRoiMapperModel().publish();
        visualModelHelper.getRoiMapperModel().publish();
    }

    public void erase() {
        this.clearGraphics();
        this.getImageDisplay().eraseImage();
    }

    public void setImageFile(String string) {
        if (this.getImageDisplay().loadImageFile(string) != null) {
            this.clearGraphics();
            this.reloadPatterns();
        }
    }

    public void defaultCenter() {
        if (this.isSourceCoordinatesSet()) {
            if (!this.imageContains()) {
                // empty if block
            }
        } else {
            this.setImageCenterToSourceCoordinates();
        }
    }

    public void finishImageSet() {
        this.clearGraphics();
        this.reloadPatterns();
    }

    public AlmaNavigatorImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    public AlmaCanvasDraw getAlmaCanvasDraw() {
        return this.almaCanvasDraw;
    }

    public void setFigureSelectionEventEnabled(boolean bl) {
        this.figureSelectionEventEnabled = bl;
    }

    public boolean isFigureSelectionEventEnabled() {
        return this.figureSelectionEventEnabled;
    }

    public BaseSpatialVisualModel getModel() {
        return this.model;
    }

    public MapperManager getMapperManager() {
        return this.mapperManager;
    }
}

