/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.verifiers;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import javax.swing.JTextField;

public class IntegerVerifier
extends Verifier {
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;

    public IntegerVerifier(Editor editor, JTextField jTextField) {
        super(editor, jTextField);
    }

    public IntegerVerifier(Editor editor, JTextField jTextField, int n, int n2) {
        this(editor, jTextField);
        IntegerVerifier.checkMinMax(n, n2);
        this.min = n;
        this.max = n2;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        int n = IntegerVerifier.parseInt(jTextField.getText(), this.min, this.max);
        return n;
    }

    public static int parseInt(Object object) throws NumberFormatException {
        int n = 0;
        try {
            n = IntegerVerifier.parseInt(object, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        catch (OutOfRangeException outOfRangeException) {
            outOfRangeException.printStackTrace();
        }
        return n;
    }

    public static int parseInt(Object object, int n, int n2) throws OutOfRangeException, NumberFormatException {
        int n3;
        IntegerVerifier.checkMinMax(n, n2);
        String string = "must be between " + n + " and " + n2;
        if (object.getClass() == Integer.class) {
            Integer n4 = (Integer)object;
            n3 = n4;
        } else {
            String string2 = object.toString().trim();
            n3 = IntegerVerifier.parseInt(string2, n, n2);
        }
        if (n3 < n || n3 > n2) {
            throw new OutOfRangeException(string);
        }
        return n3;
    }

    public static int parseInt(String string, int n, int n2) throws OutOfRangeException, NumberFormatException {
        int n3;
        IntegerVerifier.checkMinMax(n, n2);
        String string2 = "must be between " + n + " and " + n2;
        int n4 = string.indexOf(45);
        int n5 = string.indexOf(43);
        if (n4 != -1) {
            string = string.substring(0, n4).trim();
        } else if (n5 != -1) {
            string = string.substring(0, n5).trim();
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("must be an integer");
        }
        if (n3 < n || n3 > n2) {
            throw new OutOfRangeException(string2);
        }
        return n3;
    }
}

