/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.ResourceCollection;
import alma.obsprep.bo.SubSBCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.actions.AddPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.ObjectFilter;
import java.util.List;
import javax.swing.tree.TreePath;

public class Add
extends OTAction
implements AddInteractor,
EventReceiver {
    private final AddInteractor.ObjectType objType;
    private final ProjectTree projectTree;
    private BusinessObject selectedBo = null;
    private ProjectTreeNode selectedNode = null;
    private final ObjectFilter<ProjectTreeNode> leavesOnly = projectTreeNode -> projectTreeNode.getChildCount() == 0;

    public Add(ProjectTree projectTree, AddInteractor.ObjectType objectType) {
        this.projectTree = projectTree;
        this.objType = objectType;
        AddPerformer addPerformer = new AddPerformer(this);
        this.setPerformer(addPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    public Add(ProjectTree projectTree, AddInteractor.ObjectType objectType, boolean bl) {
        this(projectTree, objectType);
        this.setUIComponentsHiddenWhenActionOutOfContext(bl);
    }

    @Override
    public void receiveEvent(Event event) {
        boolean bl;
        this.selectedNode = (ProjectTreeNode)event.getSource();
        this.selectedBo = (BusinessObject)this.selectedNode.getUserObject();
        if (this.projectTree.getTop() != this.selectedNode.getRoot()) {
            bl = false;
            if (this.isUIComponentsHiddenWhenActionOutOfContext) {
                this.setVisible(false);
            }
        } else if (this.projectTree.isDndReadonly()) {
            bl = false;
        } else {
            bl = this.isEnableFor(this.projectTree.isPhase2Tree(), this.objType, this.selectedBo);
            if (this.isUIComponentsHiddenWhenActionOutOfContext) {
                this.setVisible(true);
            }
        }
        this.setEnabled(bl);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedBo;
    }

    @Override
    public AddInteractor.ObjectType whatType() {
        return this.objType;
    }

    @Override
    public void updateDisplay(BusinessObject businessObject, BusinessObject businessObject2, int n) {
        if (businessObject2 != null) {
            ProjectTreeNode projectTreeNode = this.projectTree.findNodeRepresentingBo(businessObject2);
            if (projectTreeNode != null) {
                this.projectTree.makeVisible(new TreePath(projectTreeNode.getPath()));
            }
            if (businessObject2 instanceof ScienceGoal) {
                List<ProjectTreeNode> list = this.projectTree.findNodesBelow(projectTreeNode, this.leavesOnly);
                for (ProjectTreeNode projectTreeNode2 : list) {
                    if (projectTreeNode2 == null) continue;
                    this.projectTree.makeVisible(new TreePath(projectTreeNode2.getPath()));
                }
            }
        }
    }

    private boolean isEnableFor(boolean bl, AddInteractor.ObjectType objectType, BusinessObject businessObject) {
        boolean bl2 = false;
        boolean bl3 = RoleDirectoryServiceHelper.isUserP2G();
        switch (objectType) {
            case OBSUNITSET: {
                if (!bl) break;
                if (businessObject.getClass().equals(ObsUnitSet.class)) {
                    ObsUnitSet obsUnitSet = (ObsUnitSet)businessObject;
                    bl2 = obsUnitSet.getSchedBlockCount() == 0;
                    bl2 &= bl3;
                }
                if (!businessObject.getClass().equals(ObsProgram.class) && !businessObject.getClass().equals(OusCollection.class)) break;
                bl2 = !this.isProtected();
                bl2 &= bl3;
                break;
            }
            case SCHEDBLOCK: {
                if (!bl || !businessObject.getClass().equals(ObsUnitSet.class)) break;
                ObsUnitSet obsUnitSet = (ObsUnitSet)businessObject;
                bl2 = obsUnitSet.getObsUnitSetCount() == 0;
                bl2 &= bl3;
                break;
            }
            case OBSERVINGGROUP: {
                if (!bl || !(businessObject instanceof SchedBlock)) break;
                bl2 = true;
                bl2 &= bl3;
                break;
            }
            case TARGET: {
                if (!bl) break;
                if (businessObject instanceof SchedBlock) {
                    bl2 = true;
                } else if (businessObject instanceof TargetCollection) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case FIELDSOURCE: {
                if (!bl) break;
                if (businessObject instanceof SchedBlock) {
                    bl2 = true;
                } else if (businessObject instanceof FieldSourceCollection) {
                    bl2 = true;
                } else if (businessObject instanceof ResourceCollection) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case BLSPECTRALSPEC: {
                if (!bl) break;
                SchedBlock schedBlock = null;
                if (businessObject instanceof SchedBlock) {
                    schedBlock = (SchedBlock)businessObject;
                } else if (businessObject instanceof InstrumentSpecCollection || businessObject instanceof ResourceCollection) {
                    schedBlock = ((SubSBCollection)businessObject).getSchedBlock();
                }
                if (schedBlock != null && !schedBlock.hasACASpectralSpec()) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case ACASPECTRALSPEC: {
                if (!bl) break;
                SchedBlock schedBlock = null;
                if (businessObject instanceof SchedBlock) {
                    schedBlock = (SchedBlock)businessObject;
                } else if (businessObject instanceof InstrumentSpecCollection || businessObject instanceof ResourceCollection) {
                    schedBlock = ((SubSBCollection)businessObject).getSchedBlock();
                }
                if (schedBlock != null && !schedBlock.hasBLSpectralSpec()) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case SQUARELAWSPECTRALSPEC: {
                if (!bl) break;
                SchedBlock schedBlock = null;
                if (businessObject instanceof SchedBlock) {
                    schedBlock = (SchedBlock)businessObject;
                } else if (businessObject instanceof InstrumentSpecCollection || businessObject instanceof ResourceCollection) {
                    schedBlock = ((SubSBCollection)businessObject).getSchedBlock();
                }
                if (schedBlock != null) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case OPTICALCAMERASPEC: {
                if (!bl) break;
                if (businessObject instanceof SchedBlock) {
                    bl2 = true;
                } else if (businessObject instanceof InstrumentSpecCollection) {
                    bl2 = true;
                } else if (businessObject instanceof ResourceCollection) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case SCIENCEPARAMETERS: 
            case PHASECALPARAMETERS: 
            case POINTINGCALPARAMETERS: 
            case AMPLITUDECALPARAMETERS: 
            case POLARIZATIONCALPARAMETERS: 
            case FOCUSCALPARAMETERS: 
            case ATMOSPHERICCALPARAMETERS: 
            case DELAYCALPARAMETERS: 
            case CHECKSOURCECALPARAMETERS: 
            case DGCREFERENCECALPARAMETERS: 
            case DGCSCIENCECALPARAMETERS: 
            case SIDEBANDRATIOCALPARAMETERS: 
            case BANDPASSCALPARAMETERS: 
            case OPTICALPOINTINGPARAMETERS: 
            case RADIOMETRICPOINTINGPARAMETERS: 
            case HOLOGRAPHYPARAMETERS: {
                if (!bl) break;
                if (businessObject instanceof SchedBlock) {
                    bl2 = true;
                } else if (businessObject instanceof ObservingParametersCollection) {
                    bl2 = true;
                } else if (businessObject instanceof ResourceCollection) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case OPTICALPOINTINGWIZARD: 
            case CALIBRATORSURVEYWIZARD: 
            case RADIOMETRICPOINTINGWIZARD: 
            case BASELINECALIBRATIONWIZARD: 
            case SCIENCEGOAL: {
                if (!bl) break;
                try {
                    GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
                    bl2 = true;
                }
                catch (ClassCastException classCastException) {
                    bl2 = false;
                }
                bl2 &= bl3;
                break;
            }
            case HOLOGRAPHYSETUP: {
                if (!bl) break;
                if (businessObject instanceof ObsProgram) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case ASTROHOLOGRAPHYSETUP: {
                if (!bl) break;
                if (businessObject instanceof ObsProgram) {
                    bl2 = true;
                }
                bl2 &= bl3;
                break;
            }
            case PHASEISCIENCEGOAL: {
                if (bl) break;
                String string = null;
                if (businessObject instanceof PhaseISciencePlanCollection) {
                    string = ((PhaseISciencePlanCollection)businessObject).getObsProject().getStatus();
                    bl2 = true;
                } else if (businessObject instanceof ObsProject) {
                    string = ((ObsProject)businessObject).getStatus();
                    bl2 = true;
                } else if (businessObject instanceof ObsProposal) {
                    try {
                        string = ((ObsProposal)businessObject).getObsProject().getStatus();
                    }
                    catch (UnknownEntityException unknownEntityException) {
                        // empty catch block
                    }
                    bl2 = true;
                }
                bl2 &= ObsProjectData.STATUS_NEWPHASE1.equals(string) || ObsProjectData.STATUS_PHASE1SUBMITTED.equals(string);
            }
        }
        if (businessObject instanceof ObsUnitSetComponent) {
            bl2 &= !this.isProtected();
        }
        return bl2;
    }

    private boolean isProtected() {
        return this.projectTree.isOusCompProtected();
    }
}

