/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.ot.actions.DumpXMLInteractor;
import alma.obsprep.ot.actions.Performer;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import lombok.NonNull;
import net.boplicity.xmleditor.XmlTextPane;

public class DumpXMLPerformer
extends Performer {
    public DumpXMLPerformer(DumpXMLInteractor dumpXMLInteractor) {
        super(dumpXMLInteractor);
    }

    @Override
    public void perform() {
        Object object;
        DumpXMLInteractor dumpXMLInteractor = (DumpXMLInteractor)this.getGui();
        BusinessObject businessObject = dumpXMLInteractor.getSelectedBO();
        if (businessObject == null) {
            return;
        }
        if (businessObject instanceof WorkbookPage) {
            object = (WorkbookPage)businessObject;
            businessObject = ((WorkbookPage)object).getParent();
        }
        object = businessObject.toXml();
        if (dumpXMLInteractor.getXMLDestination().equals((Object)DumpXMLInteractor.XMLDestination.Clipboard)) {
            this.dumpXMLToClipboard((String)object);
        } else {
            this.dumpXMLToWindow((String)object);
        }
    }

    private void dumpXMLToWindow(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        JFrame jFrame = new JFrame();
        XmlTextPane xmlTextPane = new XmlTextPane();
        xmlTextPane.setEditable(false);
        xmlTextPane.setFont(new Font("Monospaced", 1, 15));
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(new JScrollPane(xmlTextPane));
        jFrame.setTitle("XML Dump of BO object");
        xmlTextPane.setText(string);
        jFrame.setSize(1000, 800);
        jFrame.setVisible(true);
    }

    private void dumpXMLToClipboard(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }
}

