/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class EphemerisCleaner {
    public static void removeRedundantEphemeris(@NonNull ObsProject obsProject) {
        ObsProgram obsProgram;
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>(100);
        ObsProposal obsProposal = null;
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(EphemerisCleaner.class).warning("Unable to get science goals from the obsProposal " + unknownEntityException.getMessage());
        }
        if (obsProposal != null) {
            arrayList.addAll(Arrays.asList(obsProposal.getAbstractScienceGoalScienceGoal()));
        }
        if ((obsProgram = obsProject.getObsProgram()) != null) {
            arrayList.addAll(Arrays.asList(obsProgram.getAbstractScienceGoalScienceGoal()));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (ScienceGoal scienceGoal : arrayList) {
            Stream.of(scienceGoal.getTargetParameters()).filter(targetParameters -> !targetParameters.isEphemerisSource() && !StringUtils.isEmpty((CharSequence)targetParameters.getSourceEphemeris())).forEach(targetParameters -> targetParameters.setSourceEphemeris(null));
        }
    }
}

