/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.boEditors;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.valuetypes.ObservingFrequencyModel;
import alma.valuetypes.Frequency;
import javax.swing.JTextField;

public class SingleContinuumFrequencyVerifier
extends ValueUnitPairVerifier {
    protected Integer receiverBandNumber = null;

    public SingleContinuumFrequencyVerifier(ValueUnitPairEditor valueUnitPairEditor, ObservingFrequencyModel observingFrequencyModel) {
        super(valueUnitPairEditor, (double)Double.MIN_VALUE, 2000.0);
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID.equals(ObservingFrequencyModel.BAND_SELECTED_FID) && object instanceof String) {
                    try {
                        SingleContinuumFrequencyVerifier.this.receiverBandNumber = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
            }
        };
        observingFrequencyModel.subscribe(modelChangeSubscriber);
    }

    public Object _validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        Double d = (Double)super.validate(jTextField);
        ValueUnitPair valueUnitPair = (ValueUnitPair)this.vuped.getModel().getDocument();
        double d2 = Frequency.createFrequency((double)d, (String)valueUnitPair.getUnit()).getContentInGHz();
        if (this.receiverBandNumber == null) {
            throw new OutOfRangeException("Unable to establish which receiver band has been selected");
        }
        if (d2 != 0.0) {
            try {
                String string = ReceiverBand.getReceiverBandName(d2);
                String string2 = ReceiverBand.getReceiverBand(this.receiverBandNumber).getName();
                if (string2.compareTo(string) != 0) {
                    throw new OutOfRangeException("Frequency specified should be in the range of receiver " + string2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                stringBuilder.append(illegalArgumentException.getMessage().replaceAll("\n", "<br>"));
                stringBuilder.append("</html>");
                throw new OutOfRangeException(stringBuilder.toString());
            }
        }
        return d;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        try {
            return this._validate(jTextField);
        }
        catch (OutOfRangeException outOfRangeException) {
            throw new OutOfRangeException("Must be a positive number.");
        }
    }
}

