/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.util.Log;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public class ComboBoxWithTextStyle
extends JComboBox {
    private TextStyle[] styles = null;
    private String[] plains = null;

    public ComboBoxWithTextStyle(String[] stringArray) {
        this(stringArray, null);
    }

    public ComboBoxWithTextStyle(String[] stringArray, TextStyle[] textStyleArray) {
        this.setItems(stringArray, textStyleArray);
    }

    public void setItems(String[] stringArray, TextStyle[] textStyleArray) {
        this.plains = stringArray;
        this.styles = textStyleArray;
        if (textStyleArray != null && stringArray.length != textStyleArray.length) {
            String string = "styles are ignored because of different array sizes : items = " + stringArray.length + ", styles = " + textStyleArray.length;
            Log.logger((Object)this).warning(string);
            this.styles = null;
        }
        this.updateItems();
    }

    public void setStyles(TextStyle[] textStyleArray) {
        if (this.getItemCount() != textStyleArray.length) {
            String string = "styles are ignored because of different array sizes : items = " + this.getItemCount() + ", styles = " + textStyleArray.length;
            Log.logger((Object)this).warning(string);
            this.styles = null;
        } else {
            this.styles = textStyleArray;
        }
        this.updateItems();
    }

    public void setSelected(String string) {
        for (int i = 0; i < this.plains.length; ++i) {
            if (!this.plains[i].equals(string)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    private void updateItems() {
        ActionListener[] actionListenerArray;
        int n = this.getSelectedIndex();
        for (ActionListener actionListener : actionListenerArray = this.getActionListeners()) {
            this.removeActionListener(actionListener);
        }
        this.removeAllItems();
        for (int i = 0; i < this.plains.length; ++i) {
            TextStyle textStyle = this.styles == null ? TextStyle.PLAIN : this.styles[i];
            this.addItem(textStyle.getHtmlString(this.plains[i].toString()));
        }
        if (n != -1) {
            this.setSelectedIndex(n);
        }
        for (ActionListener actionListener : actionListenerArray) {
            this.addActionListener(actionListener);
        }
    }

    static enum TextStyle {
        PLAIN,
        GRAY,
        GRAY_ITALIC,
        GRAY_ITALIC_STROKE;


        public String getHtmlString(String string) {
            return "<html>" + (String)(switch (this) {
                case PLAIN -> string;
                case GRAY -> "<font color=gray>" + string + "</font>";
                case GRAY_ITALIC -> "<font color=gray><i>" + string + "</i></font>";
                case GRAY_ITALIC_STROKE -> "<font color=gray><i><s>" + string + "</s></i></font>";
                default -> string;
            }) + "</html>";
        }
    }
}

