/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.CalendarButton;
import alma.obsprep.ot.editors.obsproject.FinaliseEditingInterface;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.gui.toplevel.InitServices;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

public class CompactIsoDatePicker
extends JPanel {
    private static final long serialVersionUID = 8657646270715252064L;
    private static final String isoDateTimeFieldToolTip = "<html><p>Times are to the nearest minute.</p><p>Click on the displayed date to change it.</p><p>Hours and Minutes can be entered either where they are displayed or by using the up and down arrows</p></html>";
    private static final String calendarButtonToolTip = "Click on date to select using calendar";
    private static final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private ZonedDateTime calendar;
    private Editor editor;
    private FieldID fid;
    private JTextField isoDateTimeField;
    private CalendarButton calendarButton;
    private JSpinner dateSpinner;
    private JSpinner hourSpinner;
    private JSpinner minuteSpinner;
    private FinaliseEditingInterface parentEditor = null;
    private boolean isCloseButtonNeeded = false;

    public static ZonedDateTime convertStringToDateTime(String string) throws DateTimeParseException {
        return LocalDateTime.parse(string, dateTimeFormat).atZone(ZoneOffset.UTC);
    }

    private static ZonedDateTime convertStringToDate(String string) throws DateTimeParseException {
        LocalDate localDate = LocalDate.parse(string, dateFormat);
        LocalTime localTime = LocalTime.of(0, 0);
        return ZonedDateTime.of(localDate, localTime, ZoneOffset.UTC);
    }

    private static String convertDateTimeToString(ZonedDateTime zonedDateTime) throws DateTimeException {
        return zonedDateTime.format(dateTimeFormat);
    }

    public CompactIsoDatePicker(Editor editor, FieldID fieldID, ZonedDateTime zonedDateTime) {
        this.setupDatePicker(editor, fieldID, zonedDateTime);
    }

    public CompactIsoDatePicker(Editor editor, FieldID fieldID, String string, boolean bl) {
        ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(string);
        this.isCloseButtonNeeded = bl;
        this.setupDatePicker(editor, fieldID, zonedDateTime);
    }

    private void setupDatePicker(Editor editor, FieldID fieldID, ZonedDateTime zonedDateTime) {
        this.editor = editor;
        this.fid = fieldID;
        this.calendar = zonedDateTime;
        this.initComponents(zonedDateTime);
    }

    public JTextField getIsoDateTimeField() {
        return this.isoDateTimeField;
    }

    private void highlightTextInField(JTextField jTextField, int n, int n2) {
        Runnable runnable = () -> {
            jTextField.setCaretPosition(n);
            jTextField.moveCaretPosition(n2);
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void highlightCorrectSubfield(JTextField jTextField) {
        boolean bl;
        int n = jTextField.getCaretPosition();
        boolean bl2 = n < 6;
        boolean bl3 = bl = 5 < n && n < 9;
        if (bl2) {
            this.highlightTextInField(jTextField, 0, 4);
        } else if (bl) {
            this.highlightTextInField(jTextField, 5, 7);
        } else {
            this.highlightTextInField(jTextField, 8, 10);
        }
    }

    void initComponents(ZonedDateTime zonedDateTime) {
        String string = CompactIsoDatePicker.convertDateTimeToString(zonedDateTime);
        this.isoDateTimeField = new JTextField(string);
        this.isoDateTimeField.setVisible(false);
        this.calendarButton = new CalendarButton();
        this.calendarButton.addPropertyChangeListener(propertyChangeEvent -> {
            if (propertyChangeEvent.getNewValue() instanceof ZonedDateTime) {
                int n = (Integer)this.hourSpinner.getValue();
                int n2 = (Integer)this.minuteSpinner.getValue();
                ZonedDateTime zonedDateTime = this.calendarButton.getTargetDate();
                ZonedDateTime zonedDateTime2 = ((ZonedDateTime)propertyChangeEvent.getNewValue()).withHour(n).withMinute(n2);
                if (zonedDateTime == null) {
                    this.setDateTime(zonedDateTime2, true);
                } else if (!zonedDateTime.equals(zonedDateTime2)) {
                    this.setDateTime(zonedDateTime2, true);
                }
            }
        });
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setValue(Date.from(zonedDateTime.toInstant()));
        spinnerDateModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CompactIsoDatePicker.this.calendar = CompactIsoDatePicker.this.getZonedVersionOfDateFromSpinnerInfo();
                Log.logger((Object)this).finest("State change triggered: calendar is now " + String.valueOf(CompactIsoDatePicker.this.calendar));
                CompactIsoDatePicker.this.setDateTime(CompactIsoDatePicker.this.calendar, true);
            }
        });
        this.dateSpinner = new JSpinner(spinnerDateModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.dateSpinner, "yyyy-MM-dd");
        dateEditor.getFormat().setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateSpinner.setEditor(dateEditor);
        this.dateSpinner.addChangeListener(changeEvent -> this.syncModelToDateSpinner());
        dateEditor.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                CompactIsoDatePicker.this.highlightCorrectSubfield(jTextField);
                super.focusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        dateEditor.getTextField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTextField jTextField = (JTextField)mouseEvent.getSource();
                CompactIsoDatePicker.this.highlightCorrectSubfield(jTextField);
                super.mouseClicked(mouseEvent);
            }
        });
        this.hourSpinner = new DigitSpinner(2, new SpinnerNumberModel(12, 0, 23, 1));
        this.hourSpinner.addChangeListener(changeEvent -> this.syncModelToHourSpinner());
        this.minuteSpinner = new DigitSpinner(2, new SpinnerNumberModel(0, 0, 59, 1));
        this.minuteSpinner.addChangeListener(changeEvent -> this.syncModelToMinutesSpinner());
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue());
        this.add(this.isoDateTimeField);
        this.add(this.dateSpinner);
        this.add(this.calendarButton);
        this.add(this.hourSpinner);
        this.add(new JLabel(":"));
        this.add(this.minuteSpinner);
        this.calendarButton.setToolTipText(calendarButtonToolTip);
        this.setToolTipText(isoDateTimeFieldToolTip);
        this.initDateTime(zonedDateTime);
        if (this.isCloseButtonNeeded) {
            this.add(Box.createHorizontalGlue());
            JButton jButton = new JButton("Close");
            jButton.setName("AcceptDateChanges");
            jButton.setToolTipText("Accept the date changes");
            jButton.addActionListener(actionEvent -> {
                if (this.parentEditor != null) {
                    this.parentEditor.finaliseEditing();
                }
            });
            this.add(jButton);
        }
    }

    private void updateIsoDateTimeInModel() {
        if (this.editor != null && this.fid != null && this.isoDateTimeField.getText() != null) {
            this.editor.updateField(this.fid);
        }
    }

    private void setDateTime(ZonedDateTime zonedDateTime, boolean bl) {
        String string = "";
        if (zonedDateTime != null) {
            string = dateTimeFormat.format(zonedDateTime);
            Log.logger((Object)this).info("setting new datetime: dateTime=" + String.valueOf(zonedDateTime) + " ,  dateTimeString =" + string);
            if (this.calendar != zonedDateTime) {
                Date date = Date.from(zonedDateTime.toInstant());
                ((SpinnerDateModel)this.dateSpinner.getModel()).setValue(date);
                this.calendar = zonedDateTime;
            }
            this.calendarButton.setTargetDate(zonedDateTime);
        }
        if (!string.equals(this.isoDateTimeField.getText())) {
            this.isoDateTimeField.setText(string);
            this.updateIsoDateTimeInModel();
        }
        if (bl) {
            this.setTimeSpinners(zonedDateTime);
        }
    }

    public void initDateTime(String string) {
        try {
            ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(string);
            this.initDateTime(zonedDateTime);
            this.makeYearFocus();
        }
        catch (DateTimeParseException dateTimeParseException) {
            Log.logger((Object)this).finest("The date passed in ," + string + " could not be parsed :" + dateTimeParseException.getMessage());
        }
    }

    public void makeYearFocus() {
        Log.logger((Object)this).finest("Setting the focus ...");
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.dateSpinner.getEditor();
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        jFormattedTextField.requestFocusInWindow();
    }

    private void initDateTime(ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            this.hourSpinner.setValue(zonedDateTime.getHour());
            this.minuteSpinner.setValue(zonedDateTime.getMinute());
            Date date = Date.from(zonedDateTime.toInstant());
            ((SpinnerDateModel)this.dateSpinner.getModel()).setValue(date);
            this.calendarButton.setTargetDate(zonedDateTime);
            if (this.calendar != zonedDateTime) {
                this.calendar = zonedDateTime;
            }
            this.calendarButton.setTargetDate(zonedDateTime);
        }
    }

    public void setValid(Boolean bl) {
        Color color = bl != false ? Color.BLACK : Colors.OT_RED;
        for (Component component : this.getComponents()) {
            component.setForeground(color);
        }
    }

    private void setTimeSpinners(ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            this.calendar = zonedDateTime;
            this.hourSpinner.setValue(zonedDateTime.getHour());
            this.minuteSpinner.setValue(zonedDateTime.getMinute());
        }
    }

    public void commitChanges() {
        this.commitOutstandingChangesInEditor();
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.dateSpinner.getEditor();
        String string = dateEditor.getTextField().getText();
        try {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                int n;
                Log.logger((Object)this).finest("Date changes committed" + string);
                ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDate(string);
                int n2 = (Integer)this.hourSpinner.getValue();
                boolean bl = false;
                if (n2 != zonedDateTime.getHour()) {
                    zonedDateTime = zonedDateTime.withHour(n2);
                    bl = true;
                }
                if ((n = ((Integer)this.minuteSpinner.getValue()).intValue()) != zonedDateTime.getMinute()) {
                    zonedDateTime = zonedDateTime.withMinute(n);
                    bl = true;
                }
                if (bl) {
                    this.setDateTime(zonedDateTime, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void commitOutstandingChangesInEditor() {
        try {
            this.hourSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            Log.logger((Object)this).finest("Problem commiting hour changes :" + parseException.toString());
        }
        try {
            this.minuteSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            Log.logger((Object)this).finest("Problem commiting minute changes : " + parseException.toString());
        }
        try {
            this.dateSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            Log.logger((Object)this).finest("Problem commiting date changes : " + parseException.toString());
        }
    }

    private void syncModelToMinutesSpinner() {
        String string = this.isoDateTimeField.getText();
        try {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(string);
                int n = (Integer)this.minuteSpinner.getValue();
                if (n != zonedDateTime.getMinute()) {
                    this.calendar = zonedDateTime = zonedDateTime.withMinute(n);
                    this.setDateTime(zonedDateTime, true);
                }
            }
        }
        catch (Exception exception) {
            Log.logger((Object)this).warning(exception.getMessage());
        }
    }

    private void syncModelToHourSpinner() {
        String string = this.isoDateTimeField.getText();
        try {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(string);
                int n = (Integer)this.hourSpinner.getValue();
                if (n != this.calendar.getHour()) {
                    this.calendar = zonedDateTime = zonedDateTime.withHour(n);
                    this.setDateTime(zonedDateTime, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncModelToDateSpinner() {
        boolean bl;
        ZonedDateTime zonedDateTime = this.getZonedVersionOfDateFromSpinnerInfo();
        boolean bl2 = bl = !this.calendar.isEqual(zonedDateTime);
        if (bl) {
            this.calendar = zonedDateTime;
            this.setDateTime(this.calendar, true);
        }
    }

    private ZonedDateTime getZonedVersionOfDateFromSpinnerInfo() {
        SpinnerModel spinnerModel = this.dateSpinner.getModel();
        int n = (Integer)this.hourSpinner.getValue();
        int n2 = (Integer)this.minuteSpinner.getValue();
        if (spinnerModel instanceof SpinnerDateModel) {
            ZonedDateTime zonedDateTime = ((SpinnerDateModel)spinnerModel).getDate().toInstant().atZone(ZoneId.of("UTC"));
            LocalDate localDate = zonedDateTime.toLocalDate();
            LocalTime localTime = LocalTime.of(n, n2);
            ZonedDateTime zonedDateTime2 = ZonedDateTime.of(localDate, localTime, ZoneOffset.UTC);
            return zonedDateTime2;
        }
        return null;
    }

    public void setEditingCompletionListener(FinaliseEditingInterface finaliseEditingInterface) {
        this.parentEditor = finaliseEditingInterface;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Date Picker");
        jFrame.setDefaultCloseOperation(3);
        CompactIsoDatePicker compactIsoDatePicker = new CompactIsoDatePicker(null, null, "2019-04-20T23:12:13.000Z", false);
        compactIsoDatePicker.initDateTime("2019-04-20T23:12:13.000Z");
        jFrame.getContentPane().add((Component)compactIsoDatePicker, "Center");
        jFrame.setLocationRelativeTo(null);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class DigitSpinner
    extends JSpinner {
        private static final long serialVersionUID = -8025725876597017596L;

        DigitSpinner(int n, SpinnerModel spinnerModel) {
            super(spinnerModel);
            JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
            JFormattedTextField jFormattedTextField = numberEditor.getTextField();
            jFormattedTextField.setColumns(n);
            jFormattedTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    JTextField jTextField = (JTextField)focusEvent.getSource();
                    int n = jTextField.getText().length();
                    CompactIsoDatePicker.this.highlightTextInField(jTextField, 0, n);
                    super.focusGained(focusEvent);
                }
            });
            jFormattedTextField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    JTextField jTextField = (JTextField)mouseEvent.getSource();
                    CompactIsoDatePicker.this.highlightTextInField(jTextField, 0, jTextField.getColumns());
                    super.mouseClicked(mouseEvent);
                }
            });
        }
    }
}

