/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.gui.toplevel.Dialog;
import alma.obsprep.ot.gui.toplevel.InitServices;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;

public class NewCalibratorDialog
extends Dialog {
    private JRadioButton amplitude;
    private JRadioButton atmospheric;
    private JRadioButton bandpass;
    private JRadioButton checkSource;
    private ButtonGroup buttonGroup;
    private JButton createCalibrationButton;
    private JButton cancelButton;
    private JRadioButton delay;
    private JLabel dialogHelp;
    private JRadioButton focus;
    private JPanel panel;
    private JPanel standardButtonPanel;
    private JRadioButton phase;
    private JRadioButton pointing;
    private JRadioButton polarization;
    private final Map<String, JRadioButton> radioButtons = new LinkedHashMap<String, JRadioButton>();
    private String calibrationSelected;
    private boolean isAddingCalibrationsToScienceGoal = false;

    public NewCalibratorDialog(Frame frame, @NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("goalType is marked non-null but is null");
        }
        if (object instanceof ScienceGoal) {
            this.isAddingCalibrationsToScienceGoal = true;
        }
        this.setModal(true);
        this.setTitle("Add Calibration");
        this.initComponents();
        this.radioButtons.put(QuerySource.INTENDEDUSE_AMPLITUDE, this.amplitude);
        this.radioButtons.put(QuerySource.INTENDEDUSE_BANDPASS, this.bandpass);
        this.radioButtons.put(QuerySource.INTENDEDUSE_PHASE, this.phase);
        this.radioButtons.put(QuerySource.INTENDEDUSE_POLARIZATION, this.polarization);
        this.radioButtons.put(QuerySource.INTENDEDUSE_CHECKSOURCE, this.checkSource);
        if (!this.isAddingCalibrationsToScienceGoal) {
            this.radioButtons.put(QuerySource.INTENDEDUSE_ATMOSPHERIC, this.atmospheric);
            this.radioButtons.put(QuerySource.INTENDEDUSE_POINTING, this.pointing);
            this.radioButtons.put(QuerySource.INTENDEDUSE_FOCUS, this.focus);
            this.radioButtons.put(QuerySource.INTENDEDUSE_DELAY, this.delay);
        }
        this.amplitude.setSelected(true);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.centreOnMonitor();
        }
        super.setVisible(bl);
    }

    public void setUnselectable(@NonNull Collection<String> collection) {
        if (collection == null) {
            throw new NullPointerException("unselectable is marked non-null but is null");
        }
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>(this.radioButtons.values());
        for (String string : collection) {
            JRadioButton jRadioButton = this.radioButtons.get(string);
            arrayList.remove(jRadioButton);
            jRadioButton.setEnabled(false);
        }
        if (arrayList.size() > 0) {
            JRadioButton jRadioButton = (JRadioButton)arrayList.get(0);
            jRadioButton.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.panel = new JPanel();
        this.panel.setName("NewCalibratorDialog");
        this.standardButtonPanel = new JPanel();
        this.standardButtonPanel.setName("NewCalibratorDialog.standardButtonPanel");
        this.dialogHelp = new JLabel();
        this.dialogHelp.setName("NewCalibratorDialog.SelectCalibrationLabel");
        this.amplitude = new JRadioButton();
        this.amplitude.setName("NewCalibratorDialog.RadioAmplitudeButton");
        this.atmospheric = new JRadioButton();
        this.atmospheric.setName("NewCalibratorDialog.RadioAtmosphericButton");
        this.focus = new JRadioButton();
        this.focus.setName("NewCalibratorDialog.RadioFocusButton");
        this.pointing = new JRadioButton();
        this.pointing.setName("NewCalibratorDialog.RadioPointingButton");
        this.delay = new JRadioButton();
        this.delay.setName("NewCalibratorDialog.RadioDelayButton");
        this.bandpass = new JRadioButton();
        this.bandpass.setName("NewCalibratorDialog.RadioBandpassButton");
        this.checkSource = new JRadioButton();
        this.checkSource.setName("NewCalibratorDialog.RadioCheckSourceButton");
        this.phase = new JRadioButton();
        this.phase.setName("NewCalibratorDialog.RadioPhaseButton");
        this.polarization = new JRadioButton();
        this.polarization.setName("NewCalibratorDialog.RadioPolarizationButton");
        this.createCalibrationButton = new JButton();
        this.createCalibrationButton.setName("NewCalibratorDialog.CreateButton");
        this.cancelButton = new JButton();
        this.cancelButton.setName("NewCalibratorDialog.CancelButton");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewCalibratorDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panel.setLayout(new GridBagLayout());
        this.dialogHelp.setFont(this.dialogHelp.getFont().deriveFont(this.dialogHelp.getFont().getStyle() & 0xFFFFFFFE));
        this.dialogHelp.setText("<html><p>Select the calibration to create:</p></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.dialogHelp, gridBagConstraints);
        this.buttonGroup.add(this.amplitude);
        this.amplitude.setText(QuerySource.INTENDEDUSE_AMPLITUDE);
        this.panel.add((Component)this.amplitude, this.createGBC(1));
        if (!this.isAddingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.atmospheric);
            this.atmospheric.setText(QuerySource.INTENDEDUSE_ATMOSPHERIC);
            this.panel.add((Component)this.atmospheric, this.createGBC(2));
        }
        this.buttonGroup.add(this.bandpass);
        this.bandpass.setText(QuerySource.INTENDEDUSE_BANDPASS);
        this.panel.add((Component)this.bandpass, this.createGBC(3));
        if (!this.isAddingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.delay);
            this.delay.setText(QuerySource.INTENDEDUSE_DELAY);
            this.panel.add((Component)this.delay, this.createGBC(4));
        }
        if (!this.isAddingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.focus);
            this.focus.setText(QuerySource.INTENDEDUSE_FOCUS);
            this.panel.add((Component)this.focus, this.createGBC(5));
        }
        this.buttonGroup.add(this.phase);
        this.phase.setText(QuerySource.INTENDEDUSE_PHASE);
        this.panel.add((Component)this.phase, this.createGBC(6));
        if (!this.isAddingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.pointing);
            this.pointing.setText(QuerySource.INTENDEDUSE_POINTING);
            this.panel.add((Component)this.pointing, this.createGBC(7));
        }
        this.buttonGroup.add(this.polarization);
        this.polarization.setText(QuerySource.INTENDEDUSE_POLARIZATION);
        this.panel.add((Component)this.polarization, this.createGBC(8));
        this.buttonGroup.add(this.checkSource);
        this.checkSource.setText(QuerySource.INTENDEDUSE_CHECKSOURCE);
        this.panel.add((Component)this.checkSource, this.createGBC(9));
        this.createCalibrationButton.setText("Create");
        this.createCalibrationButton.addActionListener(actionEvent -> this.createActionPerformed(actionEvent));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(actionEvent -> {
            this.calibrationSelected = null;
            this.dispose();
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(18, 12, 12, 18);
        this.standardButtonPanel.add((Component)this.createCalibrationButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.standardButtonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(18, 12, 12, 0);
        this.panel.add((Component)this.standardButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panel, gridBagConstraints);
        this.pack();
    }

    public GridBagConstraints createGBC(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        return gridBagConstraints;
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.calibrationSelected = null;
    }

    private void createActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        for (JRadioButton jRadioButton : this.radioButtons.values()) {
            if (!jRadioButton.isSelected()) continue;
            this.calibrationSelected = jRadioButton.getText();
            break;
        }
        this.dispose();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
            }
            NewCalibratorDialog newCalibratorDialog = new NewCalibratorDialog((Frame)new JFrame(), ScienceGoal.createScienceGoal());
            newCalibratorDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(QuerySource.INTENDEDUSE_AMPLITUDE);
            arrayList.add(QuerySource.INTENDEDUSE_PHASE);
            newCalibratorDialog.setUnselectable(arrayList);
            newCalibratorDialog.setVisible(true);
        });
    }

    public String getCalibrationSelected() {
        return this.calibrationSelected;
    }
}

