/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameterEditor;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.RectanglePatternModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.SkyCoordinates;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RectanglePatternEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_SETUP_MOSAIC = new FieldID("RectPtnEdtr.setupMosaic");
    public static final FieldID FID_CONVERT = new FieldID("RectPtnEdtr.convert");
    public static final FieldID FID_CANCEL_MOSAIC = new FieldID("RectPtnEdtr.cancelMosaic");
    public static final FieldID FID_SCAN_DIRECTION = new FieldID("RectPtnEdtr.scanDirectionFID");
    public static final FieldID FID_UNIDIRECTIONAL_SCAN = new FieldID("RectPtnEdtr.uniDirectionalScanFID");
    public static final FieldID FID_SCAN_VELOCITY = new FieldID("RectPtnEdtr.scanVelocityFID");
    public static final FieldID FID_SCAN_COORD_SYSTEM = new FieldID("RectPtnEdtr.scanningCoordinateSystemFID");
    public static final FieldID FID_SCANS_PER_MAP = new FieldID("RectPtnEdtr.scanPerMapFID");
    public static final FieldID FID_SAMPLES_PER_BEAM_LONGITUDE = new FieldID("RectPtnEdtr.samplesPerBeamLongitudeFID");
    public static final FieldID FID_SAMPLES_PER_BEAM_LATITUDE = new FieldID("RectPtnEdtr.samplesPerBeamLatitudeFID");
    public static final String infoNotUniqSubscanDuration = "(can not determine the subscan duration)";
    public static final String infoNoSubscanDuration = "(subscan duration is not set)";
    private MosaicParameterEditor mosaicParameterEditor;
    private JPanel mosaicSetupButtonPanel;
    private JPanel mosaicParametersPanel;
    private JButton convertButton;
    public static final String CONVERT = "Convert";
    private CoordsEditor coordinatesEditor;

    public RectanglePatternEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.insets = new Insets(0, 2, 0, 2);
        RectanglePatternModel rectanglePatternModel = (RectanglePatternModel)this.getModel();
        this.coordinatesEditor = new CoordsEditor(true, rectanglePatternModel.getPatternCenterCoordsModel());
        this.registerSubView(this.coordinatesEditor);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Pattern Center Coords", (JComponent)this.coordinatesEditor);
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, rectanglePatternModel.getLatitudeLengthModel(), "Lat. length", "The latitude length");
        OTTextField oTTextField = this.addTextComponent(this, this.layout, this.constraints, FID_SAMPLES_PER_BEAM_LATITUDE, "Lat. samples per beam", "The number of samples per beam for the latitudinal axis");
        oTTextField.setEditable(false);
        oTTextField.setFocusable(false);
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, rectanglePatternModel.getOrthogonalStepModel(), "Orthogonal step", "The orthogonal step");
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, rectanglePatternModel.getLongitudeLengthModel(), "Long. length", "The longitude length");
        OTTextField oTTextField2 = this.addTextComponent(this, this.layout, this.constraints, FID_SAMPLES_PER_BEAM_LONGITUDE, "Long. samples per beam", "The number of samples per beam for the longitudinal axis");
        oTTextField2.setEditable(false);
        oTTextField2.setFocusable(false);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.addComboBox((JComponent)this, this.layout, this.constraints, FID_SCAN_DIRECTION, "Scan Direction", "The rectangle's scan direction", RectanglePattern.getKnownScanDirectionList());
        this.addVerticalSpace(this, this.layout, this.constraints);
        OTTextField oTTextField3 = this.addTextComponent(this, this.layout, this.constraints, FID_SCANS_PER_MAP, "Scans per map", "The number of scans per map.");
        oTTextField3.setEditable(false);
        oTTextField3.setFocusable(false);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.addBooleanComponent(this, this.layout, this.constraints, FID_UNIDIRECTIONAL_SCAN, "Unidirectional Scan", "Always scan in the same direction");
        this.addVerticalSpace(this, this.layout, this.constraints);
        OTTextField oTTextField4 = this.addTextComponent(this, this.layout, this.constraints, FID_SCAN_VELOCITY, "Scan Velocity", "The rectangle's scan velocity");
        oTTextField4.setEditable(false);
        oTTextField4.setFocusable(false);
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, rectanglePatternModel.getOrientationModel(), "Orientation", "The rectangle's orientation");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SkyCoordinates.SYSTEM_J2000, "FK5 J2000");
        String[] stringArray = SkyCoordinates.getKnownSystemList();
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.equals(SkyCoordinates.SYSTEM_J2000)) {
                stringArray[n] = "FK5 J2000";
                break;
            }
            ++n;
        }
        this.addComboBox(this, this.layout, this.constraints, FID_SCAN_COORD_SYSTEM, "Scanning Coordinate System", "Scanning Coordinate System", stringArray, hashMap);
        this.mosaicSetupButtonPanel = new JPanel();
        Object object = new JButton("Setup Mosaic (Optional)");
        this.initEvents((JButton)object, FID_SETUP_MOSAIC);
        ((JComponent)object).setToolTipText("Convert this map to a Pointed Mosaic");
        this.mosaicSetupButtonPanel.add((Component)object);
        this.addComponent(this.mosaicSetupButtonPanel);
        this.mosaicParametersPanel = new JPanel();
        this.mosaicParametersPanel.setLayout(new BoxLayout(this.mosaicParametersPanel, 3));
        this.mosaicParametersPanel.setBorder(BorderFactory.createTitledBorder("Mosaic Parameters"));
        this.mosaicParameterEditor = new MosaicParameterEditor(rectanglePatternModel.getMosaicParameterModel());
        this.mosaicParametersPanel.add(this.mosaicParameterEditor);
        JPanel jPanel = new JPanel();
        this.convertButton = new JButton("Convert to Pointed Mosaic");
        this.initEvents(this.convertButton, FID_CONVERT);
        this.convertButton.setActionCommand(CONVERT);
        this.convertButton.setToolTipText("Convert Rectangle Pattern to a Pointed Mosaic");
        jPanel.add(this.convertButton);
        object = new JButton("Cancel");
        this.initEvents((JButton)object, FID_CANCEL_MOSAIC);
        ((JComponent)object).setToolTipText("Cancel Setup Mosaic parameters");
        jPanel.add((Component)object);
        this.mosaicParametersPanel.add(jPanel);
        this.addComponent(this.mosaicParametersPanel);
        this.setMosaicParameterVisible(false);
    }

    @Override
    public void build() {
        super.build("RectanglePatternEditor");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_CONVERT)) {
            this.setMosaicParameterVisible(false);
            return;
        }
        if (fieldID.equals(FID_SETUP_MOSAIC)) {
            RectanglePatternModel rectanglePatternModel = (RectanglePatternModel)this.getModel();
            RectanglePattern rectanglePattern = rectanglePatternModel.getRectanglePattern();
            rectanglePattern.setDefaultMosaicParameters();
            rectanglePatternModel.getMosaicParameterModel().publish();
            this.setMosaicParameterVisible(true);
            return;
        }
        if (fieldID.equals(FID_CANCEL_MOSAIC)) {
            this.setMosaicParameterVisible(false);
            return;
        }
        if (fieldID.equals(FID_SCAN_VELOCITY)) {
            AngularVelocity angularVelocity = (AngularVelocity)((Object)object);
            String string = angularVelocity == null ? infoNotUniqSubscanDuration : (angularVelocity.getContent() == Double.POSITIVE_INFINITY || Double.isNaN(angularVelocity.getContent()) ? infoNoSubscanDuration : TextUtils.format(angularVelocity, 6, 3));
            super.update(fieldID, string);
            return;
        }
        super.update(fieldID, object);
    }

    private void setMosaicParameterVisible(boolean bl) {
        this.mosaicSetupButtonPanel.setVisible(!bl);
        this.mosaicParametersPanel.setVisible(bl);
    }

    public void setConvertButtonAction(ActionListener actionListener) {
        this.convertButton.addActionListener(actionListener);
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        return this.coordinatesEditor.getUserRestrictedEditableComponents();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
        RectanglePatternModel rectanglePatternModel = new RectanglePatternModel(null);
        RectanglePatternEditor rectanglePatternEditor = new RectanglePatternEditor(rectanglePatternModel);
        rectanglePatternModel.setDocument(rectanglePattern);
        JFrame jFrame = new JFrame("TEST:RectanglePatternEditor");
        jFrame.setPreferredSize(new Dimension(600, 600));
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.add(rectanglePatternEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

