/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.ISODateVerifier;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.TimeVerifier;
import alma.obsprep.ot.editors.misc.IsoDatePicker;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.schedblock.SchedBlockTemporalModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SchedBlockTemporalEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -6447714874737555810L;
    public static final FieldID FID_START_TIME = new FieldID("SchedBlockTemporal.startTime");
    public static final FieldID FID_END_TIME = new FieldID("SchedBlockTemporal.endTime");
    private ValueUnitPairEditor allowedMarginVUPE;
    private JLabel allowedMarginLabel;

    public SchedBlockTemporalEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        boolean bl = this.isMarginFieldToBeDisplayed();
        this.allowedMarginVUPE.setVisible(bl);
        this.allowedMarginLabel.setVisible(bl);
        super.update(fieldID, object);
    }

    private boolean isMarginFieldToBeDisplayed() {
        SchedBlockTemporalModel schedBlockTemporalModel = this.getModel();
        boolean bl = true;
        if (schedBlockTemporalModel != null && schedBlockTemporalModel.getParentModel() != null) {
            ScienceGoal scienceGoal;
            PerformanceParameters performanceParameters;
            SchedBlock schedBlock = (SchedBlock)schedBlockTemporalModel.getParentModel().getDocument();
            if (schedBlock == null) {
                return bl;
            }
            AbstractScienceGoal abstractScienceGoal = null;
            try {
                abstractScienceGoal = schedBlock.getParentScienceGoal();
            }
            catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
                return bl;
            }
            if (abstractScienceGoal instanceof ScienceGoal && (performanceParameters = (scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters()).getIsTimeConstrained() && performanceParameters.getTemporalConstraintType(0).equals((Object)PerformanceParameters.TemporalConstraintType.SINGLE_VISIT)) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public SchedBlockTemporalModel getModel() {
        return (SchedBlockTemporalModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JLabel jLabel = new JLabel("Start Time (UTC)");
        IsoDatePicker isoDatePicker = this.makeIsoDateTimePanel(this, FID_START_TIME, "Required starting time for the scheduling block. ISO format: YYYY-MM-DDThh:mm:ss.mmmZ");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, jLabel, (JComponent)isoDatePicker);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JLabel jLabel2 = new JLabel("End Time (UTC)");
        IsoDatePicker isoDatePicker2 = this.makeIsoDateTimePanel(this, FID_END_TIME, "Time by which the scheduling block must have been executed. Valid format: YYYY-MM-DD [hh:mm:ss.mmm]");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, jLabel2, (JComponent)isoDatePicker2);
        JTextField jTextField = isoDatePicker.getIsoDateTimeField();
        JTextField jTextField2 = isoDatePicker2.getIsoDateTimeField();
        jTextField.setName("SchedBlockTemporal.startTimeField");
        jTextField2.setName("SchedBlockTemporal.endTimeField");
        ISODateVerifier iSODateVerifier = new ISODateVerifier(this, jTextField, null, null, false);
        this.setVerifier(jTextField, "KEYSTROKE_VERIFIER", iSODateVerifier);
        ISODateVerifier iSODateVerifier2 = new ISODateVerifier(this, jTextField2, null, null, true);
        this.setVerifier(jTextField2, "KEYSTROKE_VERIFIER", iSODateVerifier2);
        this.allowedMarginLabel = new JLabel("Allowed Margin");
        this.allowedMarginVUPE = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getAllowedMarginModel(), this.allowedMarginLabel, "Amount of time by which it is acceptable to vary the start and end times from the requested values");
        this.allowedMarginVUPE.setVerifier("FOCUSLOST_VERIFIER", new TimeVerifier(this.allowedMarginVUPE));
        this.add(jPanel);
    }

    @Override
    protected void build() {
        super.build("SchedBlockTemporalConstraints");
    }
}

