/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.AbstractSwitchingCycle;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BeamSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingState;
import alma.obsprep.bo.schedblock.FrequencySwitchingCycle;
import alma.obsprep.bo.schedblock.FrequencySwitchingState;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.ACAPhaseSwitchingConfigurationEditor;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigEditor;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigTabbedEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecFormEditor;
import alma.obsprep.ot.editors.schedblock.SquareLawSetupEditor;
import alma.obsprep.ot.editors.schedblock.SwitchingCycleEditor;
import alma.obsprep.ot.editors.schedblock.UsedByTargetPanel;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.misc.TabbedEditorModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTabbedModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.schedblock.TargetModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public abstract class SpectralSpecBaseEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -5703506050928169599L;
    private static int instances = 0;
    private final int instance;
    private static final String classBaseName = "SpectralSpecBaseEditor.";
    public static final FieldID documentFID = new FieldID("SpectralSpecBaseEditor.document");
    public static final FieldID INTEGDURATION_VUP_FID = new FieldID("SpectralSpecBaseEditor.integrationDurationVup");
    public static final FieldID CHAVDURATION_VUP_FID = new FieldID("SpectralSpecBaseEditor.channelAverageDurationVup");
    public static final FieldID DUMPDURATION_VUP_FID = new FieldID("SpectralSpecBaseEditor.dumpDurationVup");
    public static final FieldID TRANSITIONNAME_FID = new FieldID("SpectralSpecBaseEditor.transitionName");
    public static final FieldID RECEIVERBAND_FID = new FieldID("SpectralSpecBaseEditor.receiverBand");
    public static final FieldID RECEIVERTYPE_FID = new FieldID("SpectralSpecBaseEditor.receiverType");
    public static final FieldID SPECTRALSPECNAME_FID = new FieldID("SpectralSpecBaseEditor.spectralSpecName");
    public static final FieldID APCDATASETS_FID = new FieldID("SpectralSpecBaseEditor.apcDataSetsFID");
    public static final FieldID CAM_FID = new FieldID("SpectralSpecBaseEditor.CAM");
    public static final FieldID LOOFFSETTING_FID = new FieldID("SpectralSpecBaseEditor.LOOffsetting");
    public static final FieldID WALSH180_FID = new FieldID("SpectralSpecBaseEditor.180degWalshFunction");
    public static final FieldID WALSH90_FID = new FieldID("SpectralSpecBaseEditor.90degWalshFunction");
    public static final FieldID USESQUARELAW_FID = new FieldID("SpectralSpecBaseEditor.useSquareLawFID");
    public static final FieldID ACAPANEL_FID = new FieldID("SpectralSpecBaseEditor.ACAPanel");
    public static final FieldID BLPANEL_FID = new FieldID("SpectralSpecBaseEditor.BLPanel");
    public static final FieldID SWITCHINGPANEL_FID = new FieldID("SpectralSpecBaseEditor.SwitchingPanel");
    public static final FieldID CORRCONFIGPANEL_FID = new FieldID("SpectralSpecBaseEditor.CorrConfigPanel");
    public static final FieldID SQUARELAW_FID = new FieldID("SpectralSpecBaseEditor.squareLawPanel");
    public static final FieldID ID_ADJUST_FID = new FieldID("SpectralSpecBaseEditor.adjustIntegrationDuration");
    public static final FieldID CAD_ADJUST_FID = new FieldID("SpectralSpecBaseEditor.adjustChanAvDuration");
    public static final FieldID DD_ADJUST_FID = new FieldID("SpectralSpecBaseEditor.adjustDumpDuration");
    public static final FieldID LINE_CATALOG_FID = new FieldID("SpectralSpecBaseEditor.line catalogue");
    protected BaseBandConfigTabbedEditor basebandConfigEditor;
    protected Editor phaseSwitchingEditor;
    protected Editor squareLawSetupEditor;
    protected final ObservingToolController otc;
    private final Set<Component> squareLawComponents = new HashSet<Component>();
    private final Set<Component> correlatorComponents = new HashSet<Component>();
    private final Set<Component> acaComponents = new HashSet<Component>();
    private final Set<Component> blComponents = new HashSet<Component>();

    public SpectralSpecBaseEditor(Model model, ObservingToolController observingToolController) {
        this.otc = observingToolController;
        this.setModel(model);
        this.instance = instances++;
        this.build();
        model.publish();
    }

    @Override
    public SpectralSpecModel getModel() {
        return (SpectralSpecModel)super.getModel();
    }

    @Override
    protected void build() {
        String string = this.getTag();
        this.createWidgetsAndFIDs(string);
        super.build("Spectral Spec");
    }

    public String getTag() {
        return String.format("%s[%d].", this.getClass().getSimpleName(), this.instance);
    }

    protected void createWidgetsAndFIDs(String string) {
        this.createSubclassWidgetsAndFIDs(string);
    }

    public void setAdvancedEngineeringVisible(boolean bl) {
        if (this.basebandConfigEditor != null) {
            this.basebandConfigEditor.setAdvancedHardwareSetupVisible(bl);
        }
    }

    protected JPanel addBasebandConfigComponents() {
        SpectralSpecModel spectralSpecModel = this.getModel();
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = -1;
        BaseBandConfigEditor baseBandConfigEditor = new BaseBandConfigEditor(spectralSpecModel.getBaseBandConfigTabbedModel().getSubModel());
        this.basebandConfigEditor = new BaseBandConfigTabbedEditor((TabbedEditorModel)spectralSpecModel.getBaseBandConfigTabbedModel(), baseBandConfigEditor);
        this.basebandConfigEditor.addChangeListener(changeEvent -> {
            int n;
            int n2;
            Object object = changeEvent.getSource();
            if ((object instanceof JTabbedPane || object instanceof BaseBandConfigTabbedEditor) && (n2 = this.basebandConfigEditor.getSelectedIndex()) < (n = ((BaseBandConfigTabbedModel)this.basebandConfigEditor.getModel()).getBOCount())) {
                this.setSubclassButtons(n2);
            }
        });
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.basebandConfigEditor, gridBagConstraints);
        jPanel.add(this.basebandConfigEditor);
        this.registerSubView(this.basebandConfigEditor);
        return this.addGroup(4, jPanel, "BaseBand Configurations");
    }

    protected JPanel addCorrelatorConfigurationComponents() {
        SpectralSpecModel spectralSpecModel = this.getModel();
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(spectralSpecModel.getIntegrationDurationModel());
        valueUnitPairEditor.setToolTipText("<html>Duration of each integration in the full-spectral-resolution data. Must be a multiple of the channel average duration.</html>");
        this.registerSubView(valueUnitPairEditor);
        this.register(valueUnitPairEditor, INTEGDURATION_VUP_FID);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Integration Duration"));
        componentCollection.remember(valueUnitPairEditor);
        JButton jButton = this.makeButton(ID_ADJUST_FID, "ADJUST", "Adjust the integration duration to be a multiple of the channel average duration");
        componentCollection.remember(jButton);
        componentCollection.remember(this.makeLabel("Channel Average Duration"));
        JComponent[] jComponentArray = new JComponent[1];
        valueUnitPairEditor = this.makeValueUnitPairEditor(spectralSpecModel.getChannelAverageDurationModel(), "<html>Duration of each integration in the channel-averaged data. Must be a multiple of the dump duration.</html>");
        jComponentArray[0] = valueUnitPairEditor;
        componentCollection.remember(jComponentArray);
        this.register(valueUnitPairEditor, CHAVDURATION_VUP_FID);
        JButton jButton2 = this.makeButton(CAD_ADJUST_FID, "ADJUST", "Adjust the channel average duration to be a multiple of the dump duration");
        componentCollection.remember(jButton2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember((JComponent)this.makeLabel("Atmos. Phase Correction Data To Save"), 2);
        componentCollection.remember((JComponent)this.makeComboBox(APCDATASETS_FID, AbstractCorrelatorConfiguration.getKnownAPCDataSetsList(), "<html>Send:<LI>only the APC-corrected data</li><li>only the APC-uncorrected data</li><li>both</li></html>"), 2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Accumulation Mode"));
        componentCollection.remember(this.makeComboBox(CAM_FID, AbstractCorrelatorConfiguration.getKnownCAMList(), "Correlator accumulation mode"));
        componentCollection.remember(this.makeLabel("LO Offsetting Mode"));
        componentCollection.remember(this.makeComboBox(LOOFFSETTING_FID, AbstractCorrelatorConfiguration.getKnownLOOffsettingModeList(), "LO Offsetting Mode"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        JCheckBox jCheckBox = this.makeCheckBox(WALSH90_FID, "Enable 90deg Walsh Function", "Enable 90deg Walsh Function");
        JCheckBox jCheckBox2 = this.makeCheckBox(WALSH180_FID, "Enable 180deg Walsh Function", "Enable 180deg Walsh Function");
        componentCollection.remember((JComponent)jCheckBox, 2);
        componentCollection.remember((JComponent)jCheckBox2, 2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        JPanel jPanel2 = this.createNewGroup();
        jPanel2.setBorder(BorderFactory.createTitledBorder("64-antenna correlator only"));
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        ComponentCollection componentCollection2 = new ComponentCollection();
        componentCollection2.remember(this.makeLabel("Dump Duration"));
        JComponent[] jComponentArray2 = new JComponent[1];
        valueUnitPairEditor = this.makeValueUnitPairEditor(spectralSpecModel.getDumpDurationModel(), "Fundamental averaging time of the correlator. Usually a multiple of 48ms - must be 1ms for FAST accumulation.");
        jComponentArray2[0] = valueUnitPairEditor;
        componentCollection2.remember(jComponentArray2);
        this.register(valueUnitPairEditor, DUMPDURATION_VUP_FID);
        JButton jButton3 = this.makeButton(DD_ADJUST_FID, "ADJUST", "Adjust the dump duration to be a multiple of 48msec");
        componentCollection2.remember(jButton3);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.register(jPanel2, BLPANEL_FID);
        this.blComponents.add(jPanel2);
        JPanel jPanel3 = this.createNewGroup();
        gridBagLayout2 = this.createNewLayout(jPanel3);
        gridBagConstraints2 = this.createNewConstraints();
        gridBagConstraints2.weightx = 1.0;
        this.phaseSwitchingEditor = new ACAPhaseSwitchingConfigurationEditor(spectralSpecModel.getPhaseSwitchingConfigurationModel());
        this.addComponent(jPanel3, gridBagLayout2, gridBagConstraints2, this.phaseSwitchingEditor);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel3);
        this.register(jPanel3, ACAPANEL_FID);
        this.acaComponents.add(jPanel3);
        JPanel jPanel4 = this.addGroup(4, jPanel, "Correlator Configuration");
        this.register(jPanel4, CORRCONFIGPANEL_FID);
        this.correlatorComponents.add(jPanel4);
        return jPanel4;
    }

    protected void addSquareLawSetupComponent() {
        SpectralSpecModel spectralSpecModel = this.getModel();
        this.squareLawSetupEditor = new SquareLawSetupEditor(spectralSpecModel.getSquareLawSetupModel());
        JPanel jPanel = this.addGroup(this.squareLawSetupEditor, "Square Law Setup");
        this.register(jPanel, SQUARELAW_FID);
        this.squareLawComponents.add(jPanel);
    }

    protected JPanel addSpectralSpecComponents() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, SPECTRALSPECNAME_FID, "Spectral Spec Name", "Name of this Spectral Spec");
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Receiver Band"));
        List<String> list = almaCapabilities.getAvailableReceiverBands();
        componentCollection.remember(this.makeComboBox(RECEIVERBAND_FID, (String[])list.stream().toArray(String[]::new), "The receiver band to use"));
        componentCollection.remember(this.makeLabel("Receiver Type"));
        componentCollection.remember(this.makeTextField(RECEIVERTYPE_FID, false, "Receiver Type"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        JCheckBox jCheckBox = this.makeCheckBox(USESQUARELAW_FID, "Add Total power with square law detectors to this correlator setup", "Check this if you wish to use square law detectors as well as correlators (CSV use only)");
        if (!System.getProperty("Telescope").equals("CSVALMA")) {
            jCheckBox.setEnabled(false);
        }
        this.correlatorComponents.add(jCheckBox);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jCheckBox);
        JPanel jPanel2 = this.addGroup(4, jPanel, "Spectral Spec");
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-Phase 2 Program Scheduling Blocks-Instrument Setup-Spectral Spec");
        this.addSquareLawSetupComponent();
        JPanel jPanel3 = this.addSwitchingComponent();
        CSH.setHelpIDString((Component)jPanel3, (String)"TOC-Phase 2 Program Scheduling Blocks-Instrument Setup-Switching");
        return jPanel2;
    }

    protected JPanel addSwitchingComponent() {
        SwitchingCycleEditor switchingCycleEditor = new SwitchingCycleEditor(this.getModel().getSwitchCycleModel());
        this.register(switchingCycleEditor, SWITCHINGPANEL_FID);
        this.registerSubView(switchingCycleEditor);
        return this.addGroup(4, switchingCycleEditor, "Switching (click '+' to open)", true);
    }

    protected void addUsedByTargetInfoComponent() {
        UsedByTargetModel usedByTargetModel = this.getModel().getUsedByTargetModel();
        UsedByTargetPanel usedByTargetPanel = new UsedByTargetPanel(usedByTargetModel);
        ActionListener actionListener = actionEvent -> {
            ObservingToolGui observingToolGui;
            boolean bl = this.getModel().isTargetContext();
            if (bl && (observingToolGui = ObservingToolController.getMyInstance().getGui()) != null) {
                TargetModel targetModel = (TargetModel)observingToolGui.getEditors().modelFor(Target.class);
                targetModel.duplicateSpectralSpec();
                observingToolGui.refreshCrossHighlight();
            }
        };
        usedByTargetPanel.addOnlyThisButtonListener(actionListener);
        this.addComponent(usedByTargetPanel);
        this.registerSubView(usedByTargetPanel);
    }

    protected abstract void setSubclassButtons(int var1);

    protected abstract void setSubclassEditingACA(boolean var1);

    protected abstract void createSubclassWidgetsAndFIDs(String var1);

    protected boolean isACACorrelator() {
        SpectralSpec spectralSpec;
        try {
            spectralSpec = (SpectralSpec)this.getModel().getDocument();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!spectralSpec.hasCorrelatorConfiguration()) {
            return false;
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        return abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration || abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration;
    }

    protected void updateCorrelatorDependingComponents() {
        boolean bl = this.isACACorrelator();
        for (Component component : this.acaComponents) {
            component.setVisible(bl);
        }
        for (Component component : this.blComponents) {
            component.setVisible(!bl);
        }
        this.setSubclassEditingACA(bl);
    }

    protected void updateDeviceDependingPanel() {
        SpectralSpec spectralSpec;
        try {
            spectralSpec = (SpectralSpec)this.getModel().getDocument();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        for (Component component : this.correlatorComponents) {
            component.setVisible(spectralSpec.hasCorrelatorConfiguration());
        }
        for (Component component : this.squareLawComponents) {
            component.setVisible(spectralSpec.hasSquareLawSetup());
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        SpectralSpecModel spectralSpecModel = this.getModel();
        SpectralSpec spectralSpec = (SpectralSpec)spectralSpecModel.getDocument();
        if (spectralSpec == null) {
            return;
        }
        spectralSpec.getCorrelatorConfiguration();
        if (fieldID == documentFID) {
            this.updateDeviceDependingPanel();
            this.updateCorrelatorDependingComponents();
        } else if (fieldID == RECEIVERTYPE_FID) {
            ReceiverType receiverType = ReceiverType.getReceiverType((String)object);
            String string = receiverType == null ? (String)object : receiverType.getLabel();
            super.update(fieldID, string);
        } else if (fieldID == WALSH90_FID) {
            super.update(fieldID, object);
            this.basebandConfigEditor.getBaseBandConfigEditor().getModel().publish();
        } else {
            super.update(fieldID, object);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        BLCorrelatorConfiguration bLCorrelatorConfiguration;
        InitServices.init();
        System.setProperty("otData.dir", "config/otData/");
        ObservingToolController observingToolController = new ObservingToolController();
        SpectralSpecModel spectralSpecModel = new SpectralSpecModel(null);
        SpectralSpecFormEditor spectralSpecFormEditor = new SpectralSpecFormEditor((Model)spectralSpecModel, observingToolController);
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpec();
        ACACorrelatorConfiguration aCACorrelatorConfiguration = ACACorrelatorConfiguration.createACACorrelatorConfiguration();
        Object object = bLCorrelatorConfiguration = BLCorrelatorConfiguration.createBLCorrelatorConfiguration();
        if (stringArray.length > 0 && stringArray[0].equals("ACA")) {
            object = aCACorrelatorConfiguration;
        } else if (stringArray.length > 0 && stringArray[0].equals("SquareLaw")) {
            object = null;
            spectralSpec.setSquareLawSetup(SquareLawSetup.createSquareLawSetup());
        }
        spectralSpec.setCorrelatorConfiguration((AbstractCorrelatorConfiguration)object);
        FrequencySwitchingCycle frequencySwitchingCycle = FrequencySwitchingCycle.createFrequencySwitchingCycle();
        frequencySwitchingCycle.setDwellTime(Time.createTime((double)6.0, (String)Time.UNIT_MS));
        frequencySwitchingCycle.setNumberOfPositions(2);
        FrequencySwitchingState[] frequencySwitchingStateArray = new FrequencySwitchingState[]{FrequencySwitchingState.createFrequencySwitchingState()};
        frequencySwitchingStateArray[0].setBin(1);
        frequencySwitchingStateArray[0].setDwellTime(Time.createTime((double)9.0, (String)Time.UNIT_MS));
        frequencySwitchingStateArray[0].setOffset(Frequency.createFrequencyGHZ(2.0));
        frequencySwitchingCycle.setFrequencySwitchingState(frequencySwitchingStateArray);
        BeamSwitchingCycle beamSwitchingCycle = BeamSwitchingCycle.createBeamSwitchingCycle();
        beamSwitchingCycle.setDwellTime(Time.createTime((double)3.0, (String)Time.UNIT_MS));
        beamSwitchingCycle.setNumberOfPositions(5);
        beamSwitchingCycle.setMode(BeamSwitchingCycle.MODE_STEPS);
        BeamSwitchingState[] beamSwitchingStateArray = new BeamSwitchingState[2];
        beamSwitchingStateArray[0] = BeamSwitchingState.createBeamSwitchingState();
        beamSwitchingStateArray[0].setPosition(Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCMIN));
        beamSwitchingStateArray[0].setBin(1);
        beamSwitchingStateArray[0].setDwellTime(Time.createTimeSec(0.1));
        beamSwitchingStateArray[0].setTransition(Time.createTimeSec(1.0));
        beamSwitchingStateArray[1] = BeamSwitchingState.createBeamSwitchingState();
        beamSwitchingStateArray[1].setPosition(Angle.createAngle((double)2.0, (String)Angle.UNIT_ARCMIN));
        beamSwitchingStateArray[1].setBin(2);
        beamSwitchingStateArray[1].setDwellTime(Time.createTimeSec(0.2));
        beamSwitchingStateArray[1].setTransition(Time.createTimeSec(2.0));
        beamSwitchingCycle.setBeamSwitchingState(beamSwitchingStateArray);
        spectralSpec.setSwitchingType(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING);
        spectralSpec.setAbstractSwitchingCycle((AbstractSwitchingCycle)((Object)beamSwitchingCycle));
        spectralSpec.setSwitchingType(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING);
        spectralSpec.setAbstractSwitchingCycle((AbstractSwitchingCycle)((Object)frequencySwitchingCycle));
        spectralSpec.setSourceVelocity(Velocity.createVelocity());
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = Target.createTarget();
        target.setAbstractInstrumentSpec((AbstractInstrumentSpec)((Object)spectralSpec));
        schedBlock.addTarget(target);
        schedBlock.addSpectralSpec(spectralSpec);
        spectralSpecModel.setDocument(spectralSpec);
        JFrame jFrame = new JFrame("SpectralSpecEditor");
        jFrame.setDefaultCloseOperation(3);
        JScrollPane jScrollPane = new JScrollPane(spectralSpecFormEditor);
        Container container = jFrame.getContentPane();
        container.setPreferredSize(new Dimension(1050, 1000));
        container.setLayout(new BoxLayout(container, 3));
        final EditorDisablerController editorDisablerController = new EditorDisablerController(spectralSpecFormEditor);
        container.add(jScrollPane);
        container.add(new JButton(new AbstractAction("Toggle"){
            private static final long serialVersionUID = 8181055166091190032L;
            private boolean readonly;
            {
                super(string);
                this.readonly = true;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                editorDisablerController.setReadonly(this.readonly);
                this.readonly = !this.readonly;
            }
        }));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void finalizeUserEdits() {
        this.basebandConfigEditor.finalizeUserEdits();
    }
}

