/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.BeamSwitchingCycle;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.BeamSwitchingStateTable;
import alma.obsprep.ot.editors.schedblock.FrequencySwitchingStateTable;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.schedblock.SwitchingCycleModel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SwitchingCycleEditor
extends EditorWithGridBagLayout {
    private static final String EMPTY_DETAILS_PANEL = "empty-details-panel";
    private static final String FREQUENCY_SWITCHING_DETAILS_PANEL = "frequency-switching-details-panel";
    private static final String BEAM_SWITCHING_DETAILS_PANEL = "beam-switching-details-panel";
    private static final long serialVersionUID = 8859517565082047470L;
    private static final String classBaseName = "SwitchingCycleEditor.";
    public static final FieldID SWITCHINGTYPE_FID = new FieldID("SwitchingCycleEditor.switchingType");
    public static final FieldID FREQ_NUMPOS_FID = new FieldID("SwitchingCycleEditor.freqNumberOfPositions");
    public static final FieldID FREQ_DWELLTIME_VUP_FID = new FieldID("SwitchingCycleEditor.freqDwellTimeVup");
    public static final FieldID BEAM_NUMPOS_FID = new FieldID("SwitchingCycleEditor.beamNumberOfPositions");
    public static final FieldID BEAM_DWELLTIME_VUP_FID = new FieldID("SwitchingCycleEditor.beamDwellTimeVup");
    public static final FieldID BEAM_SWITCH_MODE_FID = new FieldID("SwitchingCycleEditor.beamSwitchingMode");
    private JComboBox switchingTypeCombo;
    private JPanel topLevelGroup;
    private JPanel switchingTypeDetailsPanel;
    private JPanel frequencyPanel;
    private JPanel beamPanel;
    private GridBagLayout topLevelLayout;
    private static final String[] knownBeamSwitchingModes = new String[]{BeamSwitchingCycle.MODE_STEPS, BeamSwitchingCycle.MODE_TRIANGULAR, BeamSwitchingCycle.MODE_SINUSOIDAL};
    private CardLayout detailsPanelLayout;

    protected SwitchingCycleEditor(SwitchingCycleModel switchingCycleModel) {
        this.setModel(switchingCycleModel);
        this.build();
        switchingCycleModel.publish();
    }

    private SwitchingCycleModel getMyModel() {
        return (SwitchingCycleModel)this.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.weightx = 1.0;
        this.topLevelGroup = this.createNewGroup();
        this.topLevelLayout = this.createNewLayout(this.topLevelGroup);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        String[] stringArray = new String[]{SpectralSpec.SWITCHINGTYPE_NO_SWITCHING, SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING, SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING};
        this.switchingTypeCombo = this.makeComboBox(SWITCHINGTYPE_FID, stringArray, "Switching Type");
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Switching Type"));
        componentCollection.remember(this.switchingTypeCombo);
        componentCollection.space();
        this.addComponentArray(this.topLevelGroup, this.topLevelLayout, gridBagConstraints, componentCollection);
        this.addComponent(this, this.layout, this.constraints, this.topLevelGroup);
        this.frequencyPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(this.frequencyPanel);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(this.getMyModel().getFrequencyDwellTimeModel(), "Time spent integrating");
        valueUnitPairEditor.setEditable(false);
        this.registerSubView(valueUnitPairEditor);
        this.register(valueUnitPairEditor, FREQ_DWELLTIME_VUP_FID);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Total Dwell Time"));
        componentCollection.remember(valueUnitPairEditor);
        componentCollection.spaces(10);
        componentCollection.remember(this.makeLabel("Number of positions"));
        componentCollection.remember(this.makeTextField(FREQ_NUMPOS_FID, false, "tooltip"));
        componentCollection.space();
        this.addComponentArray(this.frequencyPanel, gridBagLayout, gridBagConstraints2, componentCollection);
        ++gridBagConstraints2.gridy;
        FrequencySwitchingStateTable frequencySwitchingStateTable = new FrequencySwitchingStateTable(this.getMyModel().getFrequencySwitchingStatesModel());
        this.addComponent(this.frequencyPanel, gridBagLayout, gridBagConstraints2, frequencySwitchingStateTable);
        this.beamPanel = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(this.beamPanel);
        GridBagConstraints gridBagConstraints3 = this.createNewConstraints();
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        valueUnitPairEditor = this.makeValueUnitPairEditor(this.getMyModel().getBeamDwellTimeModel(), "Time spent integrating");
        valueUnitPairEditor.setEditable(false);
        this.registerSubView(valueUnitPairEditor);
        this.register(valueUnitPairEditor, BEAM_DWELLTIME_VUP_FID);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Total Dwell Time"));
        componentCollection.remember(valueUnitPairEditor);
        componentCollection.spaces(10);
        componentCollection.remember(this.makeLabel("Number of positions"));
        componentCollection.remember(this.makeTextField(BEAM_NUMPOS_FID, false, "tooltip"));
        componentCollection.spaces(10);
        JComboBox jComboBox = this.makeComboBox(BEAM_SWITCH_MODE_FID, knownBeamSwitchingModes, "TODO");
        jComboBox.setEnabled(false);
        componentCollection.remember(this.makeLabel("Switching Mode"));
        componentCollection.remember(jComboBox);
        componentCollection.space();
        this.addComponentArray(this.beamPanel, gridBagLayout2, gridBagConstraints3, componentCollection);
        ++gridBagConstraints3.gridy;
        BeamSwitchingStateTable beamSwitchingStateTable = new BeamSwitchingStateTable(this.getMyModel().getBeamSwitchingStatesModel());
        this.addComponent(this.beamPanel, gridBagLayout2, gridBagConstraints3, beamSwitchingStateTable);
        this.detailsPanelLayout = new CardLayout();
        this.switchingTypeDetailsPanel = new JPanel(this.detailsPanelLayout);
        this.switchingTypeDetailsPanel.add((Component)new JPanel(), EMPTY_DETAILS_PANEL);
        this.switchingTypeDetailsPanel.add((Component)this.frequencyPanel, FREQUENCY_SWITCHING_DETAILS_PANEL);
        this.switchingTypeDetailsPanel.add((Component)this.beamPanel, BEAM_SWITCHING_DETAILS_PANEL);
        GridBagConstraints gridBagConstraints4 = this.createNewConstraints();
        gridBagConstraints4.gridy = 1;
        this.addComponent(this.topLevelGroup, this.topLevelLayout, gridBagConstraints4, this.switchingTypeDetailsPanel);
    }

    @Override
    protected void build() {
        super.build("Switching");
    }

    protected void updateSwitchingConfiguration(String string) {
        Container container = this.getParent();
        if (string == SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING) {
            this.detailsPanelLayout.show(this.switchingTypeDetailsPanel, FREQUENCY_SWITCHING_DETAILS_PANEL);
        } else if (string == SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING) {
            this.detailsPanelLayout.show(this.switchingTypeDetailsPanel, BEAM_SWITCHING_DETAILS_PANEL);
        } else if (string == SpectralSpec.SWITCHINGTYPE_NO_SWITCHING) {
            this.detailsPanelLayout.show(this.switchingTypeDetailsPanel, EMPTY_DETAILS_PANEL);
        }
        this.switchingTypeDetailsPanel.validate();
        if (container != null && container.getParent() != null) {
            container.getParent().validate();
            container.getParent().repaint();
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        super.update(fieldID, object);
        if (fieldID == SWITCHINGTYPE_FID) {
            this.updateSwitchingConfiguration((String)object);
            return;
        }
    }
}

