/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.boEditors.PositiveVerifier;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.observingparameters.HolographyParameterModel;
import alma.valuetypes.Frequency;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class HolographyParameterEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_NAME = new FieldID("FID_NAME");
    public static final FieldID FID_FREQUENCY_OPTIONS = new FieldID("FID_FREQUENCY_OPTIONS");
    public static final FieldID FID_FREQUENCY_VALUE = new FieldID("FID_FREQUENCY_VALUE");
    public static final FieldID FID_FREQUENCY_UNIT = new FieldID("FID_FREQUENCY_UNIT");
    public static final FieldID FID_TOWERNAME = new FieldID("FID_TOWERNAME");
    public static final FieldID FID_SCANDIRECTION = new FieldID("FID_SCANDIRECTION");
    public static final FieldID FID_STARTFRACTION = new FieldID("FID_STARTFRACTION");
    public static final FieldID FID_SPEED_VALUE = new FieldID("FID_SPEED_VALUE");
    public static final FieldID FID_SPEED_UNIT = new FieldID("FID_SPEED_UNIT");
    public static final FieldID FID_ROWSCAL = new FieldID("FID_ROWSCAL");
    public static final FieldID FID_CALTIME_VALUE = new FieldID("FID_CALTIME_VALUE");
    public static final FieldID FID_CALTIME_UNIT = new FieldID("FID_CALTIME_UNIT");
    public static final FieldID FID_CALMODE = new FieldID("FID_CALMODE");
    public static final FieldID FID_ROWSIZE_VALUE = new FieldID("FID_ROWSIZE_VALUE");
    public static final FieldID FID_ROWSIZE_UNIT = new FieldID("FID_ROWSIZE_UNIT");
    public static final FieldID FID_NROWS = new FieldID("FID_NROWS");
    public static final FieldID FID_UNISCAN = new FieldID("FID_UNIDIRECTIONALSCAN");
    static final String USERVAL = "User Specified";
    static final double LOFREQMINGHZ = 78.77;
    static final double LOFREQMAXGHZ = 79.07;
    static final double HIFREQMINGHZ = 103.87;
    static final double HIFREQMAXGHZ = 104.17;
    ValueUnitPairEditor freqed;
    private boolean collapse;
    protected JPanel panel;
    protected GridBagLayout gl;
    protected GridBagConstraints gc;

    public HolographyParameterEditor(Model model, boolean bl) {
        this.collapse = bl;
        this.setModel(model);
        this.build();
        model.publish();
    }

    public HolographyParameterEditor(Model model) {
        this(model, false);
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    protected void build() {
        super.build("Holography Parameters");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    protected void addComponents(String string) {
        HolographyParameterModel holographyParameterModel = (HolographyParameterModel)this.getModel();
        this.panel = this.createNewGroup();
        this.gl = this.createNewLayout(this.panel);
        this.gc = this.createNewConstraints();
        this.addTextComponent(this.panel, this.gl, this.gc, FID_NAME, string + " Name", "Name of this " + string);
        this.addComboBox((JComponent)this.panel, this.gl, this.gc, FID_TOWERNAME, "Tower", "Tower to use for holography", HolographyParameters.getKnownTowerNameList());
        String[] stringArray = holographyParameterModel.getFrequencyOptions();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = USERVAL;
        this.freqed = this.makeValueUnitPairEditor(holographyParameterModel.getFrequencyModel(), "For a user specified value");
        this.freqed.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(this.freqed, Frequency.createFrequencyGHZ(78.77).getContentInGHz(), Frequency.createFrequencyGHZ(79.07).getContentInGHz(), Frequency.createFrequencyGHZ(103.87).getContentInGHz(), Frequency.createFrequencyGHZ(104.17).getContentInGHz()));
        this.freqed.setEnabled(false);
        this.addComboBox((JComponent)this.panel, this.gl, this.gc, FID_FREQUENCY_OPTIONS, "Frequency", "Choose standard frequency to use for holography, or type in a value", stringArray2);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeLabel("Enter value:"));
        componentCollection.remember(this.freqed);
        this.addComponentArray(this.panel, this.gl, this.gc, componentCollection);
        this.addLabeledComponent((JComponent)this.panel, this.gl, this.gc, "Number of rows", (JComponent)this.makeTextFieldWithIntegerVerifier(FID_NROWS, "Number of rows", 0, Integer.MAX_VALUE));
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, holographyParameterModel.getRowSizeModel(), "Row size", "Row size");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(valueUnitPairEditor));
        this.addComboBox((JComponent)this.panel, this.gl, this.gc, FID_SCANDIRECTION, "Scan direction", "Direction of holography scan", HolographyParameters.getKnownScanDirectionList());
        valueUnitPairEditor = this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, holographyParameterModel.getSpeedModel(), "Speed", "Scanning speed");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new PositiveVerifier(valueUnitPairEditor));
        OTTextField oTTextField = this.makeTextFieldWithDoubleVerifier(FID_STARTFRACTION, "Start fraction", 0.0, 1.0);
        oTTextField.setEnabled(false);
        this.addLabeledComponent((JComponent)this.panel, this.gl, this.gc, "Start fraction", (JComponent)oTTextField);
        this.addComboBox((JComponent)this.panel, this.gl, this.gc, FID_CALMODE, "Calibration mode", "Holography calibration mode", HolographyParameters.getKnownCalModeList());
        valueUnitPairEditor = this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, holographyParameterModel.getCalTimeModel(), "Calibration time", "Calibration time");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor));
        this.addLabeledComponent((JComponent)this.panel, this.gl, this.gc, "Calibration rows", (JComponent)this.makeTextFieldWithIntegerVerifier(FID_ROWSCAL, "Calibration rows", 0, Integer.MAX_VALUE));
        this.addBooleanComponent(this.panel, this.gl, this.gc, FID_UNISCAN, "Uni Directional Scan", "Check this if you wish to scan one direction.");
        this.addGroup(this.panel, string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        HolographyParameterModel holographyParameterModel = (HolographyParameterModel)this.getModel();
        if (fieldID == FID_FREQUENCY_OPTIONS) {
            String[] stringArray = holographyParameterModel.getFrequencyOptions();
            JComboBox jComboBox = (JComboBox)this.getComponent(FID_FREQUENCY_OPTIONS);
            this.set2(jComboBox, (Object)USERVAL);
            this.freqed.setEnabled(true);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].contains((String)object)) continue;
                this.set2(jComboBox, (Object)stringArray[i]);
                this.freqed.setEnabled(false);
            }
        } else {
            super.update(fieldID, object);
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        HolographyParameterModel holographyParameterModel = new HolographyParameterModel(null);
        HolographyParameterEditor holographyParameterEditor = new HolographyParameterEditor(holographyParameterModel);
        HolographyParameters holographyParameters = HolographyParameters.createHolographyParameters();
        holographyParameterModel.setDocument((Object)holographyParameters);
        EditorWithGridBagLayout.runTestApp(holographyParameterEditor);
    }
}

