/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.CompactIsoDatePicker;
import alma.obsprep.ot.editors.valuetypes.CompactValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.MonitoringConstraintsListModel;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class MonitoringConstraintEditor
extends EditorWithGridBagLayout
implements TableCellEditor {
    private static final long serialVersionUID = -4606878953621068475L;
    private UnitMap reasonableTimeUnits = UnitMap.getUnits((String)"BasicTime");
    private CompactIsoDatePicker dtPanel = null;
    protected transient ChangeEvent changeEvent = null;
    public static final String SPECIFIC_START_LABEL = "Specific Date";
    public static final String ARBITRARY_START_LABEL = "Arbitrary";
    public static final String[] START_TYPE_OPTIONS = new String[]{"Arbitrary", "Specific Date"};
    public static final String[] START_TYPE_LABELS = new String[]{"No specific start time is required", "A specific time is required"};
    private JComponent specificStartOptions = null;
    private JComponent defaultStartOptions = null;
    private OTButtonGroup isSelectedGrp = null;
    private int clickCountToStart = 1;

    public MonitoringConstraintEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        this.specificStartOptions = this.createSpecificStartOptions();
        this.defaultStartOptions = this.createNonSpecificStartOptions();
        this.isSelectedGrp = this.makeOTButtonGroup(EditorField.FIXED_START_FID.getFieldID(), START_TYPE_OPTIONS, START_TYPE_LABELS);
        this.add(this.isSelectedGrp);
        this.add(Box.createHorizontalStrut(2));
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalGlue());
        this.add(this.specificStartOptions);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.defaultStartOptions);
        this.add(Box.createHorizontalStrut(2));
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        CompactValueUnitPairEditor compactValueUnitPairEditor = this.makeCompactValueUnitPairEditor("Monitoring Length", monitoringConstraintsListModel.getLengthOfMonitoringModel(), this.reasonableTimeUnits, "Total length of monitoring cycle");
        compactValueUnitPairEditor.setMinimumSize(compactValueUnitPairEditor.getPreferredSize());
        this.add(compactValueUnitPairEditor);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.makeButton(EditorField.CLOSE_BUTTON_FID.getFieldID(), "Close", EditorField.CLOSE_BUTTON_FID.getTooltip()));
        this.displaySpecificStartComponents(monitoringConstraintsListModel.isFixedStart());
    }

    private void displaySpecificStartComponents(boolean bl) {
        if (bl) {
            this.specificStartOptions.setVisible(true);
            this.defaultStartOptions.setVisible(false);
        } else {
            this.specificStartOptions.setVisible(false);
            this.defaultStartOptions.setVisible(true);
        }
    }

    private JComponent createSpecificStartOptions() {
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.dtPanel = this.makeCompactIsoDateTimePanel(this, EditorField.START_TIME_FID.getFieldID(), EditorField.START_TIME_FID.getTooltip(), MonitoringConstraint.nowInUTC());
        jPanel.add(this.dtPanel);
        CompactValueUnitPairEditor compactValueUnitPairEditor = this.makeCompactValueUnitPairEditor("<html>Margin (&plusmn;)</html>", monitoringConstraintsListModel.getAllowedMarginModel(), this.reasonableTimeUnits, "Allowed margin from the specified delay");
        jPanel.add(compactValueUnitPairEditor);
        return jPanel;
    }

    protected CompactValueUnitPairEditor makeCompactValueUnitPairEditor(String string, AbstractValueUnitPairModel abstractValueUnitPairModel, UnitMap unitMap, String string2) {
        Object[] objectArray = unitMap.getUnitsSorted();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < unitMap.size(); ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        CompactValueUnitPairEditor compactValueUnitPairEditor = new CompactValueUnitPairEditor(string, abstractValueUnitPairModel, stringArray);
        this.registerSubView(compactValueUnitPairEditor);
        compactValueUnitPairEditor.setToolTipText(string2);
        Dimension dimension = compactValueUnitPairEditor.getPreferredSize();
        compactValueUnitPairEditor.setMinimumSize(dimension);
        return compactValueUnitPairEditor;
    }

    private JComponent createNonSpecificStartOptions() {
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        int n = this.specificStartOptions.getPreferredSize().width + 20;
        jPanel.add(Box.createHorizontalStrut(n));
        return jPanel;
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        EditorField editorField = EditorField.getByFieldID(fieldID);
        switch (editorField) {
            case FIXED_START_FID: {
                Boolean bl = object.toString().equals(SPECIFIC_START_LABEL);
                this.displaySpecificStartComponents(bl);
                break;
            }
            case CLOSE_BUTTON_FID: {
                this.stopCellEditing();
                break;
            }
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public Object getCellEditorValue() {
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        return monitoringConstraintsListModel.getCurrentMonitoringConstraint();
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        MonitoringConstraintsListModel monitoringConstraintsListModel = (MonitoringConstraintsListModel)this.getModel();
        if (object instanceof MonitoringConstraint) {
            monitoringConstraintsListModel.setCurrentMonitoringConstraint(object);
            MonitoringConstraint monitoringConstraint = (MonitoringConstraint)((Object)object);
            monitoringConstraintsListModel.setCurrentMonitoringConstraint((Object)monitoringConstraint);
            this.update(EditorField.FIXED_START_FID.getFieldID(), monitoringConstraint.getIsFixedStart() ? SPECIFIC_START_LABEL : ARBITRARY_START_LABEL);
            this.update(EditorField.START_TIME_FID.getFieldID(), monitoringConstraint.getStartTime());
            return this;
        }
        return null;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(EditorField.FIXED_START_FID.getFieldID())) {
            Boolean bl = object.toString().equals(SPECIFIC_START_LABEL);
            this.displaySpecificStartComponents(bl);
        } else if (fieldID.equals(EditorField.START_TIME_FID.getFieldID()) && null != object && "" != object) {
            this.dtPanel.getIsoDateTimeField().setText((String)object);
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Visit Constraint Editor");
        jFrame.setDefaultCloseOperation(3);
        PerformanceParameters performanceParameters = PerformanceParameters.createPerformanceParameters();
        MonitoringConstraintsListModel monitoringConstraintsListModel = new MonitoringConstraintsListModel(null);
        MonitoringConstraintEditor monitoringConstraintEditor = new MonitoringConstraintEditor(monitoringConstraintsListModel);
        monitoringConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(monitoringConstraintEditor);
    }

    public static enum EditorField {
        UNDEFINED("Unknown"),
        CLOSE_BUTTON_FID("VisitConstraintEditor.okButtonFID", "Finish editing"),
        START_TIME_FID("MonitoringConstraintEditor.startTime", "start time for monitoring visit"),
        FIXED_START_FID("MonitoringConstraintEditor.isSpecificDateFID", "Choose type of constraint required");

        private String tooltip;
        private FieldID id;

        public String getTooltip() {
            return this.tooltip;
        }

        public FieldID getFieldID() {
            return this.id;
        }

        private EditorField(String string2) {
            this.id = new FieldID(string2);
            this.tooltip = "";
        }

        private EditorField(String string2, String string3) {
            this.id = new FieldID(string2);
            this.tooltip = string3;
        }

        public static EditorField getByFieldID(FieldID fieldID) {
            for (EditorField editorField : EditorField.values()) {
                if (!editorField.getFieldID().equals(fieldID)) continue;
                return editorField;
            }
            return UNDEFINED;
        }
    }
}

