/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintTableModel;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintsTable;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.VisitConstraintsListModel;
import alma.valuetypes.Time;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VisitConstraintListEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private static final long serialVersionUID = 6076446159232048976L;
    public static final FieldID VISIT_CONSTRAINT_TABLE_FID = new FieldID("VisitConstraintTable");
    public static final FieldID addTPFID = new FieldID("addTempParmFID");
    public static final FieldID openTPFID = new FieldID("openTempParmFID");
    public static final FieldID delTPFID = new FieldID("delTempParmFID");
    public static final FieldID delAllTPFID = new FieldID("delAllTempParmFID");
    public static final FieldID tpCountLabelFID = new FieldID("tpCountLabelFID");
    public static final FieldID hintsLabel = new FieldID("hintsLabel");
    public static final FieldID timingParamStartDate = new FieldID("startDate");
    public static final FieldID selectIfExclusive = new FieldID("selectIfExclusive");
    public static final FieldID updateNote = new FieldID("updateNote");
    private JButton addButton = null;
    private JButton openButton = null;
    private JButton deleteButton = null;
    private JButton deleteAllButton = null;
    private VisitConstraintsTable vcTable = null;
    private static final String COUNT_LABEL_STRING = "Visits specified : ";
    public static final int TABLE_WIDTH = 850;
    public static final int TABLE_HEIGHT = 150;
    public static final int ROW_HEIGHT = 35;
    private int currentRow = 0;

    public VisitConstraintListEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected VisitConstraintListEditor() {
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, tpCountLabelFID, "", COUNT_LABEL_STRING);
        this.addTable(jPanel, gridBagLayout, gridBagConstraints);
        this.addNonCollapsingGroup(jPanel, string);
        jPanel.setBorder(null);
    }

    protected void addTable(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        this.addButton = this.makeButton(addTPFID, "Add", "Add Time Range");
        this.openButton = this.makeButton(openTPFID, "Edit", "Edit Time Range");
        this.deleteButton = this.makeButton(delTPFID, "Delete", "Delete Time Range");
        this.deleteAllButton = this.makeButton(delAllTPFID, "Delete All", "Delete All");
        int n = this.addButton.getPreferredSize().height;
        this.addButton.setPreferredSize(new Dimension(202, n));
        this.openButton.setPreferredSize(new Dimension(202, n));
        this.deleteButton.setPreferredSize(new Dimension(202, n));
        this.deleteAllButton.setPreferredSize(new Dimension(202, n));
        this.vcTable = new VisitConstraintsTable(visitConstraintsListModel.getVisitConstraintsTableModel());
        this.vcTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.vcTable.setRowHeight(35);
        this.vcTable.getTableHeader().setReorderingAllowed(false);
        this.vcTable.setSelectionMode(0);
        this.vcTable.setColumnSelectionAllowed(false);
        this.vcTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.vcTable);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(850, 150));
        this.vcTable.setToolTipText("Details of Visits");
        this.vcTable.setName("VisitConstraintListEditor.tpTable");
        this.initEvents(this.vcTable, VISIT_CONSTRAINT_TABLE_FID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.addButton);
        jPanel2.add(this.openButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.deleteAllButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        int n = 0;
        if (fieldID.equals(addTPFID)) {
            this.closeEditorIfOpen();
            n = this.getVisitConstraintCount();
            visitConstraintsListModel.addVisitConstraint(n);
            this.vcTable.setRowSelectionInterval(n, n);
            this.vcTable.requestFocusInWindow();
        } else if (fieldID.equals(delTPFID)) {
            n = this.vcTable.getSelectedRow();
            this.closeEditorIfOpen();
            visitConstraintsListModel.deleteVisitConstraint(n);
            if (n == 0) {
                if (visitConstraintsListModel.getVisitConstraintCount() != 0) {
                    this.vcTable.setRowSelectionInterval(n, n);
                }
            } else if (n == visitConstraintsListModel.getVisitConstraintCount()) {
                this.vcTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.vcTable.setRowSelectionInterval(n, n);
            }
            this.vcTable.requestFocusInWindow();
        } else if (fieldID.equals(openTPFID)) {
            this.currentRow = n = this.vcTable.getSelectedRow();
            this.vcTable.editCellAt(n, 0);
            this.passFocusToEditorDateField();
        } else if (fieldID.equals(delAllTPFID)) {
            this.closeEditorIfOpen();
            visitConstraintsListModel.clearVisitConstraintList();
        } else if (fieldID.equals(timingParamStartDate)) {
            n = this.vcTable.getSelectedRow();
            this.vcTable.setValueAt(object, n, 0);
        } else if (!fieldID.equals(tpCountLabelFID)) {
            if (fieldID.equals(VisitConstraintEditor.CLOSE_BUTTON_FID)) {
                this.currentRow = visitConstraintsListModel.orderVisitConstraints(this.currentRow);
                this.vcTable.setRowSelectionInterval(this.currentRow, this.currentRow);
                this.vcTable.requestFocusInWindow();
            } else {
                if (fieldID.equals(VISIT_CONSTRAINT_TABLE_FID)) {
                    this.fireTableDataChanged();
                    return;
                }
                if (fieldID.equals(updateNote)) {
                    String string = object.toString();
                    visitConstraintsListModel.updateAssociatedeNote(string);
                    return;
                }
                super.update(fieldID, object);
            }
        }
        this.updateTargetCountLabel();
        this.setButtons();
    }

    private void passFocusToEditorDateField() {
        VisitConstraintEditor visitConstraintEditor = (VisitConstraintEditor)this.vcTable.getEditorComponent();
        if (visitConstraintEditor != null) {
            visitConstraintEditor.makeYearFocus();
        }
    }

    private void closeEditorIfOpen() {
        VisitConstraintEditor visitConstraintEditor = (VisitConstraintEditor)this.vcTable.getEditorComponent();
        if (visitConstraintEditor != null) {
            int n = this.vcTable.getSelectedRow();
            visitConstraintEditor.stopCellEditing();
            this.vcTable.setRowSelectionInterval(n, n);
        }
    }

    private void fireTableDataChanged() {
        VisitConstraintTableModel visitConstraintTableModel;
        if (this.vcTable != null && null != (visitConstraintTableModel = (VisitConstraintTableModel)this.vcTable.getModel())) {
            visitConstraintTableModel.fireTableDataChanged();
        }
    }

    private int getVisitConstraintCount() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        return null == visitConstraintsListModel ? 0 : visitConstraintsListModel.getVisitConstraintCount();
    }

    public void updateTargetCountLabel() {
        JLabel jLabel = (JLabel)this.getComponent(tpCountLabelFID);
        jLabel.setText(COUNT_LABEL_STRING + this.getVisitConstraintCount());
    }

    private void setButtons() {
        boolean bl;
        if (this.addButton == null || this.deleteButton == null) {
            return;
        }
        int n = this.getVisitConstraintCount();
        boolean bl2 = this.vcTable != null && this.vcTable.getEditorComponent() != null && this.vcTable.getEditorComponent().isShowing();
        boolean bl3 = bl = this.vcTable != null && this.vcTable.getRowCount() > 0;
        if (bl2) {
            this.setEnabled(this.addButton, false);
            this.setEnabled(this.openButton, false);
            this.setEnabled(this.deleteButton, false);
            this.setEnabled(this.deleteAllButton, false);
        } else {
            this.setEnabled(this.addButton, true);
            this.setEnabled(this.openButton, n > 0 && null != this.vcTable && this.vcTable.getSelectedRow() != -1);
            this.setEnabled(this.deleteButton, n > 0 && null != this.vcTable && this.vcTable.getSelectedRow() != -1);
            this.setEnabled(this.deleteAllButton, bl);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Single Field Editor");
        jFrame.setDefaultCloseOperation(3);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC).withNano(0).plusDays(1L);
        VisitConstraint visitConstraint = VisitConstraint.createVisitConstraint();
        visitConstraint.setStartTimeInDate(zonedDateTime);
        visitConstraint.setAllowedMargin(Time.createTime((double)7.0, (String)Time.UNIT_D));
        visitConstraint.setIsFixedStart(true);
        performanceParameters.addVisitConstraint(visitConstraint);
        VisitConstraint visitConstraint2 = VisitConstraint.createVisitConstraint();
        visitConstraint2.setStartTimeInDate(zonedDateTime.plusDays(14L));
        visitConstraint2.setAllowedMargin(Time.createTime((double)11.0, (String)Time.UNIT_D));
        visitConstraint2.setIsFixedStart(true);
        performanceParameters.addVisitConstraint(visitConstraint2);
        VisitConstraint visitConstraint3 = VisitConstraint.createVisitConstraint();
        visitConstraint3.setStartTimeInDate(zonedDateTime.plusDays(21L));
        visitConstraint3.setAllowedMargin(Time.createTime((double)7.0, (String)Time.UNIT_D));
        visitConstraint3.setIsFixedStart(true);
        performanceParameters.addVisitConstraint(visitConstraint3);
        VisitConstraintsListModel visitConstraintsListModel = new VisitConstraintsListModel(performanceParameters);
        VisitConstraintListEditor visitConstraintListEditor = new VisitConstraintListEditor(visitConstraintsListModel);
        TestUtilities.runTestApp(visitConstraintListEditor);
    }
}

