/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaRectangleGeometry;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaRoiRectangle;
import alma.obsprep.guiutil.jsky.image.graphics.gui.AlmaCanvasDraw;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.editors.spatialvisual.mapper.FieldMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperEvent;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperListener;
import alma.obsprep.ot.editors.spatialvisual.mapper.OverlayPointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.ShowPointingsException;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.PreferencesListener;
import alma.obsprep.services.generator.refactored.targetcreator.TargetParametersFieldSourceWorker;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import diva.canvas.interactor.Interactor;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureEvent;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerAdapter;
import jsky.image.graphics.RoiFigure;
import jsky.image.gui.MainImageDisplay;

public class RoiMapper
extends FieldMapper
implements PreferencesListener {
    private int roiMode;
    private PointingMapper pmapper;
    private boolean showsPointings = false;

    public RoiMapper(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel, RoiMapperModel roiMapperModel) {
        super(almaNavigatorImageDisplayPanel, roiMapperModel);
        this.configureOverlayPointingMapper();
        MapperListener mapperListener = mapperEvent -> {
            try {
                switch (mapperEvent.getEventType()) {
                    case MOVED: 
                    case RESIZED: 
                    case ROTATED: 
                    case UPDATED: {
                        this.refreshPointings();
                    }
                }
                return;
            }
            catch (ShowPointingsException showPointingsException) {
                return;
            }
        };
        this.addMapperChangeListener(mapperListener);
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        if (observingToolController != null) {
            observingToolController.addPreferencesListener(this);
        }
    }

    public boolean isEditable() {
        return true;
    }

    @Override
    public RoiMapperModel getModel() {
        return (RoiMapperModel)super.getModel();
    }

    protected void draw() {
        if (!this.imagePanel.isWcsSet(true)) {
            this.setDrawing(false);
            return;
        }
        AlmaCanvasDraw almaCanvasDraw = this.imagePanel.getAlmaCanvasDraw();
        almaCanvasDraw.setDrawingMode(this.roiMode);
        almaCanvasDraw.setRoiDrawing(true);
    }

    protected RoiFigure update() {
        this.setRoiMode(3);
        if (!this.isWcsSet(false)) {
            return null;
        }
        PatternFigure patternFigure = null;
        FieldPatternI fieldPatternI = this.getModel().getFieldPattern();
        if (null != fieldPatternI && fieldPatternI.isRectanglePattern()) {
            RectanglePatternI rectanglePatternI = (RectanglePatternI)fieldPatternI;
            BusinessObject businessObject = (BusinessObject)rectanglePatternI;
            if (this.boFigureListManager.figureTableContainsBO(businessObject)) {
                patternFigure = this.boFigureListManager.getFigure(businessObject);
            } else if (rectanglePatternI.getLongitudeLength().getContent() != 0.0 && rectanglePatternI.getLatitudeLength().getContent() != 0.0) {
                patternFigure = this.makeRoiFigure(rectanglePatternI);
                this.boFigureListManager.add(businessObject, patternFigure);
            }
            if (patternFigure != null) {
                this.transformAndDisplayROIFigure((RoiFigure)patternFigure, rectanglePatternI);
            }
            return (RoiFigure)patternFigure;
        }
        return null;
    }

    protected void transformAndDisplayROIFigure(RoiFigure roiFigure, RectanglePatternI rectanglePatternI) {
        double d;
        Object object;
        SkyCoordinates skyCoordinates = rectanglePatternI.getFieldCenterCoordinates();
        SkyCoordinates skyCoordinates2 = skyCoordinates.getType().equals(SkyCoordinates.TYPE_RELATIVE) ? skyCoordinates.getAbsoluteCoordinates(rectanglePatternI.getOrigin()) : skyCoordinates;
        Point2D.Double double_ = new Point2D.Double();
        MainImageDisplay.CoordSystemType coordSystemType = this.imagePanel.getImageDisplay().getCoordSystem();
        switch (coordSystemType) {
            case EQUATORIAL: 
            case UNKNOWN: {
                double_.setLocation(skyCoordinates2.getAbsoluteSkyPointInJ2000Deg());
                break;
            }
            case GALACTIC: {
                double_.setLocation(skyCoordinates2.getAbsoluteSkyPointInGalacticDeg());
                break;
            }
        }
        try {
            this.imagePanel.getImageDisplay().getCoordinateConverter().worldToScreenCoords(double_, false);
        }
        catch (Exception exception) {
            return;
        }
        ValueUnitPair<Angle> valueUnitPair = rectanglePatternI.getLongitudeLength();
        ValueUnitPair<Angle> valueUnitPair2 = rectanglePatternI.getLatitudeLength();
        double d2 = valueUnitPair.getContentInUnits(Angle.UNIT_ARCMIN) / 60.0;
        double d3 = valueUnitPair2.getContentInUnits(Angle.UNIT_ARCMIN) / 60.0;
        Point2D.Double double_2 = new Point2D.Double(d2, d3);
        this.imagePanel.getImageDisplay().getCoordinateConverter().worldToScreenCoords(double_2, true);
        d2 = double_2.getX();
        d3 = double_2.getY();
        AlmaRectangleGeometry almaRectangleGeometry = (AlmaRectangleGeometry)roiFigure.getGeometry();
        RectangularShape rectangularShape = almaRectangleGeometry.getRect();
        rectangularShape.setFrameFromCenter(double_.getX(), double_.getY(), double_.getX() + d2 / 2.0, double_.getY() + d3 / 2.0);
        Shape shape = (Shape)rectangularShape.clone();
        almaRectangleGeometry.setAutoRefresh(false);
        roiFigure.setShape(shape);
        double d4 = 0.0;
        Optional<Object> optional = Optional.empty();
        RotationCase rotationCase = null;
        if (SkyCoordinates.isEquatorial(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
            optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.ICRSToGalactic);
            rotationCase = RotationCase.GalacticImageAndICRSSource;
        } else if (SkyCoordinates.isGalactic(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
            rotationCase = RotationCase.ICRSImageAndGalacticSource;
            optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.GalacticToICRS);
        } else if (SkyCoordinates.isGalactic(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
            rotationCase = RotationCase.GalacticImageAndGalacticSource;
        } else if (SkyCoordinates.isEquatorial(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
            rotationCase = RotationCase.ICRSImageAndICRSSource;
        } else {
            throw new RuntimeException("Unknown image-source coordinate system detected");
        }
        if (optional.isPresent()) {
            object = skyCoordinates2.getICRSSkyCoordinates();
            d4 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(rectanglePatternI.getRotationAngle().getDegs() * -1.0, object.getLongitude().getContentInUnits(Longitude.UNIT_DEG), object.getLatitude().getContentInUnits(Latitude.UNIT_DEG), (TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)optional.get()));
            Log.logger(OverlayPointingMapperModel.class).fine("RoiMapper coordinateSystemCompensatedRotationDegs: " + d4);
            d = RoiMapper.getROIRotationAngle(Math.toRadians(d4), rotationCase, Math.toRadians(this.getImageAngle()), this.getImageFlipped());
        } else {
            d = RoiMapper.getROIRotationAngle(rectanglePatternI.getRotationAngle().getContentInUnits(Angle.UNIT_RAD), rotationCase, Math.toRadians(this.getImageAngle()), this.getImageFlipped());
        }
        Log.logger(RoiMapper.class).fine("FITS rotational offset (degrees) : " + this.getImageAngle());
        Log.logger(RoiMapper.class).fine("RoiMapper rotation angle : " + Math.toDegrees(d));
        almaRectangleGeometry.setAutoRefresh(true);
        almaRectangleGeometry.setRotateAngle(d);
        object = new AffineTransform();
        this.imagePanel.getImageGraphics().deselect((CanvasFigure)roiFigure);
        ((AffineTransform)object).setToRotation(d, rectangularShape.getCenterX(), rectangularShape.getCenterY());
        roiFigure.transform((AffineTransform)object);
        this.imagePanel.getImageGraphics().select((CanvasFigure)roiFigure);
        if (this.isActivated()) {
            this.mapperChanged(new MapperEvent(this, MapperEvent.MapperEventType.UPDATED));
            this.setActivated(false);
        }
    }

    public static double getROIRotationAngle(double d, RotationCase rotationCase, double d2, boolean bl) {
        switch (rotationCase) {
            case GalacticImageAndICRSSource: 
            case ICRSImageAndGalacticSource: {
                if (bl) {
                    d -= d2;
                    break;
                }
                d += d2;
                d *= -1.0;
                break;
            }
            case ICRSImageAndICRSSource: 
            case GalacticImageAndGalacticSource: {
                if (bl) {
                    d += d2;
                    d *= -1.0;
                    break;
                }
                d -= d2;
            }
        }
        return d;
    }

    public static double getROIRotationAngleWithoutFITSImageRotation(double d, RotationCase rotationCase, double d2, boolean bl) {
        switch (rotationCase) {
            case GalacticImageAndICRSSource: 
            case ICRSImageAndGalacticSource: {
                if (bl) break;
                d *= -1.0;
                break;
            }
            case ICRSImageAndICRSSource: 
            case GalacticImageAndGalacticSource: {
                if (!bl) break;
                d *= -1.0;
            }
        }
        return d;
    }

    @Override
    public void deleteSelectedPattern() {
        List<CanvasFigure> list = this.imagePanel.getAlmaCanvasDraw().getSelectedRoiList();
        ListIterator<CanvasFigure> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            PatternFigure patternFigure = (PatternFigure)listIterator.next();
            RectanglePatternI rectanglePatternI = (RectanglePatternI)patternFigure.getBusinessObject();
            if (rectanglePatternI == null) continue;
            this.getModel().deleteRectangleRoi(rectanglePatternI);
            this.boFigureListManager.remove((BusinessObject)rectanglePatternI);
        }
        this.deleteOverlayPointings();
        this.setShowPointings(false);
        this.pmapper.mapperChanged(new MapperEvent(this.pmapper, MapperEvent.MapperEventType.REMOVED));
    }

    protected void setRoiMode(int n) {
        this.roiMode = n;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isActivated()) {
            return;
        }
        if (this.isDrawing()) {
            AlmaCanvasDraw almaCanvasDraw = this.imagePanel.getAlmaCanvasDraw();
            PatternFigure patternFigure = (PatternFigure)almaCanvasDraw.getRoiFigure();
            BusinessObject businessObject = (BusinessObject)this.getModel().addRectangleRoi();
            patternFigure.setBusinessObject(businessObject);
            this.boFigureListManager.add(businessObject, patternFigure);
            this.addCanvasFigureListener((RoiFigure)patternFigure);
            this.getModel().updateBO(patternFigure);
            this.setDrawing(false);
            try {
                this.overlayPointings();
            }
            catch (ShowPointingsException showPointingsException) {
                // empty catch block
            }
            this.mapperChanged(new MapperEvent(this, MapperEvent.MapperEventType.ADDED));
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isActivated()) {
            return;
        }
        if (this.isDrawing()) {
            this.draw();
        }
        this.imagePanel.getAlmaCanvasDraw().mousePressed(mouseEvent);
    }

    protected void addCanvasFigureListener(RoiFigure roiFigure) {
        roiFigure.addCanvasFigureListener((CanvasFigureListener)new CanvasFigureListenerAdapter(){

            public void figureSelected(CanvasFigureEvent canvasFigureEvent) {
            }

            public void figureMoved(CanvasFigureEvent canvasFigureEvent) {
                PatternFigure patternFigure = (PatternFigure)canvasFigureEvent.getFigure();
                RoiMapper.this.getModel().updateBO(patternFigure);
                RoiMapper.this.mapperChanged(new MapperEvent(RoiMapper.this, MapperEvent.MapperEventType.MOVED));
            }

            public void figureResized(CanvasFigureEvent canvasFigureEvent) {
                PatternFigure patternFigure = (PatternFigure)canvasFigureEvent.getFigure();
                RoiMapper.this.getModel().updateBO(patternFigure);
                RoiMapper.this.mapperChanged(new MapperEvent(RoiMapper.this, MapperEvent.MapperEventType.RESIZED));
            }

            public void figureRotated(CanvasFigureEvent canvasFigureEvent) {
                PatternFigure patternFigure = (PatternFigure)canvasFigureEvent.getFigure();
                RoiMapper.this.getModel().updateBO(patternFigure);
                RoiMapper.this.mapperChanged(new MapperEvent(RoiMapper.this, MapperEvent.MapperEventType.ROTATED));
            }
        });
    }

    protected AlmaRoiRectangle makeRoiFigure(RectanglePatternI rectanglePatternI) {
        if (!this.isWcsSet(false)) {
            return null;
        }
        switch (this.roiMode) {
            case 3: {
                break;
            }
            default: {
                return null;
            }
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        AlmaRoiRectangle almaRoiRectangle = new AlmaRoiRectangle(double_){

            @Override
            protected Color getLineColor() {
                return RoiMapper.this.isEditable() ? super.getLineColor() : Color.CYAN;
            }
        };
        almaRoiRectangle.setBusinessObject((BusinessObject)rectanglePatternI);
        if (this.isEditable()) {
            almaRoiRectangle.setInteractor((Interactor)this.imagePanel.getImageGraphics().getRoiSelectionInteractor());
        }
        this.imagePanel.getAlmaCanvasDraw().addFigure(almaRoiRectangle);
        this.addCanvasFigureListener((RoiFigure)almaRoiRectangle);
        return almaRoiRectangle;
    }

    @Override
    public void setFieldPatternType(FieldPattern.FieldPatternType fieldPatternType) {
        super.setFieldPatternType(fieldPatternType);
        if (fieldPatternType == FieldPattern.FieldPatternType.RECTANGLE) {
            this.setActivated(true);
        } else {
            this.clear();
            this.pmapper.mapperChanged(new MapperEvent(this.pmapper, MapperEvent.MapperEventType.REMOVED));
            this.setShowPointings(false);
            this.setActivated(false);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.deleteOverlayPointings();
        this.getModel().getOverlayPointingMapperModel().clearPointingPattern();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.pmapper.initialize();
    }

    private void configureOverlayPointingMapper() {
        OverlayPointingMapperModel overlayPointingMapperModel = this.getModel().getOverlayPointingMapperModel();
        this.pmapper = new PointingMapper(this.imagePanel, overlayPointingMapperModel){

            @Override
            protected boolean isFigureSelectable() {
                return false;
            }
        };
        overlayPointingMapperModel.setMapper(this.pmapper);
        this.pmapper.enableFovFigureSelection(false);
    }

    public PointingMapper getOverlayPointingMapper() {
        return this.pmapper;
    }

    private void setShowPointings(boolean bl) {
        this.showsPointings = bl;
        this.pmapper.setShowPointings(bl);
    }

    public void showPointings(boolean bl) throws ShowPointingsException {
        this.setShowPointings(bl);
        this.overlayPointings();
    }

    private void overlayPointings() throws ShowPointingsException {
        if (this.showsPointings) {
            this.showPointings();
        } else {
            this.deleteOverlayPointings();
        }
    }

    private void showPointings() throws ShowPointingsException {
        if (this.showsPointings) {
            this.setActivated(false);
            this.clear();
            OverlayPointingMapperModel overlayPointingMapperModel = this.getModel().getOverlayPointingMapperModel();
            try {
                overlayPointingMapperModel.configurePointingPattern();
            }
            catch (ShowPointingsException showPointingsException) {
                throw showPointingsException;
            }
            finally {
                overlayPointingMapperModel.publish();
                this.update();
                this.setActivated(true);
            }
        }
    }

    private void deleteOverlayPointings() {
        this.pmapper.clear();
    }

    @Override
    public void handlePreferencesChanged(ObsToolUserPrefs obsToolUserPrefs) {
        try {
            this.refreshPointings();
        }
        catch (ShowPointingsException showPointingsException) {
            Log.logger(RoiMapper.class).warning("Unable to refresh pointings " + showPointingsException.getMessage());
            return;
        }
    }

    public void refreshPointings() throws ShowPointingsException {
        this.deleteOverlayPointings();
        this.showPointings();
    }

    public static enum RotationCase {
        ICRSImageAndICRSSource,
        GalacticImageAndGalacticSource,
        ICRSImageAndGalacticSource,
        GalacticImageAndICRSSource;

    }
}

