/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.util.OrderedSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ColorPanel
extends AbstractPanel
implements PreferencesReadWrite {
    private final JPanel pnlStripe1 = new JPanel();
    private List<JLabel> labels = new ArrayList<JLabel>();
    private List<JButton> swatches = new ArrayList<JButton>();
    private List<Object> groups = new ArrayList<Object>();
    private final ObservingToolGui gui;

    public ColorPanel(ObservingToolGui observingToolGui) {
        this.gui = observingToolGui;
        this.setName("ColourPrefs");
        this.initialize();
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        Object object;
        Iterator<JLabel> iterator = this.labels.iterator();
        Iterator<JButton> iterator2 = this.swatches.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = ((JLabel)object).getText();
            JButton jButton = iterator2.next();
            Color color = jButton.getForeground();
            this.gui.getPalette().setColor(string, color);
        }
        object = this.gui.getPalette();
        obsToolUserPrefs.setColorCatalogueLines(Integer.toHexString(((Colors)object).getColor("Catalog Lines").getRGB()));
        obsToolUserPrefs.setColorCentreFrequency(Integer.toHexString(((Colors)object).getColor("Centre Frequency").getRGB()));
        obsToolUserPrefs.setColorClipboard(Integer.toHexString(((Colors)object).getColor("Clipboard").getRGB()));
        obsToolUserPrefs.setColorError(Integer.toHexString(((Colors)object).getColor("Error").getRGB()));
        obsToolUserPrefs.setColorPhase1(Integer.toHexString(((Colors)object).getColor("Phase1").getRGB()));
        obsToolUserPrefs.setColorPhase2(Integer.toHexString(((Colors)object).getColor("Phase2").getRGB()));
        obsToolUserPrefs.setColorRestFrequency(Integer.toHexString(((Colors)object).getColor("Rest Frequency").getRGB()));
        obsToolUserPrefs.setColorSidebands(Integer.toHexString(((Colors)object).getColor("Sidebands").getRGB()));
        obsToolUserPrefs.setColorUnconfiguredSidebands(Integer.toHexString(((Colors)object).getColor("Sidebands(Unconfigured)").getRGB()));
        obsToolUserPrefs.setColorWarning(Integer.toHexString(((Colors)object).getColor("Warning").getRGB()));
        obsToolUserPrefs.setColorZoomBox(Integer.toHexString(((Colors)object).getColor("Zoom Box").getRGB()));
        obsToolUserPrefs.setColorBaseband(Integer.toHexString(((Colors)object).getColor("Baseband").getRGB()));
        obsToolUserPrefs.setColorSpectralWindow(Integer.toHexString(((Colors)object).getColor("Spectral Window").getRGB()));
        obsToolUserPrefs.setColorAveragingRegion(Integer.toHexString(((Colors)object).getColor("Averaging Region").getRGB()));
        obsToolUserPrefs.setColorSuppressed(Integer.toHexString(((Colors)object).getColor("Suppressed Windows").getRGB()));
        obsToolUserPrefs.setColorTransmission(Integer.toHexString(((Colors)object).getColor("Transmission Spectrum").getRGB()));
        obsToolUserPrefs.setColorDDT(Integer.toHexString(((Colors)object).getColor("DDT").getRGB()));
        obsToolUserPrefs.setColorVLBI(Integer.toHexString(((Colors)object).getColor("VLBI").getRGB()));
        obsToolUserPrefs.setColorFOV(Integer.toHexString(((Colors)object).getColor("FOV").getRGB()));
        obsToolUserPrefs.setColorFOVMainFluxHPBW(Integer.toHexString(((Colors)object).getColor("FOV 1/3 HPBW").getRGB()));
    }

    void initialize() {
        this.pnlStripe1.setLayout(new SpringLayout());
        this.addStripe("Colours", this.pnlStripe1, false);
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        this.pnlStripe1.removeAll();
        this.groups = new ArrayList<Object>();
        this.labels = new ArrayList<JLabel>();
        this.swatches = new ArrayList<JButton>();
        this.createLabelsAndSwatches(this.gui.getPalette());
        Iterator<Object> iterator = this.groups.iterator();
        Iterator<JLabel> iterator2 = this.labels.iterator();
        Iterator<JButton> iterator3 = this.swatches.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            String string = (String)iterator.next();
            int n = (Integer)iterator.next();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new SpringLayout());
            for (int i = 0; i < n; ++i) {
                serializable = iterator3.next();
                jPanel.add((Component)serializable);
                serializable = iterator2.next();
                jPanel.add((Component)serializable);
            }
            EmptyBorder emptyBorder = new EmptyBorder(2, 3, 2, 3);
            serializable = new CompoundBorder(new LineBorder(Color.black), emptyBorder);
            jPanel.setBorder(new TitledBorder((Border)((Object)serializable), string));
            this.pnlStripe1.add(jPanel);
            SpringUtilities.makeCompactGrid((Container)jPanel, (int)0, (int)2);
        }
        SpringUtilities.makeCompactGrid((Container)this.pnlStripe1, (int)1, (int)0);
    }

    private void createLabelsAndSwatches(Colors colors) {
        Map<String, OrderedSet<String>> map = Colors.colourGroups();
        for (String string : map.keySet()) {
            OrderedSet<String> orderedSet = map.get(string);
            this.groups.add(string);
            int n = 0;
            for (String string2 : orderedSet) {
                if (string2.equals("Foreground")) continue;
                Color color = colors.getColor(string2);
                JLabel jLabel = new JLabel(string2);
                JButton jButton = new JButton();
                jButton.setName("ColourPrefs.btn" + string2);
                jButton.setToolTipText("Click to edit color");
                jButton.setFocusPainted(false);
                jButton.setForeground(color);
                jButton.setBackground(color);
                jButton.addActionListener(new SwatchListener(this, string2));
                this.labels.add(jLabel);
                this.swatches.add(jButton);
                ++n;
            }
            this.groups.add(n);
        }
    }

    private class SwatchListener
    implements ActionListener {
        private final ColorPanel parent;
        private final String label;

        public SwatchListener(ColorPanel colorPanel2, String string) {
            this.parent = colorPanel2;
            this.label = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            Color color = JColorChooser.showDialog(this.parent, this.label, jButton.getForeground());
            if (color != null) {
                jButton.setForeground(color);
                jButton.setBackground(color);
            }
        }
    }
}

