/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.obstooluserprefs.FavoriteDirectory;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.actions.RejuvenateProject;
import alma.obsprep.ot.actions.SetPerspective;
import alma.obsprep.ot.actions.WizardInteractor;
import alma.obsprep.ot.actions.WizardPerformer;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.factory.ScrollPane;
import alma.obsprep.ot.gui.factory.SplitPane;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.factory.TreePile;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.CombinedEditorsPanel;
import alma.obsprep.ot.gui.toplevel.Information;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.LoggingPanel;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesListener;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.ot.gui.toplevel.ProblemPrinter;
import alma.obsprep.ot.gui.toplevel.Problems;
import alma.obsprep.ot.gui.toplevel.SplashScreen;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreePanels;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.ot.valdef.others.TestBoCanFindProjectValidator;
import alma.obsprep.ot.valdef.others.TestBoParentValidator;
import alma.obsprep.ot.valdef.others.TestEntityKnowsProjectValidator;
import alma.obsprep.ot.valdef.others.TestEntityRefsNotBrokenValidator;
import alma.obsprep.ot.valdef.others.TestObjectStatusValidator;
import alma.obsprep.ot.valdef.others.TestObsUnitKnowsProjectValidator;
import alma.obsprep.ot.valdef.others.TestTargetAttachmentsValidator;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.LoggingSetup;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.WidgetDetective;
import alma.obsprep.util.debug.ModelDebugger;
import alma.obsprep.util.job.ObsprepThreadGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;
import lombok.NonNull;

public class GuiFactory
implements PreferencesReadWrite {
    private static final int MAX_FILES_IN_FILE_HISTORY = 30;
    private static GuiFactory instance = null;
    private static final String SPLASH_IMAGE_NAME = "ALMASplashImage.png";
    public static final Color COLOR_TREE_BACKGROUND_SELECTED = UIManager.getColor("Tree.selectionBackground");
    public static final Color COLOR_HEADLINE_BACKGROUND = new Color(138, 226, 52);
    private final Border insetBorder1 = new EmptyBorder(0, 2, 0, 2);
    final List<Window> windows = new ArrayList<Window>();
    static JFrame defaultOwner;
    private final java.util.Map<String, String> fileChoosersFavoriteDirs = new HashMap<String, String>();
    private final java.util.Map<Object, JFileChooser> fileChoosers = Collections.synchronizedMap(new HashMap());
    private final java.util.Map<Object, RecentFileList> recentFileLists = new HashMap<Object, RecentFileList>();
    private OTActions.ApplicationWide appActions;

    public static Color COLOR_TREE_BACKGROUND_SELECTED_NOFOCUS() {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            return Color.lightGray;
        }
        return color.brighter();
    }

    public static GuiFactory getFactory() {
        if (instance == null) {
            instance = new GuiFactory();
        }
        return instance;
    }

    private GuiFactory() {
    }

    void dispose() {
        for (Window window : this.windows) {
            window.dispose();
        }
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        for (FavoriteDirectory favoriteDirectory : obsToolUserPrefs.getFavoriteDirectory()) {
            this.fileChoosersFavoriteDirs.put(favoriteDirectory.getKey(), favoriteDirectory.getDir());
        }
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        Object object;
        for (Map.Entry<Object, JFileChooser> entry : this.fileChoosers.entrySet()) {
            File file;
            object = entry.getKey();
            if (!(object instanceof String) || (file = entry.getValue().getSelectedFile()) == null) continue;
            File file2 = file.isDirectory() ? file : file.getParentFile();
            this.fileChoosersFavoriteDirs.put((String)object, file2.getAbsolutePath());
        }
        obsToolUserPrefs.removeAllFavoriteDirectory();
        for (Map.Entry<Object, Object> entry : this.fileChoosersFavoriteDirs.entrySet()) {
            object = new FavoriteDirectory();
            object.setKey((String)entry.getKey());
            object.setDir((String)entry.getValue());
            obsToolUserPrefs.addFavoriteDirectory((FavoriteDirectory)object);
        }
    }

    JPanel giveLabeledPanel(JLabel jLabel, JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    JLabel getPerspectiveLabel(ObservingToolController observingToolController) {
        JLabel jLabel = new JLabel();
        jLabel.setToolTipText("Your currently active Perspective");
        jLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        PreferencesListener preferencesListener = obsToolUserPrefs -> jLabel.setText("Perspective " + obsToolUserPrefs.getPerspective());
        if (observingToolController != null) {
            observingToolController.addPreferencesListener(preferencesListener);
        }
        return jLabel;
    }

    JFrame giveFrame() {
        if (this.appActions.quit == null) {
            throw new RuntimeException("bug: setApplicationWideActions() has not been called");
        }
        final Action action = this.appActions.quit;
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                action.actionPerformed(null);
            }
        };
        Image image = Icons.otIcon.getImage();
        JFrame jFrame = this.giveFrame("");
        if (MiscUtils.isMacOS()) {
            Taskbar taskbar = Taskbar.getTaskbar();
            image = Icons.macOSOTIcon.getImage();
            try {
                taskbar.setIconImage(image);
            }
            catch (Exception exception) {
                Log.logger(GuiFactory.class).warning("Unable to install icon " + exception.getMessage());
            }
        }
        jFrame.setIconImage(image);
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(windowAdapter);
        return jFrame;
    }

    public JFrame giveFrame(String string) {
        JFrame jFrame = new JFrame(string);
        this.windows.add(jFrame);
        return jFrame;
    }

    static void setParentWindow(JFrame jFrame) {
        defaultOwner = jFrame;
    }

    public JFrame getParentWindow() {
        return defaultOwner;
    }

    JScrollPane giveScrollPane(JComponent jComponent) {
        return new ScrollPane(jComponent);
    }

    JLabel giveHeadline(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        jLabel.setOpaque(true);
        jLabel.setBorder(this.insetBorder1);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBackground(COLOR_HEADLINE_BACKGROUND);
        return jLabel;
    }

    public JList<String> givePerspectivesList() {
        JList<String> jList = new JList<String>();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        jList.setModel(defaultListModel);
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(4);
        defaultListModel.addElement("1");
        defaultListModel.addElement("2");
        return jList;
    }

    LookAndFeel giveLookAndFeel(String string) {
        if (string.equals("Mac OS X") || string.equals("CDE/Motif")) {
            return null;
        }
        LookAndFeel lookAndFeel = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            if (!string.equals(lookAndFeelInfo.getName())) continue;
            try {
                lookAndFeel = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
            }
            catch (Exception exception) {
                Log.logger((Object)this).info("Could not instantiate look and feel: " + String.valueOf(exception));
            }
        }
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            lookAndFeel = null;
        }
        return lookAndFeel;
    }

    public JList<String> giveLookAndFeelList() {
        JList<String> jList = new JList<String>();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        jList.setModel(defaultListModel);
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(4);
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            defaultListModel.addElement(lookAndFeelInfo.getName());
        }
        defaultListModel.removeElement("Mac OS X");
        defaultListModel.removeElement("CDE/Motif");
        return jList;
    }

    SplashScreen giveSplashScreen(String string) {
        return this.getSplashScreen(string, null);
    }

    SplashScreen getSplashScreen(String string, String string2) {
        return new SplashScreen(SPLASH_IMAGE_NAME, string, string2);
    }

    JSplitPane getSplitPane(int n) {
        SplitPane splitPane = new SplitPane(n);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(12);
        return splitPane;
    }

    ProjectTreePanels getTreePanels(ObservingToolGui observingToolGui, boolean bl) {
        return new ProjectTreePanels(observingToolGui, bl);
    }

    JPanel getCombinedEditorsPanel() {
        CombinedEditorsPanel combinedEditorsPanel = new CombinedEditorsPanel();
        combinedEditorsPanel.setLayout(new BoxLayout(combinedEditorsPanel, 0));
        return combinedEditorsPanel;
    }

    TreePile getTreePile() {
        return new TreePile(this);
    }

    JPanel getSpatialFormPanel() {
        return this.giveGridLayoutPanel();
    }

    JPanel getSpatialVisualPanel() {
        return this.giveGridLayoutPanel();
    }

    JPanel getSpectralVisualPanel() {
        return this.giveGridLayoutPanel();
    }

    JComponent getLogging() {
        LoggingPanel loggingPanel = new LoggingPanel();
        loggingPanel.setName("Logging");
        return loggingPanel;
    }

    JComponent giveProblems() {
        Problems problems = new Problems(this);
        problems.setName("Problems");
        return problems;
    }

    ProblemPrinter giveProblemPrinter(ObservingToolGui observingToolGui) {
        return new ProblemPrinter(observingToolGui);
    }

    JComponent getInformationPanel() {
        Information information = new Information();
        information.setName("Information Panel");
        return information;
    }

    private JPanel giveGridLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<JFileChooser> getFileChoosers() {
        java.util.Map<Object, JFileChooser> map = this.fileChoosers;
        synchronized (map) {
            ArrayList<JFileChooser> arrayList = new ArrayList<JFileChooser>(this.fileChoosers.values());
            return arrayList.iterator();
        }
    }

    public JFileChooser giveFileChooser(Object object) {
        return this.giveFileChooser(object, null);
    }

    JFileChooser giveFileChooser(Object object, String string) {
        JFileChooser jFileChooser = this.fileChoosers.get(object);
        if (jFileChooser == null) {
            if (object instanceof String && string == null) {
                string = this.fileChoosersFavoriteDirs.get(object);
            }
            final String string2 = object instanceof String ? String.format("RecentFileList-%s.fileList", object) : String.format("RecentFileList-%s.fileList", object.getClass().getName());
            jFileChooser = new JFileChooser(string);
            if (string2 != null) {
                RecentFileList recentFileList = new RecentFileList(jFileChooser);
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                String string3 = preferences.get(string2, null);
                if (string3 != null) {
                    RecentFileList.FileListModel fileListModel = recentFileList.getListModel();
                    String[] stringArray = string3.split(File.pathSeparator);
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        String string4 = stringArray[i];
                        File file = new File(string4);
                        if (!file.exists()) continue;
                        fileListModel.add(file);
                    }
                }
                this.recentFileLists.put(jFileChooser, recentFileList);
                jFileChooser.setAccessory(recentFileList);
                jFileChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                            if (!(actionEvent.getSource() instanceof JFileChooser)) {
                                return;
                            }
                            JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                            RecentFileList recentFileList = GuiFactory.this.recentFileLists.get(jFileChooser);
                            if (recentFileList == null) {
                                return;
                            }
                            File file = jFileChooser.getSelectedFile();
                            recentFileList.add(jFileChooser.getSelectedFile());
                            jFileChooser.setSelectedFile(file);
                            StringBuilder stringBuilder = new StringBuilder(300);
                            HashSet<File> hashSet = new HashSet<File>();
                            for (int i = 0; i < recentFileList.getListModel().getSize(); ++i) {
                                File file2 = recentFileList.getListModel().getElementAt(i);
                                if (hashSet.contains(file2) || i >= 30) continue;
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(File.pathSeparator);
                                }
                                hashSet.add(file2);
                                stringBuilder.append(file2.getPath());
                            }
                            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                            preferences.put(string2, stringBuilder.toString());
                            try {
                                preferences.flush();
                            }
                            catch (BackingStoreException backingStoreException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            this.fileChoosers.put(object, jFileChooser);
        }
        return jFileChooser;
    }

    void setApplicationWideActions(OTActions.ApplicationWide applicationWide) {
        this.appActions = applicationWide;
    }

    private void menuAdd(JMenu jMenu, Action action, String string) {
        boolean bl = action.getValue("SwingSelectedKey") != null;
        JMenuItem jMenuItem = bl ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
        jMenu.add(jMenuItem);
        if (action instanceof OTAction) {
            ((OTAction)action).addComponent(jMenuItem);
        }
        jMenuItem.setName(string);
    }

    JMenu giveHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.setName("HelpMenu");
        jMenu.setMnemonic(72);
        this.menuAdd(jMenu, this.appActions.helpUserManual, "Menu.UserManual");
        this.menuAdd(jMenu, this.appActions.helpReferenceManual, "Menu.ReferenceManual");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.about, "Menu.About");
        this.menuAdd(jMenu, this.appActions.releasenotes, "Menu.ReleaseNotes");
        return jMenu;
    }

    JMenu getSearchMenu() {
        JMenu jMenu = new JMenu("Search");
        jMenu.setName("SearchMenu");
        jMenu.setMnemonic(83);
        this.menuAdd(jMenu, this.appActions.seePreviousProblem, "Menu.PrevProb");
        this.menuAdd(jMenu, this.appActions.seeNextProblem, "Menu.NextProb");
        return jMenu;
    }

    Action[] getToolBarActions(@NonNull OTActions.ProjectTiedActions projectTiedActions) {
        if (projectTiedActions == null) {
            throw new NullPointerException("prjActions is marked non-null but is null");
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(projectTiedActions.newProposal);
        arrayList.add(projectTiedActions.newDDTProposal);
        arrayList.add(projectTiedActions.newSupplementalCallProposal);
        arrayList.add(projectTiedActions.newProject);
        arrayList.add(projectTiedActions.newCommissioningProject);
        arrayList.add(null);
        arrayList.add(projectTiedActions.open);
        arrayList.add(projectTiedActions.retrieve);
        arrayList.add(projectTiedActions.save);
        arrayList.add(projectTiedActions.submit);
        arrayList.add(null);
        arrayList.add(projectTiedActions.addPhaseIScienceGoal);
        arrayList.add(projectTiedActions.addPhase2ScienceGoal);
        arrayList.add(projectTiedActions.generateSBs);
        arrayList.add(projectTiedActions.runPhaseIIGeneratorBatch);
        arrayList.add(projectTiedActions.addObsUnitSet);
        arrayList.add(projectTiedActions.addSchedblock);
        arrayList.add(null);
        arrayList.add(this.appActions.importStdLibrary);
        arrayList.add(this.appActions.expTimeCalc);
        arrayList.add(projectTiedActions.runProjectSummaryDisplay);
        arrayList.add(null);
        arrayList.add(projectTiedActions.validate);
        arrayList.add(this.appActions.seePreviousProblem);
        arrayList.add(this.appActions.seeNextProblem);
        arrayList.add(projectTiedActions.displaySciencePlan);
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    JMenu giveDebugMenu(final ObservingToolController observingToolController) {
        final ObservingToolController observingToolController2 = observingToolController;
        JMenu jMenu = new JMenu("Debug");
        jMenu.setMnemonic(68);
        OTActions.ActionProperties actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Activate Perspective 1";
        actionProperties.accelKey = 49;
        jMenu.add(OTActions.createAction(new SetPerspective(observingToolController, "1"), actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Activate Perspective 2";
        actionProperties.accelKey = 50;
        jMenu.add(OTActions.createAction(new SetPerspective(observingToolController, "2"), actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Load Prefs";
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                observingToolController2.jobLoadPreferences().go();
                observingToolController2.jobInitialApplyConnectionPreferences().go();
                observingToolController2.jobInitialApplyGuiPreferences().go();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Clear JCS Cache";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorSet.clearCache();
                MiscUtils.resetJCSCache();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Save Prefs";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                observingToolController2.jobCollectAndSavePreferences().go();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        JMenu jMenu2 = new JMenu("Change local Loglevel");
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "INFO";
        class ChangeLevel
        extends AbstractAction {
            private final String level;
            private final boolean stacktraces;

            private ChangeLevel(String string, boolean bl) {
                this.level = string;
                this.stacktraces = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = InitServices.loggerProvider.loggerNames();
                LoggingSetup.configureDebugging(arrayList, this.level, this.stacktraces);
            }
        }
        abstractAction = new ChangeLevel("INFO", false);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "FINEST (plus stacktraces)";
        abstractAction = new ChangeLevel("FINEST", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "FINE (plus stacktraces)";
        abstractAction = new ChangeLevel("FINE", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "DEBUG (plus stacktraces)";
        abstractAction = new ChangeLevel("DEBUG", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "TRACE (plus stacktraces)";
        abstractAction = new ChangeLevel("TRACE", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        jMenu.add(jMenu2);
        jMenu2 = new JMenu("Experimental Features");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Rejuvenate project (ICT-4534)";
        abstractAction = new RejuvenateProject.Action(observingToolController.getGui());
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        jMenu2.add(new AbstractAction("Generate Phase1 SBs"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    final ObsProposal obsProposal = observingToolController.getGui().getPrimaryProject().getObsProposal();
                    WizardInteractor wizardInteractor = new WizardInteractor(){

                        @Override
                        public boolean confirmOverwrite() {
                            return true;
                        }

                        @Override
                        public boolean requestConfirmation(String string) {
                            return true;
                        }

                        @Override
                        public boolean shouldScienceGoalKnowItGotGenerated() {
                            return false;
                        }

                        @Override
                        public AbstractScienceGoal[] getScienceGoals() {
                            return obsProposal.getAbstractScienceGoalScienceGoal();
                        }

                        @Override
                        public void error(String string, Exception exception) {
                            GUIUtilities.warning(null, "Failure while running generator: " + string, exception);
                        }

                        @Override
                        public void busy(boolean bl) {
                        }
                    };
                    WizardPerformer wizardPerformer = new WizardPerformer(wizardInteractor);
                    wizardPerformer.perform();
                }
                catch (UnknownEntityException unknownEntityException) {
                    unknownEntityException.printStackTrace();
                }
            }
        });
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Dbg-Validate active Project";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ValidatorSet validatorSet = new ValidatorSet();
                    validatorSet.registerValidator(new TestBoParentValidator());
                    validatorSet.registerValidator(new TestTargetAttachmentsValidator());
                    validatorSet.registerValidator(new TestEntityKnowsProjectValidator());
                    validatorSet.registerValidator(new TestEntityRefsNotBrokenValidator());
                    validatorSet.registerValidator(new TestObsUnitKnowsProjectValidator());
                    validatorSet.registerValidator(new TestBoCanFindProjectValidator());
                    validatorSet.registerValidator(new TestObjectStatusValidator());
                    ObsProject obsProject = observingToolController.getGui().getActiveProject();
                    ProblemTableModel problemTableModel = observingToolController.getGui().getProblemModel(obsProject);
                    validatorSet.validate((BusinessObject)obsProject, problemTableModel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Dbg-Render active trees on/off";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ProjectTree projectTree = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getPhase1Tree();
                    projectTree.getTree().toggleDebugRendering();
                    projectTree = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getPhase2Tree();
                    projectTree.getTree().toggleDebugRendering();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Dump active Project to Text Window";
        abstractAction = new AbstractAction(){
            StringBuilder text = new StringBuilder();

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JFrame jFrame = new JFrame();
                    jFrame.setDefaultCloseOperation(2);
                    JTextArea jTextArea = new JTextArea();
                    jFrame.add(new JScrollPane(jTextArea));
                    this.text.setLength(0);
                    ObsProject obsProject = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getObsProject();
                    Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
                    this.print("ObsProject", (BusinessObject)boBundle.boProject);
                    this.print("ObsProposal", (BusinessObject)boBundle.boProposal);
                    this.print("ObsAttachment", (BusinessObject)boBundle.boDocuments);
                    this.print("ObsReview", (BusinessObject)boBundle.boReview);
                    for (SchedBlock schedBlock : boBundle.boSchedblocks) {
                        this.print("SchedBlock", (BusinessObject)schedBlock);
                    }
                    jTextArea.setText(this.text.toString());
                    this.text.setLength(0);
                    jFrame.setSize(650, 800);
                    jFrame.setTitle(String.valueOf(new Date()) + "   " + obsProject.getProjectName());
                    jFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            void print(String string, BusinessObject businessObject) {
                this.text.append("--- ").append(string).append(" ---\n");
                this.text.append(businessObject != null ? businessObject.toXml() : "none.\n");
                this.text.append("\n");
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Inspect active Project in Model Debugger";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ObsProject obsProject = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getObsProject();
                    Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
                    ModelDebugger modelDebugger = new ModelDebugger(boBundle);
                    modelDebugger.showFrame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Show concurrent Threads";
        abstractAction = new AbstractAction(){
            JDialog d;
            Table ta;
            Timer timer;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.d = new JDialog(observingToolController.getGui().frame, "OT Threads", false);
                this.d.setDefaultCloseOperation(2);
                this.ta = new Table();
                this.d.add(new JScrollPane(this.ta));
                final JButton jButton = new JButton(new AbstractAction("Refresh"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ObsprepThreadGroup obsprepThreadGroup = ObsprepThreadGroup.getInstance();
                        Thread[] threadArray = new Thread[obsprepThreadGroup.activeCount()];
                        obsprepThreadGroup.enumerate(threadArray);
                        Object[][] objectArray = new Object[threadArray.length][3];
                        for (int i = 0; i < threadArray.length; ++i) {
                            Thread thread = threadArray[i];
                            objectArray[i][0] = thread.getName() + (thread.isDaemon() ? "  [daemon]" : "");
                            int n = thread.getPriority();
                            objectArray[i][1] = (n <= 3 ? "low" : (n >= 8 ? "high" : "normal")) + " (" + n + ")";
                            objectArray[i][2] = thread.getState();
                        }
                        SwingUtilities.invokeLater(() -> {
                            ((DefaultTableModel)ta.getModel()).setDataVector(objectArray, new Object[]{"name", "priority", "state"});
                            ColumnResizer.adjustColumnPreferredWidths(ta);
                        });
                    }
                });
                final JCheckBox jCheckBox = new JCheckBox("Auto-Refresh");
                jCheckBox.addItemListener(itemEvent -> {
                    if (((JCheckBox)itemEvent.getSource()).isSelected()) {
                        this.timer = new Timer(true);
                        this.timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                jButton.doClick();
                            }
                        }, 0L, 2000L);
                    } else {
                        if (this.timer != null) {
                            this.timer.cancel();
                        }
                        this.timer = null;
                    }
                });
                this.d.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        jCheckBox.setSelected(false);
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(jCheckBox);
                jPanel.add(jButton);
                this.d.add((Component)jPanel, "South");
                jButton.doClick();
                this.d.pack();
                this.d.setVisible(true);
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Run the Widget Detective";
        abstractAction = new AbstractAction(){
            WidgetDetective det;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.det == null) {
                    this.det = new WidgetDetective(observingToolController.heap.getGui().frame);
                }
                this.det.on();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Check Help IDs";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<Component> arrayList = new ArrayList<Component>();
                Collection<Editor> collection = observingToolController2.getGui().getEditors().getAllEditors();
                for (Editor editor : collection) {
                    arrayList.addAll(this.findGroupPanels(editor));
                }
                this.printRefManMapIDs(arrayList);
                this.printBadRefManMapIDs(arrayList);
            }

            String getParentEditorName(Component component) {
                String string = component.getClass().getSimpleName();
                if (string.equals("GroupPanel")) {
                    string = this.getParentEditorName(component.getParent());
                }
                return string;
            }

            ArrayList<Component> findGroupPanels(Component component) {
                ArrayList<Component> arrayList = new ArrayList<Component>();
                if (component instanceof EditorWithGridBagLayout.GroupPanel) {
                    arrayList.add(component);
                }
                if (component instanceof Container) {
                    for (Component component2 : ((Container)component).getComponents()) {
                        arrayList.addAll(this.findGroupPanels(component2));
                    }
                }
                return arrayList;
            }

            void printRefManMapIDs(ArrayList<Component> arrayList) {
                System.out.println("Component Reference Manual ID Mappings");
                System.out.println("--------------------------------------");
                for (Component component : arrayList) {
                    String string = CSH.getHelpIDString((Component)component);
                    System.out.println(this.getParentEditorName(component) + " --> " + string);
                }
            }

            void printBadRefManMapIDs(ArrayList<Component> arrayList) {
                HelpSet helpSet = observingToolController2.heap.getReferenceManualHS();
                Map map = observingToolController2.heap.getReferenceManualHS().getCombinedMap();
                System.out.println("\nBad Component Reference Manual ID Mappings");
                System.out.println("------------------------------------------");
                for (Component component : arrayList) {
                    String string = CSH.getHelpIDString((Component)component);
                    if (map.isValidID(string, helpSet)) continue;
                    System.out.println(this.getParentEditorName(component) + " --> " + string);
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Print Help IDs";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Enumeration enumeration = observingToolController2.heap.getReferenceManualHS().getCombinedMap().getAllIDs();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    String string = e.toString();
                    string = string.substring(4);
                    string = string.split(",")[0];
                    arrayList.add(string);
                }
                Collections.sort(arrayList);
                System.out.println("Complete List Of Reference Manual Mapping IDs");
                System.out.println("---------------------------------------------");
                for (String string : arrayList) {
                    System.out.println(string);
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        jMenu.addSeparator();
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Exit without saving preferences";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (GUIUtilities.confirm(null, "Exit without saving preferences?")) {
                        System.exit(0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        return jMenu;
    }

    JMenu getEditMenu(OTActions.ProjectTiedActions projectTiedActions) {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setName("EditMenu");
        jMenu.setMnemonic(69);
        this.menuAdd(jMenu, projectTiedActions.cut, "Menu.Cut");
        this.menuAdd(jMenu, projectTiedActions.copy, "Menu.Copy");
        this.menuAdd(jMenu, projectTiedActions.paste, "Menu.Paste");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.rename, "Menu.Rename");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.addPhaseIScienceGoal, "Menu.AddPh1SG");
        this.menuAdd(jMenu, projectTiedActions.addPhase2ScienceGoal, "Menu.AddSFSG");
        this.menuAdd(jMenu, projectTiedActions.cloneProjectTreeNode, "Menu.DuplicateScienceGoal");
        JMenu jMenu2 = new JMenu("Add Observatory Setup");
        this.menuAdd(jMenu2, projectTiedActions.addHolographySetup, "Menu.AddHolSetup");
        this.menuAdd(jMenu2, projectTiedActions.addOpticalPointingScienceGoal, "Menu.AddOPTSG");
        this.menuAdd(jMenu2, projectTiedActions.addRadiometricPointing, "Menu.AddRadioPoint");
        this.menuAdd(jMenu2, projectTiedActions.addBaselineCalibrationGoal, "Menu.AddBaseCalG");
        this.menuAdd(jMenu2, projectTiedActions.addCalibratorSurveyGoal, "Menu.AddCalSurG");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.addObsUnitSet, "Menu.AddOUS");
        this.menuAdd(jMenu, projectTiedActions.addSchedblock, "Menu.AddSB");
        this.menuAdd(jMenu, projectTiedActions.addObservingGroup, "Menu.AddObsGrp");
        this.menuAdd(jMenu, projectTiedActions.addTarget, "Menu.AddTrg");
        this.menuAdd(jMenu, projectTiedActions.addFieldSource, "Menu.AddFS");
        this.menuAdd(jMenu, projectTiedActions.addBLSpectralSpec, "Menu.AddBLSS");
        this.menuAdd(jMenu, projectTiedActions.addACASpectralSpec, "Menu.AddACSSS");
        this.menuAdd(jMenu, projectTiedActions.addSquareLawSpectralSpec, "Menu.AddSqLSS");
        this.menuAdd(jMenu, projectTiedActions.addScienceParameters, "Menu.AddScPar");
        this.menuAdd(jMenu, projectTiedActions.addPhaseCalParameters, "Menu.AddPhCal");
        this.menuAdd(jMenu, projectTiedActions.addPointingCalParameters, "Menu.AddPoiCal");
        this.menuAdd(jMenu, projectTiedActions.addAmplitudeCalParameters, "Menu.AddAmpCal");
        this.menuAdd(jMenu, projectTiedActions.addPolarizationCalParameters, "Menu.AddPolCal");
        this.menuAdd(jMenu, projectTiedActions.addFocusCalParameters, "Menu.AddFocCal");
        this.menuAdd(jMenu, projectTiedActions.addAtmosphericCalParameters, "Menu.AddAtmCal");
        this.menuAdd(jMenu, projectTiedActions.addDelayCalParameters, "Menu.AddDelayCal");
        this.menuAdd(jMenu, projectTiedActions.addCheckSourceCalParameters, "Menu.AddCheckSourceCal");
        this.menuAdd(jMenu, projectTiedActions.addCheckSourceCalParameters, "Menu.AddCheckSourceCal");
        this.menuAdd(jMenu, projectTiedActions.addDGCReferenceCalParameters, "Menu.AddDGCReferenceCal");
        this.menuAdd(jMenu, projectTiedActions.addDGCScienceCalParameters, "Menu.AddDGCScienceCal");
        this.menuAdd(jMenu, projectTiedActions.addSidebandRatioCalParameters, "Menu.AddSidebandRatioCal");
        this.menuAdd(jMenu, projectTiedActions.addBandpassCalParameters, "Menu.AddBndpsCal");
        this.menuAdd(jMenu, projectTiedActions.addOpticalPointingParameters, "Menu.AddOptPoi");
        this.menuAdd(jMenu, projectTiedActions.addRadiometricPointingParameters, "Menu.AddRadPoi");
        this.menuAdd(jMenu, projectTiedActions.addHolographyParameters, "Menu.AddHolPar");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.attachComponents, "Menu.AttachComps");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.delete, "Menu.Delete");
        this.menuAdd(jMenu, projectTiedActions.csvSuspend, "Menu.Suspend");
        this.menuAdd(jMenu, projectTiedActions.csvResume, "Menu.Resume");
        this.menuAdd(jMenu, projectTiedActions.repair, "Menu.Repair");
        this.menuAdd(jMenu, projectTiedActions.terminate, "Menu.Terminate");
        return jMenu;
    }

    JMenu getToolMenu(OTActions.ProjectTiedActions projectTiedActions) {
        JMenu jMenu = new JMenu("Tool");
        jMenu.setName("ToolMenu");
        jMenu.setMnemonic(84);
        this.menuAdd(jMenu, projectTiedActions.calTool, "Menu.CalTool");
        this.menuAdd(jMenu, projectTiedActions.loTool, "Menu.LoTool");
        this.menuAdd(jMenu, this.appActions.expTimeCalc, "Menu.ETC");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.generateSBs, "Menu.Ph2Gen");
        this.menuAdd(jMenu, projectTiedActions.runProjectSummaryDisplay, "Menu.ProjectTimeSummaryDisplay");
        this.menuAdd(jMenu, projectTiedActions.runPhaseIGeneratorBatch, "Menu.Ph1GenBatch");
        this.menuAdd(jMenu, projectTiedActions.runPhaseIIGeneratorBatch, "Menu.Ph2GenBatch");
        this.menuAdd(jMenu, projectTiedActions.exportSB, "Menu.ExportSB");
        this.menuAdd(jMenu, projectTiedActions.scienceGoalFeedback, "Menu.SGFeedback");
        this.menuAdd(jMenu, projectTiedActions.generateWholePDF, "Menu.GenWholePDF");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.disableOusCompProtect, "Menu.DisableProtect");
        return jMenu;
    }

    JMenu getViewMenu(OTActions.ProjectTiedActions projectTiedActions) {
        JMenu jMenu = new JMenu("View");
        jMenu.setName("ViewMenu");
        jMenu.setMnemonic(86);
        this.menuAdd(jMenu, this.appActions.viewFeedback, "Menu.ViewFeedback");
        this.menuAdd(jMenu, this.appActions.viewOverview, "Menu.ViewOverview");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.expandNodes, "Menu.Expand");
        this.menuAdd(jMenu, projectTiedActions.findPreviousSimilarNodeInProjectTree, "Menu.FindPreviousSimilarNode");
        this.menuAdd(jMenu, projectTiedActions.findNextSimilarNodeInProjectTree, "Menu.FindNextSimilarNode");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.importStdLibrary, "Menu.ViewStdLib");
        return jMenu;
    }

    JMenu getFileMenu(OTActions.ProjectTiedActions projectTiedActions) {
        JMenu jMenu = new JMenu("File");
        jMenu.setName("FileMenu");
        jMenu.setMnemonic(70);
        this.menuAdd(jMenu, projectTiedActions.newProposal, "Menu.NewProp");
        this.menuAdd(jMenu, projectTiedActions.newDDTProposal, "Menu.NewDDTProp");
        this.menuAdd(jMenu, projectTiedActions.newSupplementalCallProposal, "Menu.NewSupplementalProp");
        this.menuAdd(jMenu, projectTiedActions.newProject, "Menu.NewProj");
        this.menuAdd(jMenu, projectTiedActions.newCommissioningProject, "Menu.NewCommProj");
        this.menuAdd(jMenu, projectTiedActions.newVLBIProject, "Menu.NewVLBIProj");
        this.menuAdd(jMenu, projectTiedActions.newSupplementalCallProject, "Menu.NewSupplementalCallProj");
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Open Project");
        jMenu2.setName("OpenProjectMenu");
        this.menuAdd(jMenu2, projectTiedActions.open, "Menu.Open");
        this.menuAdd(jMenu2, projectTiedActions.openfind, "Menu.OpenFind");
        this.menuAdd(jMenu2, projectTiedActions.retrieve, "Menu.Retrieve");
        this.menuAdd(jMenu2, projectTiedActions.backupRestore, "Menu.Restore");
        jMenu.add(jMenu2);
        jMenu2 = new JMenu("Open Project as New Proposal");
        jMenu2.setName("OpenProjectAsNew.Menu");
        this.menuAdd(jMenu2, projectTiedActions.retrieveAsNewProposal, "Menu.RetrieveAsNew");
        this.menuAdd(jMenu2, projectTiedActions.retrieveAsNewDDTProposal, "Menu.RetrieveAsNewDDT");
        this.menuAdd(jMenu2, projectTiedActions.retrieveAsNewACASupplementalProposal, "Menu.RetrieveAsNewSupplementalCallProposal");
        jMenu.add(jMenu2);
        this.menuAdd(jMenu, projectTiedActions.save, "Menu.Save");
        this.menuAdd(jMenu, projectTiedActions.saveAs, "Menu.SaveAs");
        if (MiscUtils.isDeveloperUIFeaturesEnabled()) {
            this.menuAdd(jMenu, projectTiedActions.revertProjectFromDisk, "Menu.RevertProjectFromDisk");
            this.menuAdd(jMenu, projectTiedActions.displaySciencePlan, "Menu.DisplaySciencePlan");
        }
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.importStdLibrary, "Menu.ImpStdLib");
        jMenu2 = new JMenu("Use Project as Template");
        jMenu2.setName("UseTemplateMenu");
        this.menuAdd(jMenu2, this.appActions.importLibrary, "Menu.ImpLib");
        this.menuAdd(jMenu2, this.appActions.retrieveLibrary, "Menu.RetrieveLib");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTiedActions.validate, "Menu.Validate");
        this.menuAdd(jMenu, projectTiedActions.submit, "Menu.Submit");
        this.menuAdd(jMenu, projectTiedActions.submitAsNew, "Menu.SubmitAsNew");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.preferencesDialog, "Menu.ShowPrefs");
        this.menuAdd(jMenu, this.appActions.savePreferences, "Menu.SavePrefs");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.quit, "Menu.Quit");
        return jMenu;
    }

    protected ArrayList<Action> givePhase2TreePopupMenuItemList(OTActions.ProjectTiedActions projectTiedActions) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(projectTiedActions.cut);
        arrayList.add(projectTiedActions.copy);
        arrayList.add(projectTiedActions.paste);
        arrayList.add(null);
        arrayList.add(projectTiedActions.addPhase2ScienceGoal);
        arrayList.add(projectTiedActions.cloneProjectTreeNode);
        arrayList.add(projectTiedActions.runPhaseIIGeneratorBatch);
        arrayList.add(null);
        arrayList.add(projectTiedActions.addOpticalPointingScienceGoal);
        arrayList.add(projectTiedActions.addRadiometricPointing);
        arrayList.add(projectTiedActions.addBaselineCalibrationGoal);
        arrayList.add(projectTiedActions.addCalibratorSurveyGoal);
        arrayList.add(projectTiedActions.addHolographySetup);
        arrayList.add(projectTiedActions.generateSBs);
        arrayList.add(projectTiedActions.rename);
        arrayList.add(projectTiedActions.addObsUnitSet);
        arrayList.add(projectTiedActions.addSchedblock);
        arrayList.add(null);
        arrayList.add(projectTiedActions.addObservingGroup);
        arrayList.add(projectTiedActions.addTarget);
        arrayList.add(projectTiedActions.addFieldSource);
        arrayList.add(projectTiedActions.addBLSpectralSpec);
        arrayList.add(projectTiedActions.addACASpectralSpec);
        arrayList.add(projectTiedActions.addSquareLawSpectralSpec);
        arrayList.add(projectTiedActions.addOpticalCameraSpec);
        arrayList.add(projectTiedActions.addScienceParameters);
        arrayList.add(projectTiedActions.addPhaseCalParameters);
        arrayList.add(projectTiedActions.addPointingCalParameters);
        arrayList.add(projectTiedActions.addAmplitudeCalParameters);
        arrayList.add(projectTiedActions.addPolarizationCalParameters);
        arrayList.add(projectTiedActions.addFocusCalParameters);
        arrayList.add(projectTiedActions.addAtmosphericCalParameters);
        arrayList.add(projectTiedActions.addDelayCalParameters);
        arrayList.add(projectTiedActions.addCheckSourceCalParameters);
        arrayList.add(projectTiedActions.addDGCReferenceCalParameters);
        arrayList.add(projectTiedActions.addDGCScienceCalParameters);
        arrayList.add(projectTiedActions.addSidebandRatioCalParameters);
        arrayList.add(projectTiedActions.addBandpassCalParameters);
        arrayList.add(projectTiedActions.addOpticalPointingParameters);
        arrayList.add(projectTiedActions.addRadiometricPointingParameters);
        arrayList.add(projectTiedActions.addHolographyParameters);
        arrayList.add(null);
        arrayList.add(projectTiedActions.attachComponents);
        arrayList.add(projectTiedActions.setRepresentativeTarget);
        arrayList.add(null);
        arrayList.add(projectTiedActions.expandNodes);
        arrayList.add(projectTiedActions.collapseNodes);
        arrayList.add(projectTiedActions.findPreviousSimilarNodeInProjectTree);
        arrayList.add(projectTiedActions.findNextSimilarNodeInProjectTree);
        arrayList.add(null);
        arrayList.add(projectTiedActions.delete);
        arrayList.add(projectTiedActions.csvSuspend);
        arrayList.add(projectTiedActions.csvResume);
        arrayList.add(projectTiedActions.repair);
        arrayList.add(projectTiedActions.terminate);
        arrayList.add(projectTiedActions.dumpXMLToWindow);
        arrayList.add(projectTiedActions.dumpXMLToClipboard);
        return arrayList;
    }

    protected ArrayList<Action> getPhase1TreePopupMenuItemList(OTActions.ProjectTiedActions projectTiedActions) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(projectTiedActions.cut);
        arrayList.add(projectTiedActions.copy);
        arrayList.add(projectTiedActions.paste);
        arrayList.add(null);
        arrayList.add(projectTiedActions.addPhaseIScienceGoal);
        arrayList.add(projectTiedActions.cloneProjectTreeNode);
        arrayList.add(projectTiedActions.scienceGoalFeedback);
        arrayList.add(projectTiedActions.generateWholePDF);
        arrayList.add(projectTiedActions.runProjectSummaryDisplay);
        arrayList.add(projectTiedActions.rename);
        arrayList.add(null);
        arrayList.add(projectTiedActions.expandNodes);
        arrayList.add(projectTiedActions.collapseNodes);
        arrayList.add(projectTiedActions.findPreviousSimilarNodeInProjectTree);
        arrayList.add(projectTiedActions.findNextSimilarNodeInProjectTree);
        arrayList.add(null);
        arrayList.add(projectTiedActions.delete);
        arrayList.add(projectTiedActions.dumpXMLToWindow);
        arrayList.add(projectTiedActions.dumpXMLToClipboard);
        return arrayList;
    }

    private class RecentFileList
    extends JPanel {
        private final JList<File> list;
        private final FileListModel listModel;
        private final JFileChooser fileChooser;

        private RecentFileList(JFileChooser jFileChooser) {
            this.fileChooser = jFileChooser;
            this.listModel = new FileListModel();
            this.list = new JList<File>(this.listModel);
            this.list.setSelectionMode(0);
            this.list.setCellRenderer(new FileListCellRenderer());
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(this.list));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    File file = null;
                    try {
                        file = RecentFileList.this.list.getSelectedValue();
                        if (file.exists()) {
                            RecentFileList.this.fileChooser.setSelectedFile(file);
                            if (mouseEvent.getClickCount() == 2) {
                                RecentFileList.this.fileChooser.approveSelection();
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            };
            this.list.addMouseListener(mouseAdapter);
            this.list.addListSelectionListener(listSelectionEvent -> {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    try {
                        File file = this.list.getSelectedValue();
                        if (file != null && file.exists()) {
                            this.fileChooser.setSelectedFile(file);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            });
        }

        private void add(File file) {
            this.listModel.add(file);
            this.list.setSelectedIndex(0);
        }

        public FileListModel getListModel() {
            return this.listModel;
        }

        private class FileListModel
        extends AbstractListModel<File> {
            private final List<File> files = new ArrayList<File>();

            private void add(File file) {
                if (this.files.contains(file)) {
                    this.files.remove(file);
                }
                if (this.files.isEmpty()) {
                    this.files.add(file);
                } else {
                    this.files.add(0, file);
                }
                this.fireIntervalAdded(this, 0, 0);
            }

            private void clear() {
                int n = this.files.size() - 1;
                if (n >= 0) {
                    this.files.clear();
                    this.fireIntervalRemoved(this, 0, n);
                }
            }

            @Override
            public int getSize() {
                return this.files.size();
            }

            @Override
            public File getElementAt(int n) {
                return this.files.get(n);
            }
        }

        private class FileListCellRenderer
        extends DefaultListCellRenderer {
            private FileListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof File) {
                    File file = (File)object;
                    Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                    this.setIcon(icon);
                    this.setToolTipText(file.getParent());
                    this.setText(file.getName());
                }
                return this;
            }
        }
    }
}

