/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.HistoricalProjectRefresher;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelStatusSubscriber;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;

public class ObsProjectModel
extends Model
implements ModelStatusSubscriber,
ProjectResetListener {
    public ObsProjectModel(Object object) {
        super(object);
    }

    private ObsProposalModel getObsProposalModel() {
        return (ObsProposalModel)ObservingToolController.getOTGui().getEditors().modelFor(ObsProposal.class);
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        try {
            this.getObsProposalModel().setDocument(this.getObsProject().getObsProposal());
        }
        catch (UnknownEntityException unknownEntityException) {
            unknownEntityException.printStackTrace();
        }
    }

    private ObsProject getObsProject() {
        return (ObsProject)this.getDocument();
    }

    @Override
    public void publish() {
        ObsProject obsProject = this.getObsProject();
        if (obsProject == null) {
            return;
        }
        this.publish(FieldIDs.projectNameFID, obsProject.getProjectName());
        this.publish(FieldIDs.versionFID, obsProject.getVersion());
        this.publish(FieldIDs.assignedPriorityFID, obsProject.getAssignedPriority());
        this.publish(FieldIDs.codeFID, obsProject.gettrueCode());
        this.publish(FieldIDs.submissionRecordFID, obsProject.getSubmissionRecordTable());
        this.publish(FieldIDs.manualModeFID, obsProject.getManualMode());
        this.publish(FieldIDs.simModeFID, obsProject.getSimulationMode());
        this.publish(FieldIDs.isCalibrationFID, obsProject.getIsCalibration());
        this.publish(FieldIDs.isCommissioningFID, obsProject.getIsCommissioning());
        this.publish(FieldIDs.projectStatusFID, obsProject.getStatus());
        this.publish(FieldIDs.staffProjectNoteFID, obsProject.getStaffProjectNote());
        this.publish(FieldIDs.taPhase2CommentsFID, obsProject.getTaPhase2Comments());
        this.publish(FieldIDs.taMainCommentsFID, obsProject.getTaMainComments());
        this.publish(FieldIDs.consensusReportFID, obsProject.getConsensusReport());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        ObsProject obsProject = this.getObsProject();
        if (FieldIDs.projectNameFID.equals(fieldID)) {
            obsProject.setProjectName(string);
        } else if (FieldIDs.versionFID.equals(fieldID)) {
            obsProject.setVersion(string);
        } else if (FieldIDs.codeFID.equals(fieldID)) {
            obsProject.setCode(string);
        } else if (FieldIDs.manualModeFID.equals(fieldID)) {
            obsProject.setManualMode((Boolean)object);
        } else if (FieldIDs.simModeFID.equals(fieldID)) {
            obsProject.setSimulationMode((Boolean)object);
        } else if (FieldIDs.isCalibrationFID.equals(fieldID)) {
            obsProject.setIsCalibration((Boolean)object);
        } else if (FieldIDs.isCommissioningFID.equals(fieldID)) {
            obsProject.setIsCommissioning((Boolean)object);
        } else if (FieldIDs.staffProjectNoteFID.equals(fieldID)) {
            obsProject.setStaffProjectNote(string);
        } else if (FieldIDs.taPhase2CommentsFID.equals(fieldID)) {
            obsProject.setTaPhase2Comments(string);
        } else if (FieldIDs.taMainCommentsFID.equals(fieldID)) {
            obsProject.setTaMainComments(string);
        } else if (FieldIDs.consensusReportFID.equals(fieldID)) {
            obsProject.setConsensusReport(string);
        }
        return object;
    }

    @Override
    public void fieldInvalid(Model model, FieldID fieldID, String string) {
    }

    @Override
    public void fieldValid(Model model, FieldID fieldID) {
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        Object object2;
        if (fieldID == FieldIDs.projectNameFID && (object2 = this.getObsProject()) != null) {
            object2.setProjectName((String)object);
        }
        if (fieldID == FieldIDs.codeFID && (object2 = this.getObsProject()) != null) {
            object2.setCode((String)object);
        }
        if (fieldID == FieldIDs.investigatorSetPiFID && object instanceof Investigator) {
            object2 = (Investigator)((Object)object);
            ObsProject obsProject = this.getObsProject();
            if (obsProject != null) {
                obsProject.setPI(object2.getUserId());
            }
        }
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        HistoricalProjectRefresher historicalProjectRefresher = new HistoricalProjectRefresher(obsProject);
        historicalProjectRefresher.resetTimeConstrainedFlagWhenNoVisitsDefined();
    }
}

