/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralVisualEditor;
import alma.obsprep.ot.models.obsproject.CalibratedGoalModel;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetsModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class ObservatoryGoalModel
extends Model
implements CalibratedGoalModel {
    private final ObservatoryGoalTargetsModel targetModel = new ObservatoryGoalTargetsModel(null);
    private final CalibrationSetupParametersModel calibrationSetupParametersModel = new CalibrationSetupParametersModel(null);
    private final SpectralSetupParametersModel spectralSetupModel = new SpectralSetupParametersModel(null);
    private final ValueUnitPairModel integrationTimeModel = new ValueUnitPairModel(null, ObservatoryGoalTargetsEditor.INTEGRATION_TIME_VALUE_FID, ObservatoryGoalTargetsEditor.INTEGRATION_TIME_UNITS_FID);

    public ObservatoryGoalModel(Object object2) {
        super(object2);
        this.registerSubModel(this.targetModel);
        this.registerSubModel(this.calibrationSetupParametersModel);
        this.registerSubModel(this.spectralSetupModel);
        this.registerSubModel(this.integrationTimeModel);
        this.spectralSetupModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            if (fieldID == ScienceViewSpectralVisualEditor.FID_VISUALPANEL) {
                this.publish(fieldID, null);
            }
        });
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            ObservatoryGoalTargetParameters[] observatoryGoalTargetParametersArray;
            if (ObservatoryGoalTargetsModel.CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID.equals(fieldID) && object instanceof ObservatoryGoalTargetParameters[] && (observatoryGoalTargetParametersArray = (ObservatoryGoalTargetParameters[])object).length > 0) {
                this.calibrationSetupParametersModel.setDefaultSearchPosition(observatoryGoalTargetParametersArray[0]);
            }
        };
        this.targetModel.subscribe(modelChangeSubscriber);
        this.setDocument(object2);
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object instanceof ObservatoryGoal) {
            ObservatoryGoal observatoryGoal = (ObservatoryGoal)object;
            this.targetModel.setDocument(observatoryGoal);
            this.calibrationSetupParametersModel.setDocument((Object)observatoryGoal.getCalibrationSetupParameters());
            this.spectralSetupModel.setDocument((Object)observatoryGoal.getSpectralSetupParameters());
            this.integrationTimeModel.setDocument(observatoryGoal.getIntegrationTime());
        }
    }

    @Override
    public void publish() {
        this.publishSubmodels();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        for (Model model : this.getSubModels()) {
            object = model.update(editor, fieldID, object);
        }
        return object;
    }

    public ObservatoryGoalTargetsModel getTargetModel() {
        return this.targetModel;
    }

    @Override
    public CalibrationSetupParametersModel getCalibrationSetupParametersModel() {
        return this.calibrationSetupParametersModel;
    }

    public SpectralSetupParametersModel getSpectralSetupModel() {
        return this.spectralSetupModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }
}

