/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.misc.TabbedEditor;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigTabbedEditor;
import alma.obsprep.ot.models.misc.TabbedEditorWithSummaryTableModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTableModel;
import alma.obsprep.ot.models.schedblock.LOSetupPreferenceModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class BaseBandConfigTabbedModel
extends TabbedEditorWithSummaryTableModel {
    private SpectralSpecModel spectralSpecModel;
    private LOSetupPreferenceModel loPrefsModel = null;
    private ValueUnitPairModel floogModel = null;
    private ValueUnitPairModel lo1FrequencyModel = null;

    public BaseBandConfigTabbedModel(SpectralSpec spectralSpec) {
        super(spectralSpec);
        super.setTableModel(new BaseBandConfigTableModel(null));
        BaseBandConfigModel baseBandConfigModel = new BaseBandConfigModel(null);
        this.setSubModel(baseBandConfigModel);
        this.registerSubModel(baseBandConfigModel);
        baseBandConfigModel.subscribe(this);
        baseBandConfigModel.getDesiredCenterFreqRestModel().subscribe(this);
        this.loPrefsModel = new LOSetupPreferenceModel(null);
        this.registerSubModel(this.loPrefsModel);
        this.floogModel = new ValueUnitPairModel(null, BaseBandConfigTabbedEditor.FLOOG_VALUE_FID, BaseBandConfigTabbedEditor.FLOOG_UNIT_FID);
        this.lo1FrequencyModel = new ValueUnitPairModel(null, BaseBandConfigTabbedEditor.LO1FREQUENCY_VALUE_FID, BaseBandConfigTabbedEditor.LO1FREQUENCY_UNIT_FID);
        this.registerSubModel(this.floogModel);
        this.registerSubModel(this.lo1FrequencyModel);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            if (model == this.lo1FrequencyModel) {
                SpectralSpec spectralSpec = this.getSpectralSpec();
                if (spectralSpec != null) {
                    this.publish(BaseBandConfigTabbedEditor.LO1FREQUENCY_FID, (Object)spectralSpec.getLO1Frequency());
                }
                return;
            }
        };
        this.lo1FrequencyModel.subscribe(modelChangeSubscriber);
    }

    public SpectralSpec getSpectralSpec() {
        return (SpectralSpec)this.getDocument();
    }

    public BaseBandConfigTableModel getBaseBandConfigTableModel() {
        return (BaseBandConfigTableModel)this.basebandConfigTableModel;
    }

    public LOSetupPreferenceModel getLOSetupPreferenceModel() {
        return this.loPrefsModel;
    }

    public ValueUnitPairModel getLO1FrequencyModel() {
        return this.lo1FrequencyModel;
    }

    @Override
    public BaseBandConfigModel getSubModel() {
        return (BaseBandConfigModel)super.getSubModel();
    }

    protected SpectralSpecModel getSpectralSpecModel() {
        if (this.spectralSpecModel == null) {
            for (Model model = this.getParentModel(); model != null; model = model.getParentModel()) {
                if (!(model instanceof SpectralSpecModel)) continue;
                this.spectralSpecModel = (SpectralSpecModel)model;
                break;
            }
        }
        return this.spectralSpecModel;
    }

    @Override
    public BaseBand newBO() {
        BaseBand baseBand = this.getSpectralSpec().addNewBaseBand();
        this.publish();
        return baseBand;
    }

    @Override
    public BaseBand newBO(int n) {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        spectralSpec.suspendDataRateChangeNotifier();
        BaseBand baseBand = spectralSpec.addNewBaseBand(n, true);
        spectralSpec.activateDataRateChangeNotifier();
        this.publish();
        return baseBand;
    }

    @Override
    public BaseBand getBO(int n) {
        return this.getSpectralSpec().getBaseBand(n);
    }

    @Override
    public void deleteBO(Object object) {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        spectralSpec.suspendDataRateChangeNotifier();
        this.getSpectralSpec().removeBaseBand((BaseBand)object);
        spectralSpec.activateDataRateChangeNotifier();
        this.publish();
    }

    @Override
    public int getBOCount() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec == null) {
            return 0;
        }
        return spectralSpec.getBaseBandCount();
    }

    @Override
    public void publish() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        this.publish(BaseBandConfigTabbedEditor.documentFID, spectralSpec);
        if (spectralSpec != null) {
            this.publish(TabbedEditor.FID_MULTIDOCUMENT, spectralSpec);
            this.publish(BaseBandConfigTabbedEditor.LO1FREQUENCY_FID, (Object)spectralSpec.getLO1Frequency());
            this.publish(BaseBandConfigTabbedEditor.TOTALDATARATE_FID, (Object)spectralSpec.getInstantaneousDataRate());
            this.publish(BaseBandConfigTabbedEditor.HAS_HWSETUP_FID, spectralSpec.getFrequencySetup().getHasHardwareSetup());
            this.publish(BaseBandConfigTabbedEditor.TUNEHIGH_FID, spectralSpec.getFrequencySetup().getTuneHigh());
        }
        this.getBaseBandConfigTableModel().fireTableDataChanged();
        this.getFloogModel().publish();
        this.getLO1FrequencyModel().publish();
        this.getLOSetupPreferenceModel().publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        FrequencySetup frequencySetup = this.getSpectralSpec().getFrequencySetup();
        if (fieldID.equals(BaseBandConfigTabbedEditor.HAS_HWSETUP_FID)) {
            Boolean bl = (Boolean)object;
            frequencySetup.setHasHardwareSetup(bl);
            frequencySetup.setIsUserSpecifiedLO1(bl);
            return bl;
        }
        if (fieldID.equals(BaseBandConfigTabbedEditor.TUNEHIGH_FID)) {
            Boolean bl = (Boolean)object;
            frequencySetup.setTuneHigh(bl);
            return bl;
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object != null) {
            this.getBaseBandConfigTableModel().setSpectralSpec(this.getSpectralSpec());
            if (this.getFloogModel() != null) {
                this.getFloogModel().setDocument((Object)this.getSpectralSpec().getFrequencySetup().getFloog());
            }
            if (this.getLO1FrequencyModel() != null) {
                this.getLO1FrequencyModel().setDocument((Object)this.getSpectralSpec().getLO1Frequency());
            }
            this.getLOSetupPreferenceModel().setDocument(this.getSpectralSpec().getFrequencySetup());
            Target[] targetArray = this.getSpectralSpec().getTargetList();
            boolean bl = false;
            if (targetArray != null && targetArray.length > 0) {
                for (Target target : targetArray) {
                    if (!target.hasScienceParameters()) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.getLOSetupPreferenceModel().calculateLOs(5, false);
            }
        }
        this.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        int n;
        super.modelChanged(model, fieldID, object);
        BaseBandConfigModel baseBandConfigModel = this.getSubModel();
        if (model == baseBandConfigModel.getDesiredCenterFreqRestModel() && (n = baseBandConfigModel.getBaseBand().getBaseBandIndex()) != -1) {
            this.tableRowsUpdated(n);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModel tableModel = (TableModel)tableModelEvent.getSource();
        if (tableModel == this.basebandConfigTableModel) {
            int n;
            int n2 = tableModelEvent.getColumn();
            if (n2 != (n = BaseBandConfigTableModel.ColumnDescriptor.DATARATE.ordinal())) {
                super.tableChanged(tableModelEvent);
            }
        } else {
            try {
                int n = tableModelEvent.getType();
                if (n == 0) {
                    BaseBandConfigModel baseBandConfigModel = this.getSubModel();
                    if (baseBandConfigModel.getBaseBand() == null) {
                        return;
                    }
                    int n3 = baseBandConfigModel.getBaseBand().getBaseBandIndex();
                    int n4 = BaseBandConfigTableModel.ColumnDescriptor.DATARATE.ordinal();
                    this.basebandConfigTableModel.fireTableCellUpdated(n3, n4);
                }
            }
            catch (ClassCastException classCastException) {
                Log.logger((Object)this).warning("Unexpected TableModel : " + String.valueOf(tableModel.getClass()));
            }
        }
    }

    public void dataRateChanged() {
        this.getSubModel().dataRateChanged();
        this.publish(BaseBandConfigTabbedEditor.TOTALDATARATE_FID, (Object)this.getSpectralSpec().getInstantaneousDataRate());
        this.getBaseBandConfigTableModel().dataRateChanged();
    }

    public ValueUnitPairModel getFloogModel() {
        return this.floogModel;
    }
}

