/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.schedblock.FieldPatternEditor;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.schedblock.RectanglePatternEditor;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.ot.models.schedblock.CrossPatternModel;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;
import alma.obsprep.ot.models.schedblock.FillPatternModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.schedblock.RectanglePatternModel;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FieldPatternModel
extends Model {
    private final List<FieldPatternChangeListener> listeners = new ArrayList<FieldPatternChangeListener>();
    private FillPatternModel fillPatternModel = null;
    private PointingPatternModel pointingPatternModel = new PointingPatternModel(null);
    private CrossPatternModel crossPatternModel = new CrossPatternModel(null);
    private RectanglePatternModel rectanglePatternModel = new RectanglePatternModel(null);

    public FieldPatternModel(Object object) {
        super(object);
        this.fillPatternModel = new FillPatternModel(null);
        this.registerSubModel(this.pointingPatternModel);
        this.registerSubModel(this.crossPatternModel);
        this.registerSubModel(this.rectanglePatternModel);
        this.registerSubModel(this.fillPatternModel);
        this.setupScanVelocityUpdater();
    }

    public FieldPattern getFieldPattern() {
        return (FieldPattern)this.getDocument();
    }

    public FieldSource getFieldSource() {
        FieldPattern fieldPattern = this.getFieldPattern();
        return fieldPattern == null ? null : (FieldSource)fieldPattern.getParent();
    }

    private void setupScanVelocityUpdater() {
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            if (model == this.rectanglePatternModel) {
                if (fieldID == RectanglePatternEditor.FID_SCAN_DIRECTION) {
                    this.updateScanVelocityField();
                }
            } else {
                this.updateScanVelocityField();
            }
        };
        this.rectanglePatternModel.subscribe(modelChangeSubscriber);
        this.rectanglePatternModel.getLatitudeLengthModel().subscribe(modelChangeSubscriber);
        this.rectanglePatternModel.getLongitudeLengthModel().subscribe(modelChangeSubscriber);
    }

    public void updateScanVelocityField() {
        this.rectanglePatternModel.updateScanVelocityField();
    }

    @Override
    public void publish() {
        FieldPattern fieldPattern = this.getFieldPattern();
        if (fieldPattern != null) {
            this.publish(FieldPatternEditor.FIELDPATTERNTYPELIST_FID, (Object)fieldPattern.getFieldPatternType());
            if (fieldPattern.isPointingPattern()) {
                PointingPattern pointingPattern = (PointingPattern)((Object)fieldPattern);
                this.publish(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR, pointingPattern.isOffsetPointingPattern());
                this.publish(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID, pointingPattern.getIsMosaic());
                this.pointingPatternModel.publish();
            }
            if (fieldPattern.isCrossPattern()) {
                this.crossPatternModel.publish();
            }
            if (fieldPattern.isRectanglePattern()) {
                this.rectanglePatternModel.publish();
            }
            if (fieldPattern.isFillPattern()) {
                this.fillPatternModel.publish();
            }
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(FieldPatternEditor.FIELDPATTERNTYPELIST_FID)) {
            FieldPattern.FieldPatternType fieldPatternType = FieldPattern.FieldPatternType.getFieldPatternType((String)object);
            this.changeFieldType(fieldPatternType);
            return fieldPatternType;
        }
        if (fieldID.equals(FieldPatternEditor.REVERT_FID)) {
            this.revertToRectangle();
            return null;
        }
        return null;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        FieldPattern fieldPattern = this.getFieldPattern();
        this.rectanglePatternModel.setonlyDocument(null);
        this.crossPatternModel.setonlyDocument(null);
        this.pointingPatternModel.setOnlyDocumentAndResetPointingsDisplayedToPrimaryArray(null, Optional.empty());
        this.fillPatternModel.setonlyDocument(null);
        if (fieldPattern == null) {
            return;
        }
        if (fieldPattern.isRectanglePattern()) {
            this.rectanglePatternModel.setonlyDocument(fieldPattern);
        } else if (fieldPattern.isCrossPattern()) {
            this.crossPatternModel.setonlyDocument(fieldPattern);
        } else if (fieldPattern.isPointingPattern()) {
            Optional<Antenna> optional = Optional.empty();
            BusinessObject businessObject = fieldPattern.getParent();
            if (businessObject instanceof SchedBlock) {
                SchedBlock schedBlock = (SchedBlock)businessObject;
                boolean bl = schedBlock.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.SEVEN_M.toString());
                optional = Optional.of(bl ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M);
            }
            this.pointingPatternModel.setOnlyDocumentAndResetPointingsDisplayedToPrimaryArray(fieldPattern, optional);
        } else if (fieldPattern.isFillPattern()) {
            this.fillPatternModel.setonlyDocument(fieldPattern);
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public void convertRectangleToPointings() {
        RectanglePattern rectanglePattern;
        FieldSource fieldSource = this.getFieldSource();
        try {
            rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        }
        catch (ClassCastException classCastException) {
            Log.logger((Object)this).warning("Unexpected FieldPattern detected : " + String.valueOf(fieldSource.getFieldPattern()));
            return;
        }
        RectangleMosaic rectangleMosaic = new RectangleMosaic(rectanglePattern);
        PointingPattern pointingPattern = rectangleMosaic.getPointingPattern();
        if (pointingPattern != null) {
            fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            this.fieldPatternChange(FieldPattern.FieldPatternType.POINT);
            this.setDocument(pointingPattern);
            this.publish(FieldPatternEditor.FIELDPATTERNTYPELIST_FID, fieldSource.getFieldPatternType());
            this.publish(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR, pointingPattern.isOffsetPointingPattern());
            this.publish(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID, pointingPattern.isMosaic());
        }
    }

    public RectanglePattern revertToRectangle() {
        FieldSource fieldSource = this.getFieldSource();
        if (!(fieldSource.getFieldPattern() instanceof PointingPattern)) {
            return null;
        }
        if (fieldSource.getOldFieldPattern() instanceof RectanglePattern) {
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getOldFieldPattern());
            fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
            this.fieldPatternChange(FieldPattern.FieldPatternType.RECTANGLE);
            this.setDocument(rectanglePattern);
            this.publish(FieldPatternEditor.FIELDPATTERNTYPELIST_FID, fieldSource.getFieldPatternType());
            return rectanglePattern;
        }
        return null;
    }

    public void changeFieldType(FieldPattern.FieldPatternType fieldPatternType) {
        FieldPattern fieldPattern = this.getFieldPattern();
        if (fieldPattern == null || !fieldPattern.getFieldPatternType().equals((Object)fieldPatternType)) {
            FieldPattern fieldPattern2 = FieldPattern.createFieldPattern(fieldPatternType);
            this.getFieldSource().setFieldPattern(fieldPattern2);
            if (fieldPattern2 == null) {
                return;
            }
            if (fieldPattern2.isPointingPattern()) {
                this.publish(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR, fieldPattern2.isOffsetPointingPattern());
            }
            this.publish(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID, fieldPattern2.isMosaic());
            this.setDocument(fieldPattern2);
            this.fieldPatternChange(fieldPatternType);
        }
    }

    public void updateBeamsizeFields() {
        Frequency frequency;
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource != null && (frequency = fieldSource.getSingleFrequency()) != null) {
            this.publish(FieldPatternEditor.BEAMSIZE_LABEL_FID, (Object)frequency);
            this.publish(FieldPatternEditor.BEAMSIZE_INFO_FID, (Object)frequency);
        }
    }

    private void fieldPatternChange(FieldPattern.FieldPatternType fieldPatternType) {
        for (FieldPatternChangeListener fieldPatternChangeListener : this.listeners) {
            fieldPatternChangeListener.fieldPatternChanged(fieldPatternType);
        }
    }

    public void addFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        this.listeners.add(fieldPatternChangeListener);
    }

    public boolean removeFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        return this.listeners.remove(fieldPatternChangeListener);
    }

    public FillPatternModel getFillPatternModel() {
        return this.fillPatternModel;
    }

    public PointingPatternModel getPointingPatternModel() {
        return this.pointingPatternModel;
    }

    public CrossPatternModel getCrossPatternModel() {
        return this.crossPatternModel;
    }

    public RectanglePatternModel getRectanglePatternModel() {
        return this.rectanglePatternModel;
    }
}

