/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.schedblock.RectanglePatternEditor;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameterModel;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import lombok.NonNull;

public class RectanglePatternModel
extends Model {
    private final Log.Logger logger = Log.logger((Object)this);
    private CoordsModel patternCenterCoordsModel = null;
    private ValueUnitPairModel latitudeLengthModel = null;
    private ValueUnitPairModel orthogonalStepModel = null;
    private ValueUnitPairModel longitudeLengthModel = null;
    private ValueUnitPairModel orientationModel = null;
    private MosaicParameterModel mosaicParameterModel = null;
    private final ModelChangeSubscriber samplesPerBeamUpdater = (model, fieldID, object) -> {
        this.publishSamplesPerBeam();
        this.publishScansPerMap();
    };

    public RectanglePatternModel(Object object2) {
        super(object2);
        this.patternCenterCoordsModel = new CoordsModel(null);
        this.latitudeLengthModel = new ValueUnitPairModel(null);
        this.orthogonalStepModel = new ValueUnitPairModel(null);
        this.longitudeLengthModel = new ValueUnitPairModel(null);
        this.orientationModel = new ValueUnitPairModel(null);
        this.mosaicParameterModel = new MosaicParameterModel(null);
        this.registerSubModel(this.patternCenterCoordsModel);
        this.registerSubModel(this.latitudeLengthModel);
        this.registerSubModel(this.orthogonalStepModel);
        this.registerSubModel(this.longitudeLengthModel);
        this.registerSubModel(this.orientationModel);
        if (object2 != null) {
            this.setDocument(object2);
        }
        this.latitudeLengthModel.subscribe(this.samplesPerBeamUpdater);
        this.longitudeLengthModel.subscribe(this.samplesPerBeamUpdater);
        this.orthogonalStepModel.subscribe(this.samplesPerBeamUpdater);
    }

    public RectanglePattern getRectanglePattern() {
        return (RectanglePattern)this.document;
    }

    @Override
    public void publish() {
        this.getPatternCenterCoordsModel().publish();
        this.getLatitudeLengthModel().publish();
        this.getOrthogonalStepModel().publish();
        this.getLongitudeLengthModel().publish();
        this.getOrientationModel().publish();
        RectanglePattern rectanglePattern = this.getRectanglePattern();
        if (rectanglePattern != null) {
            this.publish(RectanglePatternEditor.FID_SCAN_DIRECTION, rectanglePattern.getScanDirection());
            this.publish(RectanglePatternEditor.FID_SCAN_COORD_SYSTEM, rectanglePattern.getScanningCoordinateSystem());
            this.publish(RectanglePatternEditor.FID_UNIDIRECTIONAL_SCAN, rectanglePattern.getUniDirectionalScan());
            this.publish(RectanglePatternEditor.FID_SCAN_VELOCITY, (Object)rectanglePattern.getScanVelocity());
            this.publishSamplesPerBeam();
            this.publishScansPerMap();
        }
    }

    private void publishScansPerMap() {
        RectanglePattern rectanglePattern = this.getRectanglePattern();
        if (rectanglePattern != null) {
            this.publish(RectanglePatternEditor.FID_SCANS_PER_MAP, rectanglePattern.getRowCount());
        }
    }

    public void publishSamplesPerBeam() {
        if (this.getDocument() == null) {
            return;
        }
        try {
            this.publish(RectanglePatternEditor.FID_SAMPLES_PER_BEAM_LATITUDE, RectanglePatternModel.calculateSamplesPerBeam((RectanglePattern)this.getDocument(), this.getLatitudeLengthModel().getVUP().getContentInUnits(Angle.UNIT_ARCSEC), this.getLongitudeLengthModel().getVUP().getContentInUnits(Angle.UNIT_ARCSEC), Axis.LATITUDE));
            this.publish(RectanglePatternEditor.FID_SAMPLES_PER_BEAM_LONGITUDE, RectanglePatternModel.calculateSamplesPerBeam((RectanglePattern)this.getDocument(), this.getLatitudeLengthModel().getVUP().getContentInUnits(Angle.UNIT_ARCSEC), this.getLongitudeLengthModel().getVUP().getContentInUnits(Angle.UNIT_ARCSEC), Axis.LONGITUDE));
        }
        catch (UnableToCalculateSamplesPerBeamException unableToCalculateSamplesPerBeamException) {
            this.publish(RectanglePatternEditor.FID_SAMPLES_PER_BEAM_LATITUDE, "Unable to calculate");
            this.publish(RectanglePatternEditor.FID_SAMPLES_PER_BEAM_LONGITUDE, "Unable to calculate");
            this.logger.info("Unable to calculate the number of samples per beam : " + unableToCalculateSamplesPerBeamException.getMessage());
        }
    }

    public static double calculateSamplesPerBeam(@NonNull RectanglePattern rectanglePattern, @NonNull Double d, @NonNull Double d2, @NonNull Axis axis) throws UnableToCalculateSamplesPerBeamException {
        SpectralSpecDocument spectralSpecDocument2;
        boolean bl;
        if (rectanglePattern == null) {
            throw new NullPointerException("rectanglePattern is marked non-null but is null");
        }
        if (d == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (axis == null) {
            throw new NullPointerException("axis is marked non-null but is null");
        }
        if (!(rectanglePattern instanceof RectanglePattern)) {
            throw new IllegalArgumentException("rectanglePattern is not of type RectanglePattern");
        }
        double d3 = 0.0;
        Double d4 = null;
        if (RectanglePattern.SCANDIRECTION_LATITUDE.equals(rectanglePattern.getScanDirection())) {
            bl = axis.equals((Object)Axis.LATITUDE);
            d4 = d;
        } else {
            bl = axis.equals((Object)Axis.LONGITUDE);
            d4 = d2;
        }
        Log.logger(RectanglePatternModel.class).fine("L: " + d4);
        assert (d4 != null);
        int n = 0;
        Target target = null;
        for (SpectralSpecDocument spectralSpecDocument2 : rectanglePattern.getAssociatedTargets()) {
            if (!((Target)spectralSpecDocument2).hasScienceParameters()) continue;
            ++n;
            target = spectralSpecDocument2;
        }
        if (n == 0) {
            throw new UnableToCalculateSamplesPerBeamException("Unable to find a science target which is associated with the field source");
        }
        if (n > 1) {
            throw new UnableToCalculateSamplesPerBeamException("More than a single science target is associated with the field source");
        }
        if (rectanglePattern.getParent().getParent() instanceof Target) {
            target = (Target)rectanglePattern.getParent().getParent();
        }
        assert (target != null);
        if (!target.hasScienceParameters()) {
            throw new UnableToCalculateSamplesPerBeamException("Unable to determine science parameters when calculating the number of samples per beam");
        }
        Object object = null;
        spectralSpecDocument2 = target.getSpectralSpec();
        if (spectralSpecDocument2 == null) {
            throw new UnableToCalculateSamplesPerBeamException("No spectral spec found in the target");
        }
        try {
            object = ((SpectralSpec)spectralSpecDocument2).getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new UnableToCalculateSamplesPerBeamException(incompleteCorrelatorSetupFoundException);
        }
        assert (object != null);
        Log.logger(RectanglePatternModel.class).fine("highestSPWCentralFrequency: " + String.valueOf(object));
        UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, object);
        Log.logger(RectanglePatternModel.class).fine("hpbwAngle: " + String.valueOf(userAngle));
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        double d5 = userAngle.getContentInUnits(Angle.UNIT_ARCSEC) * 1.0;
        assert (d5 > 0.0);
        Log.logger(RectanglePatternModel.class).fine("hpbw_12_scaled: " + d5);
        if (bl) {
            ScienceParameters scienceParameters = target.getScienceParametersList()[0];
            assert (scienceParameters != null);
            double d6 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_MS);
            assert (d6 > 0.0);
            double d7 = spectralSpecDocument2.getAbstractCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
            assert (d4 != null);
            assert (d7 > 0.0);
            assert (d6 > 0.0);
            d3 = d6 * d5 / d4 / d7;
        } else {
            d3 = d5 / rectanglePattern.getOrthogonalStep().getContentInUnits(Angle.UNIT_ARCSEC);
        }
        Log.logger(RectanglePatternModel.class).fine("samplesPerBeam: " + d3);
        assert (d3 > 0.0);
        return d3;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(RectanglePatternEditor.FID_SCAN_DIRECTION)) {
            String string = (String)object;
            this.getRectanglePattern().setScanDirection(string);
            this.publishSamplesPerBeam();
            return string;
        }
        if (fieldID.equals(RectanglePatternEditor.FID_CONVERT)) {
            return object;
        }
        if (fieldID.equals(RectanglePatternEditor.FID_SCAN_COORD_SYSTEM)) {
            String string = (String)object;
            this.getRectanglePattern().setScanningCoordinateSystem(string);
            return string;
        }
        if (fieldID.equals(RectanglePatternEditor.FID_UNIDIRECTIONAL_SCAN)) {
            Boolean bl = (Boolean)object;
            this.getRectanglePattern().setUniDirectionalScan(bl);
            return object;
        }
        return object;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        RectanglePattern rectanglePattern = this.getRectanglePattern();
        if (rectanglePattern == null) {
            return;
        }
        this.getPatternCenterCoordsModel().setonlyDocument(rectanglePattern);
        Angle angle = rectanglePattern.getLatitudeLength();
        this.getLatitudeLengthModel().setonlyDocument((Object)angle);
        angle = rectanglePattern.getOrthogonalStep();
        this.getOrthogonalStepModel().setonlyDocument((Object)angle);
        angle = rectanglePattern.getLongitudeLength();
        this.getLongitudeLengthModel().setonlyDocument((Object)angle);
        angle = rectanglePattern.getOrientation();
        this.getOrientationModel().setonlyDocument((Object)angle);
        this.getMosaicParameterModel().setonlyDocument(rectanglePattern.getMosaicParameters());
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    protected void updateScanVelocityField() {
        RectanglePattern rectanglePattern = this.getRectanglePattern();
        if (rectanglePattern != null) {
            this.publish(RectanglePatternEditor.FID_SCAN_VELOCITY, (Object)rectanglePattern.getScanVelocity());
        }
    }

    public CoordsModel getPatternCenterCoordsModel() {
        return this.patternCenterCoordsModel;
    }

    public ValueUnitPairModel getLatitudeLengthModel() {
        return this.latitudeLengthModel;
    }

    public ValueUnitPairModel getOrthogonalStepModel() {
        return this.orthogonalStepModel;
    }

    public ValueUnitPairModel getLongitudeLengthModel() {
        return this.longitudeLengthModel;
    }

    public ValueUnitPairModel getOrientationModel() {
        return this.orientationModel;
    }

    public MosaicParameterModel getMosaicParameterModel() {
        return this.mosaicParameterModel;
    }

    public static enum Axis {
        LONGITUDE,
        LATITUDE;

    }

    public static class UnableToCalculateSamplesPerBeamException
    extends Exception {
        private static final long serialVersionUID = -9018603670698240084L;

        public UnableToCalculateSamplesPerBeamException(SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            super(incompleteCorrelatorSetupFoundException);
        }

        public UnableToCalculateSamplesPerBeamException(String string) {
            super(string);
        }
    }
}

