/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.UnitException;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.annotations.ACASpectralWindowI;
import alma.obsprep.bo.annotations.BLSpectralWindowI;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import alma.obsprep.bo.schedblock.UnknownScalingFactorException;
import alma.obsprep.bo.schedblock.data.ACASpectralWindowData;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.editors.schedblock.SpectralWindowEditor;
import alma.obsprep.ot.models.schedblock.ChannelAverageRegionModel;
import alma.obsprep.ot.models.schedblock.DataRateUpdaterInterface;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;

public class SpectralWindowModel
extends Model
implements DataRateUpdaterInterface {
    private ValueUnitPairModel centerFreqModel = null;
    private ValueUnitPairModel desiredCenterFreqModel = null;
    private ChannelAverageRegionModel channelAverageRegionModel = null;
    private final ValueUnitPairParser vupParser = new ValueUnitPairParser();

    public SpectralWindowModel(Object object) {
        super(object);
        this.centerFreqModel = new ValueUnitPairModel(null, SpectralWindowEditor.CENTERFREQ_VALUE_FID, SpectralWindowEditor.CENTERFREQ_UNIT_FID){

            @Override
            public Object update(Editor editor, FieldID fieldID, Object object) {
                Object object2;
                if (fieldID.equals(this.getValueFID())) {
                    super.update(editor, fieldID, object);
                    object2 = this.formatContent();
                } else {
                    object2 = super.update(editor, fieldID, object);
                    this.publish(this.getValueFID(), this.formatContent());
                }
                SpectralWindowModel.this.getMySpectralWindowModel().publish();
                return object2;
            }

            @Override
            public void publish() {
                ValueUnitPair valueUnitPair = (ValueUnitPair)this.getDocument();
                if (valueUnitPair == null) {
                    return;
                }
                Frequency frequency = (Frequency)valueUnitPair;
                this.publish(this.getValueFID(), this.formatContent());
                this.publish(this.getUnitFID(), frequency.getUnit());
            }

            private String formatContent() {
                double d;
                ValueUnitPair valueUnitPair = (ValueUnitPair)this.getDocument();
                Frequency frequency = (Frequency)valueUnitPair;
                String string = frequency.getUnit();
                int n = 12;
                UnitMap unitMap = valueUnitPair.unitMap();
                try {
                    d = unitMap.getConversionFactor(string, Frequency.UNIT_MHZ);
                    long l = Math.round(Math.log10(d));
                    n = (int)((long)n + l);
                }
                catch (UnitException unitException) {
                    // empty catch block
                }
                d = frequency.getContent();
                String string2 = "%4." + n + "f";
                return String.format(string2, d);
            }
        };
        this.desiredCenterFreqModel = new ValueUnitPairModel(null, SpectralWindowEditor.DESIREDCENTERFREQ_VALUE_FID, SpectralWindowEditor.DESIREDCENTERFREQ_UNIT_FID){

            @Override
            public Object update(Editor editor, FieldID fieldID, Object object) {
                Object object2;
                if (fieldID.equals(this.getValueFID())) {
                    super.update(editor, fieldID, object);
                    object2 = this.formatContent();
                } else {
                    object2 = super.update(editor, fieldID, object);
                    this.publish(this.getValueFID(), this.formatContent());
                }
                SpectralWindowModel.this.getMySpectralWindowModel().publish();
                return object2;
            }

            @Override
            public void publish() {
                ValueUnitPair valueUnitPair = (ValueUnitPair)this.getDocument();
                if (valueUnitPair == null) {
                    return;
                }
                Frequency frequency = (Frequency)valueUnitPair;
                this.publish(this.getValueFID(), this.formatContent());
                this.publish(this.getUnitFID(), frequency.getUnit());
            }

            private String formatContent() {
                double d;
                ValueUnitPair valueUnitPair = (ValueUnitPair)this.getDocument();
                Frequency frequency = (Frequency)valueUnitPair;
                String string = frequency.getUnit();
                int n = 12;
                UnitMap unitMap = valueUnitPair.unitMap();
                try {
                    d = unitMap.getConversionFactor(string, Frequency.UNIT_MHZ);
                    long l = Math.round(Math.log10(d));
                    n = (int)((long)n + l);
                }
                catch (UnitException unitException) {
                    // empty catch block
                }
                d = frequency.getContent();
                String string2 = "%4." + n + "f";
                String string3 = String.format(string2, d);
                return string3;
            }
        };
        this.channelAverageRegionModel = new ChannelAverageRegionModel(null);
        this.channelAverageRegionModel.setDataRateUpdater(this);
    }

    private SpectralWindowModel getMySpectralWindowModel() {
        return this;
    }

    public SpectralWindowI getSpectralWindow() {
        return (SpectralWindowI)this.getDocument();
    }

    private BLSpectralWindowI getBLSpectralWindow() {
        try {
            return (BLSpectralWindowI)this.getDocument();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private ACASpectralWindowI getACASpectralWindow() {
        try {
            return (ACASpectralWindowI)this.getDocument();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public void publish() {
        this.publish(SpectralWindowEditor.DOCUMENTLABEL_FID, this.getDocument());
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        if (spectralWindowI != null) {
            Object object;
            this.getCenterFreqModel().publish();
            if (this.getDesiredCenterFreqModel() != null) {
                this.getDesiredCenterFreqModel().publish();
            }
            this.publish(SpectralWindowEditor.NAME_FID, spectralWindowI.getSpectralWindowName());
            this.publish(SpectralWindowEditor.OMEGA_IF2_FID, (Object)spectralWindowI.getOmegaIF2());
            this.publish(SpectralWindowEditor.LSB_FREQREST_FID, (Object)spectralWindowI.getRestFrequencyLSB());
            this.publish(SpectralWindowEditor.USB_FREQREST_FID, (Object)spectralWindowI.getRestFrequencyUSB());
            this.publish(SpectralWindowEditor.LSB_FREQSKY_FID, (Object)spectralWindowI.getSkyFrequencyLSB());
            this.publish(SpectralWindowEditor.USB_FREQSKY_FID, (Object)spectralWindowI.getSkyFrequencyUSB());
            this.publish(SpectralWindowEditor.USE_LSB_FID, spectralWindowI.getSideBandUse().usesLSB());
            this.publish(SpectralWindowEditor.USE_USB_FID, spectralWindowI.getSideBandUse().usesUSB());
            this.publish(SpectralWindowEditor.NOM_BANDWIDTH_FID, (Object)spectralWindowI.getNominalBandwidth());
            this.publish(SpectralWindowEditor.NOM_CHANNELS_FID, spectralWindowI.getNominalNumberOfChannels());
            this.publish(SpectralWindowEditor.EFF_BANDWIDTH_FID, (Object)spectralWindowI.getEffectiveBandwidth());
            this.publish(SpectralWindowEditor.EFF_CHANNELS_FID, spectralWindowI.getEffectiveNumberOfChannels());
            this.publish(SpectralWindowEditor.ACA_EFF_BW_FID, spectralWindowI.getEffectiveBandwidth().getContentInMHz());
            this.publish(SpectralWindowEditor.ACA_EFF_CHANNELS_FID, spectralWindowI.getEffectiveNumberOfChannels());
            this.publish(SpectralWindowEditor.RESOLUTION_FID, (Object)spectralWindowI.getResolution());
            try {
                object = spectralWindowI.getEffectiveResolution();
                this.publish(SpectralWindowEditor.EFF_RESOLUTION_FID, object);
                this.publish(SpectralWindowEditor.EFF_RESOLUTION_ERR, null);
            }
            catch (UnknownScalingFactorException unknownScalingFactorException) {
                this.publish(SpectralWindowEditor.EFF_RESOLUTION_FID, (Object)spectralWindowI.getResolution());
                this.publish(SpectralWindowEditor.EFF_RESOLUTION_ERR, unknownScalingFactorException.getMessage());
            }
            this.publish(SpectralWindowEditor.POLNPRODUCTS_FID, spectralWindowI.getPolnProducts());
            if (spectralWindowI.isPair()) {
                object = (SpectralWindowPair)spectralWindowI;
                this.publish(SpectralWindowEditor.AVGFACTOR_LSB_FID, ((SpectralWindowPair)object).getSpectralAveragingFactorLSB());
                this.publish(SpectralWindowEditor.AVGFACTOR_USB_FID, ((SpectralWindowPair)object).getSpectralAveragingFactorUSB());
                this.publish(SpectralWindowEditor.AVGFACTOR_BL_LSB_FID, ((SpectralWindowPair)object).getSpectralAveragingFactorLSB());
                this.publish(SpectralWindowEditor.AVGFACTOR_BL_USB_FID, ((SpectralWindowPair)object).getSpectralAveragingFactorUSB());
            } else {
                this.publish(SpectralWindowEditor.AVGFACTOR_FID, spectralWindowI.getSpectralAveragingFactor());
                this.publish(SpectralWindowEditor.AVGFACTOR_BL_FID, spectralWindowI.getSpectralAveragingFactor());
            }
            this.publish(SpectralWindowEditor.WINDOWFUNCTION_FID, spectralWindowI.getWindowFunction());
            try {
                object = (BLSpectralWindowI)spectralWindowI;
                this.publish(SpectralWindowEditor.CONFIGMODE_FID, object.getCorrConfigMode().getMode());
                this.publish(SpectralWindowEditor.FILTERMODE_FID, object.getFilterMode());
                this.publish(SpectralWindowEditor.CORRELATIONBITS_FID, object.getCorrelationBits());
                this.publish(SpectralWindowEditor.OVERSAMPLING_FID, object.getCorrelationNyquistOversampling());
                this.publish(SpectralWindowEditor.QUANTCORRECTION_FID, object.getQuantizationCorrection());
            }
            catch (ClassCastException classCastException) {
                try {
                    ACASpectralWindowI aCASpectralWindowI = (ACASpectralWindowI)spectralWindowI;
                    this.publish(SpectralWindowEditor.SYNTHPROF_FID, aCASpectralWindowI.getSynthProf());
                    this.publish(SpectralWindowEditor.FRQCHPROFREPROD_FID, aCASpectralWindowI.getFrqChProfReproduction());
                }
                catch (ClassCastException classCastException2) {
                    // empty catch block
                }
            }
            this.channelAverageRegionModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(SpectralWindowEditor.AVGFACTOR_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_BL_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_LSB_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_BL_LSB_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_USB_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_BL_USB_FID)) {
            Integer n;
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (fieldID.equals(SpectralWindowEditor.AVGFACTOR_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_BL_FID)) {
                this.getSpectralWindow().setSpectralAveragingFactor(n);
            } else {
                SpectralWindowPair spectralWindowPair = (SpectralWindowPair)this.getSpectralWindow();
                if (fieldID.equals(SpectralWindowEditor.AVGFACTOR_LSB_FID) || fieldID.equals(SpectralWindowEditor.AVGFACTOR_BL_LSB_FID)) {
                    spectralWindowPair.setSpectralAveragingFactorLSB(n);
                } else {
                    spectralWindowPair.setSpectralAveragingFactorUSB(n);
                }
            }
            return n;
        }
        if (fieldID.equals(SpectralWindowEditor.NAME_FID)) {
            return object;
        }
        if (fieldID.equals(SpectralWindowEditor.CONFIGMODE_FID)) {
            return object;
        }
        if (fieldID.equals(SpectralWindowEditor.CF_ADJUST_BUTTON_FID)) {
            SpectralWindowI spectralWindowI = this.getSpectralWindow();
            spectralWindowI.adjustCenterFrequency();
            this.publish();
            return null;
        }
        if (fieldID.equals(SpectralWindowEditor.NOM_BANDWIDTH_FID)) {
            Frequency frequency;
            String string = TextUtils.stripHtmlTags((String)object);
            try {
                frequency = (Frequency)this.vupParser.parse(string, Frequency.class);
                SpectralWindowI spectralWindowI = this.getSpectralWindow();
                int n = spectralWindowI.getNominalNumberOfChannels();
                spectralWindowI.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.NOMINAL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                frequency = Frequency.createFrequency();
            }
            this.updateConfigModeValue();
            this.updateCenterFrequencyDisplay();
            return frequency;
        }
        if (fieldID.equals(SpectralWindowEditor.NOM_CHANNELS_FID)) {
            Integer n;
            try {
                n = Integer.parseInt(TextUtils.stripHtmlTags((String)object));
                SpectralWindowI spectralWindowI = this.getSpectralWindow();
                Frequency frequency = spectralWindowI.getNominalBandwidth();
                spectralWindowI.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.NOMINAL);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            this.updateConfigModeValue();
            this.updateCenterFrequencyDisplay();
            return n;
        }
        if (fieldID.equals(SpectralWindowEditor.ACA_EFF_BW_FID)) {
            Double d;
            try {
                d = Double.parseDouble((String)object);
                SpectralWindowI spectralWindowI = this.getSpectralWindow();
                int n = spectralWindowI.getEffectiveNumberOfChannels();
                Frequency frequency = spectralWindowI.getEffectiveBandwidth();
                frequency.setContentInMHz(d);
                spectralWindowI.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.EFFECTIVE);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            this.updateConfigModeValue();
            this.updateCenterFrequencyDisplay();
            return d;
        }
        if (fieldID.equals(SpectralWindowEditor.ACA_EFF_CHANNELS_FID)) {
            Integer n;
            try {
                n = Integer.parseInt((String)object);
                SpectralWindowI spectralWindowI = this.getSpectralWindow();
                Frequency frequency = spectralWindowI.getEffectiveBandwidth();
                spectralWindowI.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.EFFECTIVE);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            this.updateConfigModeValue();
            this.updateCenterFrequencyDisplay();
            return n;
        }
        if (fieldID.equals(SpectralWindowEditor.POLNPRODUCTS_FID)) {
            SpectralWindowI spectralWindowI = this.getSpectralWindow();
            String string = (String)object;
            if (spectralWindowI != null) {
                spectralWindowI.setPolnProducts(string);
            }
            this.updateConfigModeValue();
            return string;
        }
        if (fieldID.equals(SpectralWindowEditor.USE_LSB_FID)) {
            SideBandUse sideBandUse;
            boolean bl = (Boolean)object;
            SpectralWindowI spectralWindowI = this.getSpectralWindow();
            boolean bl2 = spectralWindowI.changeSideBandUse(sideBandUse = spectralWindowI.getSideBandUse().enableLSB(bl));
            if (bl2) {
                return bl;
            }
            return !bl;
        }
        if (fieldID.equals(SpectralWindowEditor.USE_USB_FID)) {
            SideBandUse sideBandUse;
            boolean bl = (Boolean)object;
            SpectralWindowI spectralWindowI = this.getSpectralWindow();
            boolean bl3 = spectralWindowI.changeSideBandUse(sideBandUse = spectralWindowI.getSideBandUse().enableUSB(bl));
            if (bl3) {
                return bl;
            }
            return !bl;
        }
        if (fieldID.equals(SpectralWindowEditor.WINDOWFUNCTION_FID)) {
            String string = (String)object;
            this.getSpectralWindow().setWindowFunction(string);
            return string;
        }
        if (fieldID.equals(SpectralWindowEditor.CORRELATIONBITS_FID)) {
            BLSpectralWindowI bLSpectralWindowI = this.getBLSpectralWindow();
            String string = (String)object;
            if (bLSpectralWindowI != null) {
                bLSpectralWindowI.setCorrelationBits(string);
            }
            this.updateConfigModeValue();
            this.updateDataRates();
            return string;
        }
        if (fieldID.equals(SpectralWindowEditor.OVERSAMPLING_FID)) {
            BLSpectralWindowI bLSpectralWindowI = this.getBLSpectralWindow();
            Boolean bl = (Boolean)object;
            if (bLSpectralWindowI != null) {
                bLSpectralWindowI.setCorrelationNyquistOversampling(bl);
            }
            this.updateConfigModeValue();
            this.updateDataRates();
            return bl;
        }
        if (fieldID.equals(SpectralWindowEditor.QUANTCORRECTION_FID)) {
            BLSpectralWindowI bLSpectralWindowI = this.getBLSpectralWindow();
            Boolean bl = (Boolean)object;
            if (bLSpectralWindowI != null) {
                bLSpectralWindowI.setQuantizationCorrection(bl);
            }
            return bl;
        }
        if (fieldID.equals(SpectralWindowEditor.SYNTHPROF_FID)) {
            ACASpectralWindowI aCASpectralWindowI = this.getACASpectralWindow();
            String string = (String)object;
            if (aCASpectralWindowI != null) {
                boolean bl;
                if (ACASpectralWindowData.SYNTHPROF_NOSYNTH.equals(string)) {
                    bl = false;
                } else if (ACASpectralWindowData.SYNTHPROF_ACACORR.equals(string)) {
                    bl = true;
                } else if (ACASpectralWindowData.SYNTHPROF_ACA_CDP.equals(string)) {
                    bl = true;
                } else {
                    throw new IllegalArgumentException("Unexpected value for SYNTHPROF_FID: " + string);
                }
                aCASpectralWindowI.setSynthProf(string);
                aCASpectralWindowI.setFrqChProfReproduction(bl);
                CorrConfigMode corrConfigMode = aCASpectralWindowI.getCorrConfigMode();
                if (bl) {
                    if (ACASpectralWindowData.SYNTHPROF_ACA_CDP.equals(string)) {
                        aCASpectralWindowI.setBandParameters(corrConfigMode.getNominalBandwidth(), corrConfigMode.getNominalChannels(), SpectralWindowBand.ChannelType.NOMINAL);
                    } else {
                        aCASpectralWindowI.setBandParameters(corrConfigMode.getEffectiveBandwidth(bl), corrConfigMode.getEffectiveChannels(bl), SpectralWindowBand.ChannelType.EFFECTIVE);
                    }
                } else {
                    aCASpectralWindowI.setBandParameters(corrConfigMode.getNominalBandwidth(), corrConfigMode.getNominalChannels(), SpectralWindowBand.ChannelType.NOMINAL);
                }
                if (ACASpectralWindowData.SYNTHPROF_ACA_CDP.equals(string)) {
                    this.publish(SpectralWindowEditor.EFF_BANDWIDTH_FID, (Object)aCASpectralWindowI.getNominalBandwidth());
                    this.publish(SpectralWindowEditor.EFF_CHANNELS_FID, aCASpectralWindowI.getNominalNumberOfChannels());
                    this.publish(SpectralWindowEditor.ACA_EFF_BW_FID, (Object)aCASpectralWindowI.getNominalBandwidth());
                    this.publish(SpectralWindowEditor.ACA_EFF_CHANNELS_FID, aCASpectralWindowI.getNominalNumberOfChannels());
                } else {
                    this.publish(SpectralWindowEditor.EFF_BANDWIDTH_FID, (Object)aCASpectralWindowI.getEffectiveBandwidth());
                    this.publish(SpectralWindowEditor.EFF_CHANNELS_FID, aCASpectralWindowI.getEffectiveNumberOfChannels());
                    this.publish(SpectralWindowEditor.ACA_EFF_BW_FID, (Object)aCASpectralWindowI.getEffectiveBandwidth());
                    this.publish(SpectralWindowEditor.ACA_EFF_CHANNELS_FID, aCASpectralWindowI.getEffectiveNumberOfChannels());
                }
            }
            return string;
        }
        return null;
    }

    @Override
    public void updateDataRates() {
        Object object = this.getDocument();
        if (!BusinessObject.class.isAssignableFrom(object.getClass())) {
            return;
        }
        BusinessObject businessObject = (BusinessObject)object;
        try {
            businessObject = businessObject.getParent().getParent();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        assert (businessObject != null);
        if (businessObject instanceof BLCorrelatorConfiguration || businessObject instanceof ACACorrelatorConfiguration || businessObject instanceof ACASpectrometerCorrelatorConfiguration) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = (AbstractCorrelatorConfiguration)businessObject;
            abstractCorrelatorConfiguration.dataRateChanged();
        }
    }

    private void updateConfigModeValue() {
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        spectralWindowI.updateCorrConfigMode();
        this.publish(SpectralWindowEditor.CONFIGMODE_FID, spectralWindowI.getCorrConfigMode().getMode());
        this.publish(SpectralWindowEditor.NOM_BANDWIDTH_FID, (Object)spectralWindowI.getNominalBandwidth());
        this.publish(SpectralWindowEditor.NOM_CHANNELS_FID, spectralWindowI.getNominalNumberOfChannels());
        this.publish(SpectralWindowEditor.EFF_BANDWIDTH_FID, (Object)spectralWindowI.getEffectiveBandwidth());
        this.publish(SpectralWindowEditor.EFF_CHANNELS_FID, spectralWindowI.getEffectiveNumberOfChannels());
        this.publish(SpectralWindowEditor.ACA_EFF_BW_FID, spectralWindowI.getEffectiveBandwidth().getContentInMHz());
        this.publish(SpectralWindowEditor.ACA_EFF_CHANNELS_FID, spectralWindowI.getEffectiveNumberOfChannels());
        this.publish(SpectralWindowEditor.RESOLUTION_FID, (Object)spectralWindowI.getResolution());
        try {
            Frequency frequency = spectralWindowI.getEffectiveResolution();
            this.publish(SpectralWindowEditor.EFF_RESOLUTION_FID, (Object)frequency);
            this.publish(SpectralWindowEditor.EFF_RESOLUTION_ERR, null);
        }
        catch (UnknownScalingFactorException unknownScalingFactorException) {
            this.publish(SpectralWindowEditor.EFF_RESOLUTION_FID, (Object)spectralWindowI.getResolution());
            this.publish(SpectralWindowEditor.EFF_RESOLUTION_ERR, unknownScalingFactorException.getMessage());
        }
        this.publish(SpectralWindowEditor.FILTERMODE_FID, spectralWindowI.getFilterMode());
    }

    private void updateCenterFrequencyDisplay() {
        this.getCenterFreqModel().publish();
        if (this.getDesiredCenterFreqModel() != null) {
            this.getDesiredCenterFreqModel().publish();
        }
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        spectralWindowI.updateSpectralWindowBand();
        AbstractSpectralWindow abstractSpectralWindow = spectralWindowI.getSingleSpectralWindow();
        if (abstractSpectralWindow.gettrueDesiredCenterFrequency() != null) {
            this.getDesiredCenterFreqModel().setonlyDocument((Object)spectralWindowI.getDesiredCenterFrequency());
        } else {
            this.getDesiredCenterFreqModel().setonlyDocument(null);
        }
        this.getCenterFreqModel().setonlyDocument((Object)spectralWindowI.getCenterFrequency());
        this.publish();
        this.channelAverageRegionModel.setDocument(spectralWindowI);
    }

    public ValueUnitPairModel getCenterFreqModel() {
        return this.centerFreqModel;
    }

    public ValueUnitPairModel getDesiredCenterFreqModel() {
        return this.desiredCenterFreqModel;
    }

    public ChannelAverageRegionModel getChannelAverageRegionModel() {
        return this.channelAverageRegionModel;
    }
}

