/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.ot.editors.schedblock.observingparameters.BandpassCalParameterEditor;
import alma.obsprep.ot.models.schedblock.observingparameters.CalibratorParameterModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Time;

public class BandpassCalParameterModel
extends CalibratorParameterModel {
    private final ValueUnitPairModel desiredPhaseAccuracyModel = new ValueUnitPairModel(null, BandpassCalParameterEditor.FID_DESIREDPHASEACCURACY_VALUE, BandpassCalParameterEditor.FID_DESIREDPHASEACCURACY_UNIT);
    private final ValueUnitPairModel maximumElapsedTimeModel = new ValueUnitPairModel(null, BandpassCalParameterEditor.FID_MAXIMUMELAPSEDTIME_VALUE, BandpassCalParameterEditor.FID_MAXIMUMELAPSEDTIME_UNIT);

    public BandpassCalParameterModel(BandpassCalParameters bandpassCalParameters) {
        super((CalibratorParameters)((Object)bandpassCalParameters));
        this.registerSubModel(this.desiredPhaseAccuracyModel, this.maximumElapsedTimeModel);
        this.setDocument((Object)bandpassCalParameters);
    }

    public BandpassCalParameters getBandpassCalParameters() {
        return (BandpassCalParameters)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        super.publish();
        Object object = this.getDocument();
        if (object == null) {
            return;
        }
        if (this.desiredPhaseAccuracyModel != null) {
            this.desiredPhaseAccuracyModel.publish();
        }
        this.publish(BandpassCalParameterEditor.FID_DESIREDAMPLITUDEACCURACY, this.getBandpassCalParameters().getDesiredAmplitudeAccuracy());
        if (this.maximumElapsedTimeModel != null) {
            this.maximumElapsedTimeModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        object.toString();
        BandpassCalParameters bandpassCalParameters = this.getBandpassCalParameters();
        Object object2 = null;
        if (bandpassCalParameters != null) {
            if (fieldID.equals(BandpassCalParameterEditor.FID_DESIREDPHASEACCURACY_UNIT) || fieldID.equals(BandpassCalParameterEditor.FID_DESIREDPHASEACCURACY_VALUE)) {
                object2 = this.getDesiredPhaseAccuracyModel().update(editor, fieldID, object);
            } else if (fieldID.equals(BandpassCalParameterEditor.FID_MAXIMUMELAPSEDTIME_UNIT) || fieldID.equals(BandpassCalParameterEditor.FID_MAXIMUMELAPSEDTIME_VALUE)) {
                object2 = this.getMaximumElapsedTimeModel().update(editor, fieldID, object);
            } else {
                if (fieldID.equals(BandpassCalParameterEditor.FID_DESIREDAMPLITUDEACCURACY)) {
                    double d = 0.0;
                    try {
                        d = DoubleVerifier.parseDouble(object, 0.0, Double.MAX_VALUE);
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        // empty catch block
                    }
                    this.getBandpassCalParameters().setDesiredAmplitudeAccuracy(d);
                    return d;
                }
                object2 = super.update(editor, fieldID, object);
            }
        }
        return object2;
    }

    @Override
    public void setDocument(Object object) {
        if (object instanceof BandpassCalParameters) {
            BandpassCalParameters bandpassCalParameters = (BandpassCalParameters)((Object)object);
            if (this.desiredPhaseAccuracyModel != null) {
                this.desiredPhaseAccuracyModel.setDocument((Object)bandpassCalParameters.getDesiredPhaseAccuracy());
            }
            if (this.maximumElapsedTimeModel != null) {
                this.maximumElapsedTimeModel.setDocument(bandpassCalParameters.getMaximumElapsedTime());
            }
        }
        super.setDocument(object);
    }

    @Override
    Time getRepeatInterval() {
        return Time.createTime();
    }

    public ValueUnitPairModel getDesiredPhaseAccuracyModel() {
        return this.desiredPhaseAccuracyModel;
    }

    public ValueUnitPairModel getMaximumElapsedTimeModel() {
        return this.maximumElapsedTimeModel;
    }
}

