/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.FieldEditor;
import alma.obsprep.ot.models.obsproject.RectangleModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import java.util.Optional;

public class FieldModel
extends Model
implements ModelChangeSubscriber {
    protected PointingPatternModel pointingPatternModel = new PointingPatternModel(null);
    protected RectangleModel rectangleModel = new RectangleModel(null);

    public FieldModel(Object object) {
        super(object);
        this.registerSubModel(this.pointingPatternModel, this.rectangleModel);
        this.setDocument(object);
        this.pointingPatternModel.subscribe(this);
    }

    public TargetParameters getTargetParameters() {
        return (TargetParameters)this.getDocument();
    }

    public void originCoordinatesSystemUpdated(String string) {
        this.pointingPatternModel.originCoordinatesSystemUpdated();
        this.rectangleModel.setRectangleCoordinateSystem(string);
    }

    @Override
    public void publish() {
        if (this.document != null) {
            this.publish(FieldEditor.FID_DOCUMENTLABEL, this.getTargetParameters());
        }
        this.pointingPatternModel.publish();
        this.rectangleModel.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            TargetParameters targetParameters = this.getTargetParameters();
            if (targetParameters.isPointingPattern()) {
                Antenna antenna = targetParameters.getScienceGoal().isStandAloneACA() ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
                this.pointingPatternModel.setOnlyDocumentAndResetPointingsDisplayedToPrimaryArray(object, Optional.of(antenna));
                this.rectangleModel.setonlyDocument(null);
            } else if (targetParameters.isRectanglePattern()) {
                this.pointingPatternModel.setOnlyDocumentAndResetPointingsDisplayedToPrimaryArray(null, Optional.empty());
                this.rectangleModel.setonlyDocument(targetParameters.getSingleRectangle());
            }
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        this.publish(fieldID, object);
    }

    public PointingPatternModel getPointingPatternModel() {
        return this.pointingPatternModel;
    }

    public RectangleModel getRectangleModel() {
        return this.rectangleModel;
    }
}

