/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.obsproject.OpticalCameraControlParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;

public class OpticalCameraControlParametersModel
extends Model {
    private ValueUnitPairModel elevationLimitModel = new ValueUnitPairModel(null, FieldIDs.elevationLimitValueFID, FieldIDs.elevationLimitUnitsFID);
    private ValueUnitPairModel antennaPositionToleranceModel = new ValueUnitPairModel(null, FieldIDs.antennaPositionTorelanceValueFID, FieldIDs.antennaPositionTorelanceUnitsFID);
    private ValueUnitPairModel sBMaximumTimeModel = new ValueUnitPairModel(null, FieldIDs.sbMaximumTimeValueFID, FieldIDs.sbMaximumTimeUnitsFID);

    public OpticalCameraControlParametersModel(OpticalCameraControlParameters opticalCameraControlParameters) {
        super(null);
        this.setDocument((Object)opticalCameraControlParameters);
    }

    private OpticalCameraControlParameters getOpticalCameraControlParameters() {
        return (OpticalCameraControlParameters)((Object)this.getDocument());
    }

    public ValueUnitPairModel getSBMaximumTimeModel() {
        return this.sBMaximumTimeModel;
    }

    @Override
    public void publish() {
        OpticalCameraControlParameters opticalCameraControlParameters = this.getOpticalCameraControlParameters();
        if (opticalCameraControlParameters == null) {
            return;
        }
        this.getElevationLimitModel().publish();
        this.getAntennaPositionToleranceModel().publish();
        this.getSBMaximumTimeModel().publish();
        this.publish(FieldIDs.randomOrderFID, opticalCameraControlParameters.getRandomizeOrder());
        this.publish(FieldIDs.minMagnitudeFID, String.valueOf(opticalCameraControlParameters.getMinMagnitude().getValue()));
        this.publish(FieldIDs.maxMagnitudeFID, String.valueOf(opticalCameraControlParameters.getMaxMagnitude().getValue()));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        OpticalCameraControlParameters opticalCameraControlParameters = this.getOpticalCameraControlParameters();
        if (fieldID.equals(FieldIDs.randomOrderFID)) {
            boolean bl = (Boolean)object;
            opticalCameraControlParameters.setRandomizeOrder(bl);
        } else if (fieldID.equals(FieldIDs.minMagnitudeFID)) {
            opticalCameraControlParameters.getMinMagnitude().setValue(Double.parseDouble(string));
        } else if (fieldID.equals(FieldIDs.maxMagnitudeFID)) {
            opticalCameraControlParameters.getMaxMagnitude().setValue(Double.parseDouble(string));
        }
        return string;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        OpticalCameraControlParameters opticalCameraControlParameters = this.getOpticalCameraControlParameters();
        if (opticalCameraControlParameters != null) {
            Angle angle = opticalCameraControlParameters.getElevationLimit();
            this.getElevationLimitModel().setDocument((Object)angle);
            Angle angle2 = opticalCameraControlParameters.getAntennaPositionTolerance();
            this.getAntennaPositionToleranceModel().setDocument((Object)angle2);
            Time time = opticalCameraControlParameters.getSBMaximumTime();
            this.getSBMaximumTimeModel().setDocument(time);
        }
    }

    public ValueUnitPairModel getElevationLimitModel() {
        return this.elevationLimitModel;
    }

    public ValueUnitPairModel getAntennaPositionToleranceModel() {
        return this.antennaPositionToleranceModel;
    }
}

