/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.persistence.CredentialsProvider;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.submission.Data;
import alma.obsprep.services.submission.InOut;
import alma.obsprep.services.submission.RemoteProgressListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.exolab.castor.xml.XMLException;

public class ProjectRepositoryHttp
implements ProjectRepository {
    private final String HTTP_WEBAPP_URL = "/ObsprepSubmissionService/SubmissionService";
    private String urlString;
    private final String userAgent;
    private final CredentialsProvider ua;
    private final InOut inout;
    private final Log.Logger logger = Log.logger((Object)this);
    private String _host;
    private static final int EncodeFailed_IO = 50;
    private static final int EncodeFailed_Entity = 51;
    private static final int TalkToServer_IO = 53;
    private static final int DecodeFailed_Format = 56;
    private static final int DecodeFailed_XML = 57;
    private static final int DecodeFailed_IO = 58;
    private static final String PORTALSITE = "http://asa.alma.cl";

    public ProjectRepositoryHttp(CredentialsProvider credentialsProvider) {
        this.ua = credentialsProvider;
        this.inout = new InOut();
        this.userAgent = "ALMA-OT/" + InitServices.getFullAlmaVersion();
    }

    public void setUrl(String string) {
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = "/ObsprepSubmissionService/SubmissionService";
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.urlString = string + string2;
        this._host = string;
    }

    @Override
    public void delete(String string) throws PersistenceException {
        Data.DeleteResponseData deleteResponseData = null;
        try {
            Data.DeleteRequestData deleteRequestData = new Data.DeleteRequestData();
            deleteRequestData.projectId = string;
            InOut.RequestCharacteristics requestCharacteristics = new InOut.RequestCharacteristics();
            requestCharacteristics.urlString = this.urlString;
            requestCharacteristics.userAgent = this.userAgent;
            int n = 1;
            do {
                String[] stringArray;
                String[] stringArray2 = stringArray = 1 == n++ ? this.ua.getCredentials("Delete from Archive") : this.ua.getCredentialsAgain();
                if (stringArray == null) {
                    deleteResponseData = new Data.DeleteResponseData(401, null, null);
                    break;
                }
                deleteResponseData = this.inout.sendDelete(requestCharacteristics, deleteRequestData, stringArray);
            } while (deleteResponseData.status == 401);
        }
        catch (InOut.SendingException sendingException) {
            throw this.newClientSideError(53, sendingException);
        }
        catch (InOut.DecodingException decodingException) {
            throw this.newClientSideError(56, decodingException);
        }
        this.logger.fine("Request transmitted, response received. Response code: " + deleteResponseData.status);
        switch (deleteResponseData.status) {
            case 200: {
                return;
            }
        }
        throw this.newServerSideError(deleteResponseData.status, deleteResponseData.message);
    }

    @Override
    public String[][] query2(int n, String string, boolean bl, boolean bl2, RemoteProgressListener remoteProgressListener) throws PersistenceException {
        Data.Query2ResponseData query2ResponseData = null;
        try {
            Data.Query2RequestData query2RequestData = new Data.Query2RequestData();
            query2RequestData.searchVariant = n;
            query2RequestData.searchString = string;
            query2RequestData.caseSensitive = bl;
            query2RequestData.containsString = bl2;
            InOut.RequestCharacteristics requestCharacteristics = new InOut.RequestCharacteristics();
            requestCharacteristics.urlString = this.urlString;
            requestCharacteristics.userAgent = this.userAgent;
            int n2 = 1;
            do {
                String[] stringArray;
                String[] stringArray2 = stringArray = 1 == n2++ ? this.ua.getCredentials("Query the Archive") : this.ua.getCredentialsAgain();
                if (stringArray == null) {
                    query2ResponseData = new Data.Query2ResponseData(401, null, null);
                    break;
                }
                query2ResponseData = this.inout.sendQuery2(requestCharacteristics, query2RequestData, stringArray, remoteProgressListener);
            } while (query2ResponseData.status == 401);
        }
        catch (InOut.SendingException sendingException) {
            throw this.newClientSideError(53, sendingException);
        }
        catch (InOut.DecodingException decodingException) {
            throw this.newClientSideError(56, decodingException);
        }
        this.logger.fine("Request transmitted, response received. Response code: " + query2ResponseData.status);
        switch (query2ResponseData.status) {
            case 200: {
                return query2ResponseData.fields;
            }
        }
        throw this.newServerSideError(query2ResponseData.status, query2ResponseData.message);
    }

    @Override
    public ObsProject retrieve(String string, ProjectRepository.RetrieveVariant retrieveVariant) throws PersistenceException {
        Object object;
        Object object2;
        Data.RetrieveResponseData retrieveResponseData = null;
        try {
            object2 = new Data.RetrieveRequestData();
            ((Data.RetrieveRequestData)object2).projectId = string;
            ((Data.RetrieveRequestData)object2).retrieveVariant = retrieveVariant.toString();
            object = new InOut.RequestCharacteristics();
            ((InOut.RequestCharacteristics)object).urlString = this.urlString;
            ((InOut.RequestCharacteristics)object).userAgent = this.userAgent;
            int n = 1;
            do {
                String[] stringArray;
                String[] stringArray2 = stringArray = 1 == n++ ? this.ua.getCredentials("Retrieve from Archive") : this.ua.getCredentialsAgain();
                if (stringArray == null) {
                    retrieveResponseData = new Data.RetrieveResponseData(401, null, null);
                    break;
                }
                retrieveResponseData = this.inout.sendRetrieve((InOut.RequestCharacteristics)object, (Data.RetrieveRequestData)object2, stringArray);
            } while (retrieveResponseData.status == 401);
        }
        catch (InOut.SendingException sendingException) {
            throw this.newClientSideError(53, sendingException);
        }
        catch (InOut.DecodingException decodingException) {
            throw this.newClientSideError(56, decodingException);
        }
        this.logger.fine("Request transmitted, response received. Response code: " + retrieveResponseData.status);
        switch (retrieveResponseData.status) {
            case 200: {
                try {
                    object2 = new ByteArrayInputStream(retrieveResponseData.projectfile);
                    object = ImpexFactory.getInstance().importProject((InputStream)object2);
                    return object;
                }
                catch (XMLException xMLException) {
                    throw this.newClientSideError(57, (Exception)((Object)xMLException));
                }
                catch (IOException iOException) {
                    throw this.newClientSideError(58, iOException);
                }
            }
        }
        throw this.newServerSideError(retrieveResponseData.status, retrieveResponseData.message);
    }

    @Override
    public ObsProject store(ObsProject obsProject, ProjectRepository.StoreVariant storeVariant, RemoteProgressListener remoteProgressListener) throws PersistenceException {
        Object object;
        Object object2;
        Object object3;
        File file = null;
        try {
            file = File.createTempFile("tmp", ".aot");
            file.deleteOnExit();
            object3 = new FileOutputStream(file);
            ImpexFactory.getInstance().exportProject(obsProject, (OutputStream)object3, false, true);
            ((FileOutputStream)object3).close();
        }
        catch (IOException iOException) {
            throw this.newClientSideError(50, iOException);
        }
        catch (UnknownEntityException unknownEntityException) {
            throw this.newClientSideError(51, (Exception)((Object)unknownEntityException));
        }
        object3 = null;
        try {
            object2 = new Data.StoreRequestData();
            ((Data.StoreRequestData)object2).store = storeVariant.toString();
            ((Data.StoreRequestData)object2).files = Collections.singletonList(file);
            object = new InOut.RequestCharacteristics();
            ((InOut.RequestCharacteristics)object).urlString = this.urlString;
            ((InOut.RequestCharacteristics)object).userAgent = this.userAgent;
            int n = 1;
            do {
                String[] stringArray;
                String[] stringArray2 = stringArray = 1 == n++ ? this.ua.getCredentials("Store in Archive") : this.ua.getCredentialsAgain();
                if (stringArray == null) {
                    object3 = new Data.StoreResponseData(401, null, null);
                    break;
                }
                object3 = this.inout.sendStore((InOut.RequestCharacteristics)object, (Data.StoreRequestData)object2, stringArray, remoteProgressListener);
            } while (((Data.StoreResponseData)object3).status == 401);
        }
        catch (InOut.EncodingException encodingException) {
            throw this.newClientSideError(50, encodingException);
        }
        catch (InOut.SendingException sendingException) {
            throw this.newClientSideError(53, sendingException);
        }
        catch (InOut.DecodingException decodingException) {
            throw this.newClientSideError(56, decodingException);
        }
        this.logger.fine("Request transmitted, response received. Response code: " + ((Data.StoreResponseData)object3).status);
        switch (((Data.StoreResponseData)object3).status) {
            case 200: 
            case 201: {
                try {
                    object2 = new ByteArrayInputStream(((Data.StoreResponseData)object3).projectfile);
                    object = ImpexFactory.getInstance().importProject((InputStream)object2);
                    return object;
                }
                catch (XMLException xMLException) {
                    throw this.newClientSideError(57, (Exception)((Object)xMLException));
                }
                catch (IOException iOException) {
                    throw this.newClientSideError(58, iOException);
                }
            }
        }
        throw this.newServerSideError(((Data.StoreResponseData)object3).status, ((Data.StoreResponseData)object3).message);
    }

    PersistenceException newClientSideError(int n, Exception exception) {
        Object object;
        String string = switch (n) {
            case 50, 51 -> {
                object = "Could not assemble server request";
                yield null;
            }
            case 53 -> {
                object = "Could not contact the server";
                yield "Please check you can access the Internet.\nIf you are an ALMA staff user, your OT may be configured wrongly.";
            }
            case 56, 57, 58 -> {
                object = "Could not process server response";
                yield null;
            }
            default -> {
                object = "Operation failed [ " + n + " ]";
                yield null;
            }
        };
        Object object2 = object;
        if (object2 != null && exception != null) {
            object2 = (String)object2 + ": " + exception.getMessage();
        }
        String string2 = null;
        String string3 = null;
        return new PersistenceException((String)object2, exception, (String)object, string, string2, string3, n);
    }

    PersistenceException newServerSideError(int n, String string) {
        String string2;
        Object object;
        String string3 = this._host + " -- " + n;
        Throwable throwable = null;
        int n2 = n;
        Object object2 = string != null ? "The Server replied:\n" + string : "The Server did not send additional information";
        return new PersistenceException(string3, throwable, (String)object, switch (n) {
            case 400 -> {
                object = "Server complaint";
                string2 = null;
                yield "Create a technical error report, and contact ALMA helpdesk";
            }
            case 401 -> {
                object = "Invalid username or password";
                string2 = "Storing or retrieving a project requires a valid ALMA username and password.If you do not yet have an ALMA account, register at http://asa.alma.cl";
                yield "Check your username and password settings in the Connection settings";
            }
            case 403 -> {
                object = "You do not have permission";
                string2 = null;
                yield "If you think you got this error wrongly, contact the ALMA user administration";
            }
            case 404 -> {
                object = "Server not found at specified location";
                string2 = null;
                yield "Check your connection settings. If they are correct, there may be a problem with the server.\nPlease check the ALMA Science Portal for up-to-date information.";
            }
            case 406 -> {
                object = "Server will not serve this version of the Observing Tool";
                string2 = null;
                yield "Make sure you are using the latest version of the OT";
            }
            case 500 -> {
                object = "Server Error";
                string2 = null;
                yield "Please check the ALMA Science Portal for up-to-date information or try again later.";
            }
            case 503 -> {
                object = "Server is momentarily down";
                string2 = null;
                yield "Please check the ALMA Science Portal for up-to-date information or try again later.";
            }
            case 555 -> {
                object = "Server-side failure";
                string2 = null;
                yield "Please check the ALMA Science Portal for up-to-date information or try again later.";
            }
            case 417 -> {
                object = "A more recent version is already archived";
                string2 = "You have already archived a more recent version of your project, it cannot be overwritten with an older version";
                yield "Work with the most recent version.";
            }
            case 409 -> {
                object = "A more recent version is already archived";
                string2 = "You have already archived a more recent version of your project, but a forced overwrite will be allowed";
                yield "Work with the most recent version, or overwrite it forcefully.";
            }
            case 422 -> {
                object = "Server complains project is invalid";
                string2 = "Your project did not pass server-side validation. Projects can only be submitted when they contain no validation errors.";
                yield "Run validation in the OT, and fix any errors reported by it.\nIf you are an ALMA staff user, your OT may be configured wrongly.";
            }
            case 423 -> {
                object = "Attempt to submit outside deadline";
                string2 = string;
                yield null;
            }
            default -> {
                object = "Operation failed [ " + n2 + " ]";
                string2 = null;
                yield null;
            }
        }, string2, (String)object2, n2);
    }
}

