/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.ot.gui.factory.Tree;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import javax.swing.TransferHandler;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;

public class OTTree
extends Tree {
    private final int m_phase;
    private final boolean m_userView;
    private GuiApi guiAPI;
    public static final int PHASE_1 = 1;
    public static final int PHASE_2 = 2;
    private volatile boolean sizesRecalculationNeeded;
    private final AbstractJob sizesRecalculation = new AbstractJob("recalcSizes", false){
        {
            this.setExecutor(JobUtility.swing);
        }

        @Override
        public void job() {
            BasicTreeUI basicTreeUI = (BasicTreeUI)OTTree.this.getUI();
            basicTreeUI.setLeftChildIndent(basicTreeUI.getLeftChildIndent());
            OTTree.this.sizesRecalculationNeeded = false;
        }
    };
    private volatile boolean repaintMaybeNeeded;
    private final AbstractJob repaint = new AbstractJob("repaint", false){
        {
            this.setExecutor(JobUtility.oneSecondLater);
        }

        @Override
        public void job() throws Exception {
            OTTree.this.repaint();
            OTTree.this.repaintMaybeNeeded = false;
        }
    };
    private boolean isDebugRendering = false;

    @Override
    public void setUI(TreeUI treeUI) {
        super.setUI(treeUI);
        TransferHandler transferHandler = this.getTransferHandler();
        this.setTransferHandler(null);
        this.setTransferHandler(transferHandler);
    }

    public OTTree(TreeModel treeModel, int n, boolean bl) {
        super(treeModel);
        this.m_phase = n;
        this.m_userView = bl;
        this.guiAPI = new GuiApi.Default();
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2 = "";
        if (object != null) {
            try {
                ProjectTreeNode projectTreeNode = (ProjectTreeNode)object;
                BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
                object2 = businessObject.toTreeString(this.m_phase, this.m_userView, bl2);
                if (this.isDebugRendering) {
                    object2 = (String)object2 + " || " + businessObject.toString();
                }
            }
            catch (ClassCastException classCastException) {
                object2 = object.toString();
            }
        }
        return object2;
    }

    void sizesRecalculationNeeded() {
        if (this.sizesRecalculationNeeded) {
            return;
        }
        this.sizesRecalculationNeeded = true;
        this.sizesRecalculation.go();
    }

    public void repaintMaybeNeeded() {
        if (this.repaintMaybeNeeded) {
            return;
        }
        this.repaintMaybeNeeded = true;
        this.repaint.go();
    }

    public void toggleDebugRendering() {
        this.isDebugRendering = !this.isDebugRendering;
    }

    public void setGuiApi(GuiApi guiApi) {
        this.guiAPI = guiApi;
    }

    public ColorPalette getColorPalette() {
        return this.guiAPI.getColorPalette();
    }
}

