/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.AbstractScienceGoalData;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.P2GActionInterface;
import alma.obsprep.ot.scripting.P2GXMLActionPerformer;
import alma.obsprep.ot.scripting.bindings.RegenerateSBAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class RegenerateSBPerformer
extends P2GXMLActionPerformer
implements P2GActionInterface {
    private final List<RegenerateSBAction> regenerateSBActions;

    RegenerateSBPerformer(@NonNull BatchOT batchOT, @NonNull List<RegenerateSBAction> list, boolean bl) throws P2GXMLActionPerformer.InputParameterValidationException {
        super(bl, batchOT);
        if (batchOT == null) {
            throw new NullPointerException("batchOTHelper is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("regenerateSBActions is marked non-null but is null");
        }
        actionName = "<RegenerateSB>";
        this.regenerateSBActions = list;
        this.validateRequestedActions();
    }

    @Override
    public void validateRequestedActions() throws P2GXMLActionPerformer.InputParameterValidationException {
        HashSet<String> hashSet = new HashSet<String>();
        for (RegenerateSBAction regenerateSBAction : this.regenerateSBActions) {
            if (!RegenerateSBPerformer.verifyUID(regenerateSBAction.getProjectuid())) {
                throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("RegenerateSBAction: The UID " + regenerateSBAction.getProjectuid() + " is not specified correctly");
            }
            for (String string : regenerateSBAction.getSciencegoal()) {
                if (hashSet.contains(string)) {
                    throw (P2GXMLActionPerformer)this.new P2GXMLActionPerformer.InputParameterValidationException("RegenerateSBAction: The science goal " + string + " has been specified multiple times");
                }
                hashSet.add(string);
            }
        }
    }

    @Override
    public void startAction() throws P2GActionInterface.UnableToCompleteActionException {
        for (RegenerateSBAction regenerateSBAction : this.regenerateSBActions) {
            String string = regenerateSBAction.getProjectuid();
            this.consoleOutput("Updating SBs in the project " + string);
            P2GXMLActionPerformer.ProjectTopLevelEntities projectTopLevelEntities = this.fetchProjectFromArchive(string);
            ObsProgram obsProgram = projectTopLevelEntities.getObsProgram();
            List<ScienceGoal> list = null;
            try {
                list = this.findScienceGoalsInObsProgram(regenerateSBAction, obsProgram);
            }
            catch (UnknownScienceGoalsInRegenerationActionException unknownScienceGoalsInRegenerationActionException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unknownScienceGoalsInRegenerationActionException);
            }
            String string2 = list.stream().map(AbstractScienceGoalData::getName).collect(Collectors.joining(","));
            this.consoleOutput("SBs being regenerated for " + string2);
            this.batchOTHelper.generate(obsProgram, list);
            try {
                this.storeProject(projectTopLevelEntities.getObsProject(), "SBs in project " + string + " updated in archive");
            }
            catch (Exception exception) {
                this.consoleOutput("Unable to store project " + string + " : " + exception.getMessage());
                throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
            }
        }
    }

    private List<ScienceGoal> findScienceGoalsInObsProgram(@NonNull RegenerateSBAction regenerateSBAction, @NonNull ObsProgram obsProgram) throws UnknownScienceGoalsInRegenerationActionException {
        if (regenerateSBAction == null) {
            throw new NullPointerException("regenerateAction is marked non-null but is null");
        }
        if (obsProgram == null) {
            throw new NullPointerException("obsProgram is marked non-null but is null");
        }
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>();
        HashSet<String> hashSet = new HashSet<String>();
        AbstractScienceGoal[] abstractScienceGoalArray = obsProgram.getAbstractScienceGoal();
        for (String string : regenerateSBAction.getSciencegoal()) {
            hashSet.add(string);
            Stream.of(abstractScienceGoalArray).filter(abstractScienceGoal -> abstractScienceGoal.getName().equals(string)).forEach(abstractScienceGoal -> {
                arrayList.add((ScienceGoal)((Object)abstractScienceGoal));
                hashSet.remove(abstractScienceGoal.getName());
            });
        }
        if (!hashSet.isEmpty()) {
            String string = hashSet.stream().collect(Collectors.joining(","));
            throw new UnknownScienceGoalsInRegenerationActionException("The following science goals were not found in the project " + regenerateSBAction.getProjectuid() + ": " + (String)string);
        }
        return arrayList;
    }

    public class UnknownScienceGoalsInRegenerationActionException
    extends Exception {
        public UnknownScienceGoalsInRegenerationActionException(String string) {
            super(string);
        }
    }
}

