/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.corrconfig;

import alma.ACS.stringSeqHolder;
import alma.CorrConfigModeErr.wrappers.AcsJConstructorFailureEx;
import alma.correlatorSrc.CorrConfigValidator.BL_XMLParser;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidator;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.obstooluserprefs.types.BLCorrelatorType;
import alma.obsprep.ot.valdef.corrconfig.CorrConfigValidatorWrapper;

public class BLCorrConfigValidatorWrapper
implements CorrConfigValidatorWrapper {
    private final CorrConfigValidator validator;
    private final BL_XMLParser parser;
    private final Log.Logger logger = Log.logger((Object)this);

    public BLCorrConfigValidatorWrapper() throws AcsJConstructorFailureEx {
        String string = this.getCorrelatorType();
        this.validator = new CorrConfigValidator(string);
        this.logger.fine("Validating against BL correlator type : " + string);
        this.parser = new BL_XMLParser();
    }

    @Override
    public String getCorrelatorType() {
        return System.getProperty("BLCorrelator", BLCorrelatorType.CORRELATOR_12M_4QUADRANT.toString());
    }

    @Override
    public int getMaxNumAntennas(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        int n;
        try {
            n = Array.ARRAY_12M.getNumberAntennasForDataRates(abstractCorrelatorConfiguration);
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            throw new IllegalArgumentException("Unable to determine number of antennas for 12-m array: " + receiverNotFoundException.getMessage());
        }
        return n;
    }

    @Override
    public boolean validateSpectralSpec(SpectralSpec spectralSpec, int n, stringSeqHolder stringSeqHolder2) {
        return this.validator.validateSpectralSpec(spectralSpec.toXml(), n, stringSeqHolder2);
    }
}

