/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.etc.DGCTimeEstimatesPointingCalculator;
import alma.obsprep.services.etc.GeneralPurposeTimeEstimatesPointingCalculator;
import alma.obsprep.services.etc.SpectralScanTimeEstimatesPointingCalculator;
import alma.obsprep.services.etc.TimeEstimatesPointingCalculatorInterface;
import alma.obsprep.services.generator.refactored.DGCExpert;
import lombok.NonNull;

public class TimeEstimatesPointingCalculatorFactory {
    public static TimeEstimatesPointingCalculatorInterface getPointingCalculator(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        TimeEstimatesPointingCalculatorInterface timeEstimatesPointingCalculatorInterface = scienceGoal.isSpectralScan() ? new SpectralScanTimeEstimatesPointingCalculator() : (DGCExpert.getExpert(false).isDGCScheduled(scienceGoal, true) ? new DGCTimeEstimatesPointingCalculator() : new GeneralPurposeTimeEstimatesPointingCalculator());
        assert (timeEstimatesPointingCalculatorInterface != null);
        return timeEstimatesPointingCalculatorInterface;
    }
}

