/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.valuetypes.Time;
import lombok.NonNull;

public class TimeSummary {
    private Long numberOfCalibrationExecutions = 0L;
    private final CalType type;
    private Time totalCalibrationTime = Time.createTimeSec(0.0);
    private boolean isAtmCalIncluded = false;
    private CalObs calibrationObservation;
    String calibrationStrategyUsed;

    TimeSummary(@NonNull CalType calType) {
        if (calType == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = calType;
    }

    public void addTime(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        this.totalCalibrationTime.aggregate(time);
    }

    public void addNumExec(Long l) {
        this.numberOfCalibrationExecutions = this.numberOfCalibrationExecutions + l;
    }

    public void setTotalCalibrationTime(Time time) {
        this.totalCalibrationTime = time.deepCopy();
    }

    public boolean isStandardSystemCalibrationStrategyUsed() {
        return this.calibrationStrategyUsed.equals(CalibrationSetupParameters.SELECTION_SYSTEM);
    }

    public boolean isSSOCalibrationStrategyUsed() {
        return this.calibrationStrategyUsed.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE);
    }

    public Time getTimeForSingleCalibration() {
        return (Time)this.totalCalibrationTime.divide(this.numberOfCalibrationExecutions.longValue());
    }

    public String toString() {
        return "TimeSummary(numberOfCalibrationExecutions=" + this.getNumberOfCalibrationExecutions() + ", type=" + String.valueOf((Object)this.getType()) + ", totalCalibrationTime=" + String.valueOf(this.getTotalCalibrationTime()) + ", isAtmCalIncluded=" + this.isAtmCalIncluded() + ", calibrationObservation=" + String.valueOf(this.getCalibrationObservation()) + ", calibrationStrategyUsed=" + this.getCalibrationStrategyUsed() + ")";
    }

    public void setNumberOfCalibrationExecutions(Long l) {
        this.numberOfCalibrationExecutions = l;
    }

    public Long getNumberOfCalibrationExecutions() {
        return this.numberOfCalibrationExecutions;
    }

    public CalType getType() {
        return this.type;
    }

    public Time getTotalCalibrationTime() {
        return this.totalCalibrationTime;
    }

    public boolean isAtmCalIncluded() {
        return this.isAtmCalIncluded;
    }

    public void setCalibrationObservation(CalObs calObs) {
        this.calibrationObservation = calObs;
    }

    public CalObs getCalibrationObservation() {
        return this.calibrationObservation;
    }

    public String getCalibrationStrategyUsed() {
        return this.calibrationStrategyUsed;
    }

    public void setCalibrationStrategyUsed(String string) {
        this.calibrationStrategyUsed = string;
    }
}

