/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.services.experts.CalibratorExpert;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class BackgroundCalibratorDatabaseInteractor
extends CalibratorExpert {
    private static final long COMMUNICATION_TIMEOUT_SECS = 900L;
    final Stopwatch stopWatch = Stopwatch.createUnstarted();
    private static BackgroundCalibratorDatabaseInteractor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BackgroundCalibratorDatabaseInteractor getInstance() {
        if (instance != null) return instance;
        Class<BackgroundCalibratorDatabaseInteractor> clazz = BackgroundCalibratorDatabaseInteractor.class;
        synchronized (BackgroundCalibratorDatabaseInteractor.class) {
            if (instance != null) return instance;
            instance = new BackgroundCalibratorDatabaseInteractor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void resetCalibratorDatabaseCommsTimer() {
        this.stopWatch.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Measurement> query(@NonNull CatalogQueryParameters catalogQueryParameters) throws IOException {
        if (catalogQueryParameters == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (this.catalog == null) {
            return Collections.emptyList();
        }
        Stopwatch stopwatch = this.stopWatch;
        synchronized (stopwatch) {
            if (this.stopWatch.isRunning() && this.stopWatch.elapsed(TimeUnit.SECONDS) < 900L) {
                throw new IOException();
            }
            this.stopWatch.reset();
        }
        try {
            stopwatch = this.catalog.getCatalogAccess();
            if (!this.clientDefinedCataloguesToQuery.isEmpty()) {
                stopwatch.setCatalogsToQuery(this.clientDefinedCataloguesToQuery);
            }
            return stopwatch.query(catalogQueryParameters);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.logger(BackgroundCalibratorDatabaseInteractor.class).warning("Starting calibrator database timeout of 900 seconds");
            Stopwatch stopwatch2 = this.stopWatch;
            synchronized (stopwatch2) {
                this.stopWatch.start();
            }
            throw exception;
        }
    }
}

