/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ReceiverTemperature;
import alma.obsprep.util.Range;
import alma.valuetypes.Frequency;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ReceiverExpert {
    private Set<ReceiverBand> rxset = new HashSet<ReceiverBand>();
    private static ReceiverExpert _instance = null;

    public static ReceiverExpert getInstance() {
        if (_instance == null) {
            _instance = new ReceiverExpert();
        }
        return _instance;
    }

    public static void refresh() {
        _instance = null;
    }

    private ReceiverExpert() {
        this.rxset.addAll(ReceiverBand.getKnownReceiverBands());
    }

    public Set<ReceiverBand> getAllReceivers() {
        return this.rxset;
    }

    public boolean isValidFrequency(double d) {
        for (ReceiverBand receiverBand : this.rxset) {
            if (!receiverBand.isValidFrequency(d)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOverlap(double d) {
        Set<ReceiverBand> set = this.getSuitableReceiverSet(d);
        return set.size() > 1;
    }

    public Optional<Set<ReceiverBand>> getOverlapBands(double d) {
        Optional<Set<ReceiverBand>> optional = Optional.empty();
        Set<ReceiverBand> set = this.getSuitableReceiverSet(d);
        if (set.size() > 1) {
            optional = Optional.of(set);
        }
        return optional;
    }

    public Set<ReceiverBand> getSuitableReceiverSet(double d) {
        HashSet<ReceiverBand> hashSet = new HashSet<ReceiverBand>();
        for (ReceiverBand receiverBand : this.rxset) {
            if (!receiverBand.isValidFrequency(d)) continue;
            hashSet.add(receiverBand);
        }
        return hashSet;
    }

    public Set<ReceiverBand> getSuitableReceiverSet(double d, double d2) {
        Set<ReceiverBand> set = this.getSuitableReceiverSet(d);
        Set<ReceiverBand> set2 = this.getSuitableReceiverSet(d2);
        HashSet<ReceiverBand> hashSet = new HashSet<ReceiverBand>();
        for (ReceiverBand receiverBand : set) {
            if (!set2.contains(receiverBand)) continue;
            hashSet.add(receiverBand);
        }
        return hashSet;
    }

    public Set<ReceiverBand> getSuitableReceiverSet(Range<Frequency> range) {
        return this.getSuitableReceiverSet(range.min().getContentInGHz(), range.max().getContentInGHz());
    }

    public ReceiverBand getBestReceiver(double d) {
        Set<ReceiverBand> set = this.getSuitableReceiverSet(d);
        ReceiverBand receiverBand = null;
        double d2 = -1.0;
        for (ReceiverBand receiverBand2 : set) {
            if (!(receiverBand2.getSuitabilityRating(d) > d2)) continue;
            d2 = receiverBand2.getSuitabilityRating(d);
            receiverBand = receiverBand2;
        }
        return receiverBand;
    }

    public double getReceiverTemperature(double d) throws InvalidFrequencyException {
        return ReceiverTemperature.getReceiverTemperature(d);
    }
}

