/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.hla.runtime.obsprep.util.Log;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

class SLCThreadFactory
implements ThreadFactory {
    static final UEHLogger uehLogger = new UEHLogger();
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;

    SLCThreadFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        thread.setUncaughtExceptionHandler(uehLogger);
        return thread;
    }

    static class UEHLogger
    implements Thread.UncaughtExceptionHandler {
        UEHLogger() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.SEVERE, "Thread terminated with exception: " + thread.getName(), throwable);
        }
    }
}

