/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;

public class SelectedLinesTableFormat
implements AdvancedTableFormat<SpectralLine> {
    public static final String INCOMPATIBLE_WITH_SPECTRAL_SETUP = "[Incompatible with spectral setup] - ";
    private final Velocity velocity;

    public SelectedLinesTableFormat(Velocity velocity) {
        this.velocity = velocity.deepCopy();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Transition";
            }
            case 1: {
                return "Description";
            }
            case 2: {
                return "Rest Frequency";
            }
            case 3: {
                return "Sky Frequency";
            }
        }
        throw new IllegalStateException();
    }

    public Object getColumnValue(SpectralLine spectralLine, int n) {
        switch (n) {
            case 0: {
                if (spectralLine.isLineOutsideOfSPWRange()) {
                    return INCOMPATIBLE_WITH_SPECTRAL_SETUP + spectralLine.getTitle();
                }
                return spectralLine.getTitle();
            }
            case 1: {
                return spectralLine.getDescription();
            }
            case 2: {
                return spectralLine.getFrequency().getContentInUnits(Frequency.UNIT_HZ);
            }
            case 3: {
                Frequency frequency = spectralLine.getFrequency().dopplerShifted(this.velocity);
                return frequency.getContentInUnits(Frequency.UNIT_HZ);
            }
        }
        throw new IllegalStateException();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
        }
        throw new IllegalStateException();
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 0: {
                return GlazedLists.caseInsensitiveComparator();
            }
            case 1: {
                return GlazedLists.caseInsensitiveComparator();
            }
            case 2: {
                return GlazedLists.comparableComparator();
            }
            case 3: {
                return GlazedLists.comparableComparator();
            }
        }
        throw new IllegalStateException();
    }
}

