/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.CalibratedObservatoryGoalFieldSourceWorker;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class ObservatoryGoalFieldSourceWorker {
    private final CalibratedObservatoryGoalFieldSourceWorker worker;
    private final ObservatoryGoal goal;

    public ObservatoryGoalFieldSourceWorker(ObservatoryGoal observatoryGoal) {
        this.worker = new CalibratedObservatoryGoalFieldSourceWorker(observatoryGoal);
        this.goal = observatoryGoal;
        this.addTargetFieldSources(this.worker.getTargetFieldSources());
        this.worker.calculate();
    }

    public Queue<FieldSource> getCalibratorFieldSources(String string) {
        return this.worker.getCalibratorFieldSources(string);
    }

    public Queue<Target> getCalibratorTargets(String string) {
        return this.worker.getCalibratorTargets(string);
    }

    public ObservingGroup getTargetsObservingGroup() {
        return this.worker.getTargetsObservingGroup();
    }

    public ObservingGroup getInitialCalibrationObservingGroup() {
        return this.worker.getInitialCalibrationObservingGroup();
    }

    public List<Target> getTargets() {
        return this.worker.getTargets();
    }

    public List<FieldSource> getTargetFieldSources() {
        return this.worker.getTargetFieldSources();
    }

    public FieldSource getRepresentativeFieldSource() {
        List<FieldSource> list = this.getTargetFieldSources();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private void addTargetFieldSources(List<FieldSource> list) throws WizardSBGenerationException {
        List<FieldSource> list2 = this.goal.getUseQuery() ? this.getTargetFieldSourcesForQuery() : this.getFieldSourcesForUserDefinedTargets();
        list.addAll(list2);
    }

    private List<FieldSource> getFieldSourcesForUserDefinedTargets() {
        ArrayList<FieldSource> arrayList = new ArrayList<FieldSource>();
        for (ObservatoryGoalTargetParameters observatoryGoalTargetParameters : this.goal.getObservatoryGoalTargetParameters()) {
            FieldSource fieldSource = FieldSource.createFieldSource();
            this.setupTargetFieldSource(observatoryGoalTargetParameters, fieldSource);
            arrayList.add(fieldSource);
        }
        return arrayList;
    }

    private List<FieldSource> getTargetFieldSourcesForQuery() {
        alma.obsprep.bo.obsproject.QuerySource querySource = this.goal.getObservatoryGoalQueryParameters();
        QuerySource querySource2 = QuerySource.createQuerySource(querySource);
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.setIsQuery(true);
        fieldSource.setQuerySource(querySource2);
        fieldSource.setName("Virtual field source");
        fieldSource.setSourceName(fieldSource.getName());
        fieldSource.setFieldPattern((FieldPattern)((Object)this.getPointingPattern()));
        ArrayList<FieldSource> arrayList = new ArrayList<FieldSource>();
        arrayList.add(fieldSource);
        return arrayList;
    }

    private void setupTargetFieldSource(ObservatoryGoalTargetParameters observatoryGoalTargetParameters, FieldSource fieldSource) {
        Object object;
        fieldSource.setSourceName(observatoryGoalTargetParameters.gettrueSourceName());
        if (observatoryGoalTargetParameters.gettrueSourceName() != null) {
            fieldSource.setName(observatoryGoalTargetParameters.getSourceName());
        }
        if ((object = observatoryGoalTargetParameters.gettrueSourceCoordinates()) != null) {
            fieldSource.setSourceCoordinates((SkyCoordinates)object.deepCopy());
        }
        if ((object = observatoryGoalTargetParameters.gettrueSourceVelocity()) != null) {
            fieldSource.setSourceVelocity((Velocity)object.deepCopy());
        }
        for (CalibrationTargetProperties calibrationTargetProperties : observatoryGoalTargetParameters.getCalibrationTargetProperties()) {
            SourceProperty sourceProperty = SourceProperty.createSourceProperty();
            sourceProperty.setSourceFluxI(calibrationTargetProperties.getFlux().deepCopy());
            sourceProperty.setSourceFrequency(calibrationTargetProperties.getFrequency().deepCopy());
            fieldSource.addSourceProperty(sourceProperty);
        }
        PointingPattern pointingPattern = this.getPointingPattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        fieldSource.setIsQuery(false);
        fieldSource.setNonSiderealMotion(false);
    }

    private PointingPattern getPointingPattern() {
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        pointingPattern.setType(PointingPattern.TYPE_POINT);
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_RELATIVE);
        skyCoordinates.setLongitude(Longitude.createLongitude((double)0.0, (String)Longitude.UNIT_ARCMIN));
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Latitude.UNIT_ARCMIN));
        pointingPattern.setPhaseCenterCoordinates(new SkyCoordinates[]{skyCoordinates});
        return pointingPattern;
    }
}

