/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.obsproject.DataProcessingParameters;
import alma.obsprep.bo.obsproject.FlowControl;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.AbstractSBGenerator;
import alma.obsprep.services.generator.ObservatoryGoalSchedBlockWorker;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class ObservatoryGoalSBGenerator
extends AbstractSBGenerator {
    private final ObservatoryGoalSchedBlockWorker sbworker;
    private final ObservatoryGoal goal;

    public ObservatoryGoalSBGenerator(ObservatoryGoal observatoryGoal, ObsUnitSet obsUnitSet) {
        super(null, obsUnitSet);
        this.sbworker = new ObservatoryGoalSchedBlockWorker(observatoryGoal);
        this.goal = observatoryGoal;
    }

    @Override
    public void generate() throws WizardSBGenerationException {
        if (!this.canGenerate()) {
            return;
        }
        this.setupOUS(this.obsUnitSet);
        for (SchedBlock schedBlock : this.sbworker.getSchedBlocks()) {
            this.obsUnitSet.addSchedBlock(schedBlock);
            schedBlock.setObsUnitSet(this.obsUnitSet);
        }
    }

    private void setupOUS(ObsUnitSet obsUnitSet) {
        obsUnitSet.setName(this.goal.getPurpose());
        obsUnitSet.setScienceProcessingScript("");
        obsUnitSet.setRunSciencePipeline(false);
        this.configure(obsUnitSet.getObsUnitControl());
        this.configure(obsUnitSet.getUnitDependencies());
        this.configure(obsUnitSet.getDataProcessingParameters());
        this.configure(obsUnitSet.getFlowControl());
    }

    private void configure(FlowControl flowControl) {
        flowControl.setControlScript("");
    }

    private void configure(DataProcessingParameters dataProcessingParameters) {
        dataProcessingParameters.setProjectType("Continuum");
        dataProcessingParameters.setAngularResolution(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        Velocity velocity = Velocity.createVelocity();
        velocity.setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
        velocity.setDopplerCalcType(Velocity.DOPPLERCALCTYPE_OPTICAL);
        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        dataProcessingParameters.setVelocityResolution(velocity);
        dataProcessingParameters.setTBSensitivityGoal(Temperature.createTemperature((double)0.0, (String)Temperature.UNIT_K));
        dataProcessingParameters.setRMSGoal(Sensitivity.createSensitivity((double)0.0, (String)Sensitivity.UNIT_JY));
    }

    private void configure(UnitDependencies unitDependencies) {
        unitDependencies.setExecutionCount(1);
        unitDependencies.setDelay(Time.createTime((double)0.0, (String)Time.UNIT_S));
        unitDependencies.setExpression("");
    }

    private void configure(ObsUnitControl obsUnitControl) {
        obsUnitControl.setArrayRequested(ControlBlock.ARRAYREQUESTED_TWELVE_M);
        obsUnitControl.setMaximumTime(Time.createTime((double)0.0, (String)Time.UNIT_S));
        obsUnitControl.setEstimatedExecutionTime(Time.createTime((double)0.0, (String)Time.UNIT_S));
        this.configure(obsUnitControl.getCalibrationRequirements());
    }

    private void configure(CalibrationRequirements calibrationRequirements) {
        calibrationRequirements.setPointingAccuracy(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
    }

    public static void main(String[] stringArray) throws IOException, MarshalException, ValidationException, UnknownEntityException {
        SpectralSetupParameters spectralSetupParameters = SpectralSetupParameters.createSpectralSetupParameters();
        spectralSetupParameters.getSourceVelocity().setCenterVelocity(Speed.createSpeed());
        spectralSetupParameters.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        spectralSetupParameters.setType(SpectralSetupParameters.TYPE_CONTINUUM);
        ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.addScienceSpectralWindow(-1, 0);
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(230.0);
        ObservatoryGoal observatoryGoal = ObservatoryGoal.createRadiometricPointingGoal();
        observatoryGoal.getCalibrationSetupParameters().setSelection(CalibrationSetupParameters.SELECTION_USER);
        observatoryGoal.setSpectralSetupParameters(spectralSetupParameters);
        observatoryGoal.setIntegrationTime(Time.createTimeSec(60.0));
        ObservatoryGoalTargetParameters observatoryGoalTargetParameters = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        observatoryGoalTargetParameters.setSourceName("target 1");
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        skyCoordinates.setLatitude(Latitude.createLatitude((double)10.0, (String)Latitude.UNIT_DEG));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)10.0, (String)Longitude.UNIT_DEG));
        observatoryGoalTargetParameters.setSourceCoordinates(skyCoordinates);
        observatoryGoal.addObservatoryGoalTargetParameters(observatoryGoalTargetParameters);
        observatoryGoal.setUseQuery(false);
        ObservatoryGoalTargetParameters observatoryGoalTargetParameters2 = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        observatoryGoalTargetParameters2.setSourceName("target 2");
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createSkyCoordinates();
        skyCoordinates2.setLatitude(Latitude.createLatitude((double)1.0, (String)Latitude.UNIT_DEG));
        skyCoordinates2.setLongitude(Longitude.createLongitude((double)1.0, (String)Longitude.UNIT_DEG));
        observatoryGoalTargetParameters2.setSourceCoordinates(skyCoordinates2);
        observatoryGoal.addObservatoryGoalTargetParameters(observatoryGoalTargetParameters2);
        observatoryGoal.setUseQuery(false);
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        ObservatoryGoalSBGenerator observatoryGoalSBGenerator = new ObservatoryGoalSBGenerator(observatoryGoal, obsUnitSet);
        observatoryGoalSBGenerator.generate();
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = new Marshaller((Writer)stringWriter);
        marshaller.setValidation(false);
        marshaller.marshal((Object)obsUnitSet.getSchedBlock(0).getCastorObject());
        System.out.println(stringWriter.toString());
    }
}

