/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.AbstractCalibratorParametersFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;

public class ScienceGoalCalibratorParametersFactory
extends AbstractCalibratorParametersFactory {
    public ScienceGoalCalibratorParametersFactory(SpectralSpec spectralSpec) {
        super(spectralSpec);
    }

    @Override
    public AmplitudeCalParameters getAmplitudeCalParameters(int n) {
        AmplitudeCalParameters amplitudeCalParameters = AmplitudeCalParameters.createAmplitudeCalParameters();
        amplitudeCalParameters.setCycleTime(Time.createTime((double)2.0, (String)Time.UNIT_H));
        amplitudeCalParameters.setName("");
        amplitudeCalParameters.setDefaultIntegrationTime(Time.createTime((double)3.0, (String)Time.UNIT_MIN));
        amplitudeCalParameters.setSubScanDuration(Time.createTimeSec(30.0));
        this.setMissingParameters((CalibratorParameters)((Object)amplitudeCalParameters), n);
        return amplitudeCalParameters;
    }

    @Override
    public AtmosphericCalParameters getAtmosphericCalParameters(int n) {
        AtmosphericCalParameters atmosphericCalParameters = AtmosphericCalParameters.createAtmosphericCalParameters();
        atmosphericCalParameters.setDefaultIntegrationTime(Time.createTime((double)4.0, (String)Time.UNIT_S));
        atmosphericCalParameters.setUseHotLoad(true);
        double d = 2.0;
        atmosphericCalParameters.setSubScanDuration(Time.createTime((double)d, (String)Time.UNIT_S));
        this.setMissingParameters((CalibratorParameters)((Object)atmosphericCalParameters), n);
        return atmosphericCalParameters;
    }

    @Override
    public BandpassCalParameters getBandpassCalParameters(int n) {
        BandpassCalParameters bandpassCalParameters = BandpassCalParameters.createBandpassCalParameters();
        bandpassCalParameters.setDesiredPhaseAccuracy(Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC));
        bandpassCalParameters.setMaximumElapsedTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        bandpassCalParameters.setSubScanDuration(Time.createTime((double)30.0, (String)Time.UNIT_S));
        bandpassCalParameters.setDefaultIntegrationTime(Time.createTimeSec(60.0));
        this.setMissingParameters((CalibratorParameters)((Object)bandpassCalParameters), n);
        return bandpassCalParameters;
    }
}

